/*


Copyright (c) 2004 Arthur Huillet.

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/











#include <stdio.h>
#include <allegro.h>
#include <stdarg.h>
#include <string.h>
#include "log_fac.h"



FILE * logfile[10];
static int filedest=0;
static int filenb=0;
static int nbhandlers;


/**
reallocates memory to msg_hdl according to nbhandlers value
*/
int realloue_msg_hdl()
{
msg_hdl=(message_hdl *)realloc(msg_hdl, nbhandlers*sizeof(message_hdl));
if(msg_hdl)
    return 0;
else return -1;
}



/*makes the initialization of the logging facility : 
-allocates base memory to msg_hdl (3handlers)
*/
int init_logfac()
{
msg_hdl=(message_hdl *)calloc(3,sizeof(message_hdl));
/*nbhandlers++;*/
return 0;
}


/*exits logfac : 
-closes opened logfiles
-frees memory
*/
int exit_logfac()
{
int i;
for(i=0; i < filenb; i++)
    fclose(logfile[i]);
free(msg_hdl);
return 0;
}


int log_msg(unsigned short int msg_debuglvl, const char *fmt, ...)
{
int i;
char already_logged = 0; /*bitmask*/
va_list ap;
va_start(ap, fmt);
for(i=0; i < nbhandlers; i++)
        {
        if(msg_hdl[i].debuglvl >= msg_debuglvl)
                {
                if(!(already_logged & (1 << msg_hdl[i].log_action)))
                        {
                        already_logged |= (1 << msg_hdl[i].log_action);
                        switch(msg_debuglvl)
                                {
                                case 0: log_with_rule(i, "[EE]", fmt, ap); break;
                                case 1: log_with_rule(i, "[++]", fmt, ap); break;
                                case 2: log_with_rule(i, "[II]", fmt, ap); break;
                                case 3: log_with_rule(i, "[DD]", fmt, ap); break;
                                default: log_with_rule(i, "[unknown]", fmt, ap);
                                }
                        }
                }
        }
return 0;
}



/************ user interface*/

int add_rule(message_hdl newrule)
{
nbhandlers++;
realloue_msg_hdl();
msg_hdl[nbhandlers-1]=newrule;
msg_hdl[nbhandlers-1].rule_num=nbhandlers-1;
return nbhandlers-1;
}


int get_hdl_nb()
{
return nbhandlers;
}



int open_newlog(const char *path)
{

if(filenb>=10)
    return -1;

filenb++;
logfile[filenb-1]=fopen(path,"w");

if(!logfile[filenb-1])
    return -1;
return filenb-1;
}




int log_with_rule(int rulenum, const char *prefix, const char *fmt, va_list args)
{
message_hdl *filtered_rl = &msg_hdl[rulenum];

switch(filtered_rl->log_action)
	{
	case LOGTO_STDERR: log_to_stderr(prefix, fmt, args);break;
	case LOGTO_STDOUT: log_to_stdout(prefix, fmt, args);break;
	case LOGTO_DEVNULL: log_to_devnull(prefix, fmt, args);break;
	case LOGTO_FILE: log_to_file(prefix, fmt, args);break;
	};
	
return 0;
}



/*"low-level" logging functions */

int log_to_stderr(const char *prefix, const char * fmt, va_list args)
{
vfprintf(stderr,prefix,args);
vfprintf(stderr,"  ",args);
vfprintf(stderr,fmt,args);


if(prefix[strlen(prefix)-1]=='\n') /*a little control for \n*/
    return 0;
else
    vfprintf(stderr,"\n",args);
    
return 0;
}


int log_to_stdout(const char *prefix, const char * fmt, va_list args)
{
vfprintf(stdout,prefix,args);
vfprintf(stdout,"  ",args);
vfprintf(stdout,fmt,args);
if(prefix[strlen(prefix)-1]=='\n') /*a little control for \n*/
    return 0;
else
    vfprintf(stdout,"\n",args);

return 0;
}

int log_to_devnull(const char *prefix,const char *fmt,va_list args)
{
int no_op[10];
no_op[0]=prefix[0];
no_op[1]=fmt[0];
no_op[2]=va_arg(args,int);
return 0;
}

int log_to_file(const char *prefix, const char * fmt, va_list args)
{

if(!logfile[filedest]) /*we must check the FILE * pointer is okay*/
    return -1;
vfprintf(logfile[filedest],prefix,args);
vfprintf(logfile[filedest],"  ",args);
vfprintf(logfile[filedest],fmt,args);
if(prefix[strlen(prefix)]=='\n') /*a little control for \n*/
    return 0;
else
    vfprintf(logfile[filedest],"\n",args); 

return 0;
}

