/*

Copyright (c) 2003-2005      Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */

#include <stdio.h>
#ifndef LEVELS_H
#define LEVELS_H

#define ZL_TEMPLATE_ELEVATOR 1



/*level-file parsing routines*/

/*

openfile
readfiletomem
closefile
parsemem, register objects
*/


FILE *level_xml_file;

void fin_instances(int);
int open_lvl_file(const char *); /*opens the level file*/
int close_lvl_file(); /*closes the file*/

int register_level_objects();
int parse_level_data();


int make_level_file(char *, char *, ...); /*makes a level file from the current
memory configuration of obj_db.
Writes it to the file you pass it*/



/*int GetLevelLine(char * ) simply puts an object-defining line, got from level_xml_file*/
int get_level_line(char * );

/*int RegisterNewxxxxxx(); returns a new number for the object type. Used to register new instances of
these objects, reallocates obj_db if needed*/
int register_new_player(char); /*player*/
int register_new_lwall(); /*wall*/
int register_new_wall(); /*livewall a.k.a. moving platform*/
int register_new_kl(); /*killing line*/
int register_new_portal(); /*portal to another level*/


/*int ReturnXxxxXml(char *, Xxxx *) sets the Xxx * object to the value
defined by the char * got from GetLevelLine, parsing the line
(parameters like refpt, width, height, etc*/
int return_player(char *, liveplayer *, char); /*players*/
int return_lwall(char *, livewall *); /*livewall*/
int return_wall(char *, wall *); /*wall*/
int return_kl(char *, killing_line *);
int return_portal(char *, portal *); /*portal*/

/*int ReturnValue(char *) is an helper function returning the int value corresponding to the
token you pass it - for exemple, pass width="50", it will return 50..*/
int return_value(char *);



int init_object_options(char *); /*initializes object options parsing*/
short int get_object_option(const char * option_name, short int if_present); /*looks for an object option*/
char *get_level_string(const char *, const char *, char *, char *); /*gets a string from the level :
const char * line, const char *parameter, char *def, char *cible
soit : ligne dans laquelle rechercher le paramtre avec une valeur par dfaut def
placer le rsultat dans cible*/

int set_refpoint(point * , char *); /*lecture d'une ligne format refpt="xxx;yyy" et remplissage
d'une structure point associe*/


int display_level_info(char *); /*displays information (log_msg...) about current levelfile*/

int set_template(livewall *, int); /*sets livewall default according to the template it is passed*/

int runtime_level_loader(char *level_file); /*level loading while the game is running*/


#endif
