/*

Copyright (c) 1999,2002-2005    Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */
    
#include "all_inc.h"  
#define GAMESPEED 50 

/*timer related variables*/
int speed_counter = 150;
int game_spd_counter = 1;
int fps_counter = 0;
int render_fps = 0;
int last_fps = 1;
int avg_fps = 20;
int nb_fps_cycles = 0;
int cyclecount = 0;
int counting_cycles = 0;
/*parameters*/
int GAME_PAUSED=0;
int USE_TIMERS=1;
/***/
int fini;

/*init_xxx functions in zlog.c*/
void init_player();
void init_walls();
void init_weapons();
void init_frame();
void init_bullets();


/*
void increment_speed_counter()
{
        speed_counter++;
}
END_OF_FUNCTION(increment_speed_counter)*/

void increment_game_spd_counter()
{
        game_spd_counter++;
}
END_OF_FUNCTION(increment_game_spd_counter)

void fps_timer()
{
        last_fps=fps_counter;
        fps_counter=0;
        nb_fps_cycles++;
        avg_fps=((nb_fps_cycles-1)*avg_fps+last_fps)/nb_fps_cycles;
}
END_OF_FUNCTION(fps_timer)


/***********************************************************/

        #define ZLOG_GAME_BASE()                int end_get_touche=0;                                   \
                log_msg(2, "game() initiated");                        \
                init_player();                                          \
                init_weapons();                                 \
                init_bullets();                                         \
                init_walls();                                           \
                obj_db.screen_pos.x=1;                          \
                obj_db.screen_pos.y=1;                          \
                log_msg(2, "All objects are now defined ");            \
                log_msg(2, "First display...done !");                  \
                clear_keybuf();                         \
                rest(500);                                      \
                zl_screen_msgbox("Ready to go", "\tZlog is now ready. Move with the arrow keys, toggle running with 'r', save the game with 'j' and load it again with 'h'. The debugging console may be accessed with 'c' and 'ctrl + shift + c'.\n \n\tAs you will notice, Zlog needs graphics. If you happen to know an artist who could make them, please contact me (the address is in the README file).", ZL_MESSAGE_BUTTONBOX, "Play");\
                                                                                        \
                while(!keypressed())                                    \
                        rest(1);                                                        \


/* int game() initialisation des paramtres du jeu et boucle principale*/

int game()
{
        ZLOG_GAME_BASE()
        
	LOCK_VARIABLE(speed_counter);
	LOCK_FUNCTION(increment_game_spd_counter);
	LOCK_FUNCTION(fps_timer);

	LOCK_VARIABLE(game_spd_counter);
	LOCK_VARIABLE(last_fps);
	LOCK_VARIABLE(fps_counter);
	LOCK_VARIABLE(nb_fps_cycles);
	LOCK_VARIABLE(avg_fps);



	install_int_ex(increment_game_spd_counter, BPS_TO_TIMER(GAMESPEED));
	install_int_ex(fps_timer,SECS_TO_TIMER(1));


	log_msg(2, "INT. handlers okay");


while(!end_get_touche){
        while(game_spd_counter > 0)
                {
                end_get_touche=main_loop();
                if(end_get_touche) break;
                cyclecount++;
                end_get_touche=main_loop();
                if(end_get_touche) break;
                cyclecount++;
                end_get_touche=main_loop();
                cyclecount++;
                display_all();
                fps_counter++;
                game_spd_counter--;
                while(game_spd_counter == 0)
                                rest(1);
                }
        
    
    
}

remove_int(increment_game_spd_counter);
remove_int(fps_timer);

return 0;
}

/******************************************************/

int game_no_timers()
{
        ZLOG_GAME_BASE()

        while(!end_get_touche){
                end_get_touche=main_loop();
                if(end_get_touche) break;
                cyclecount++;
                rest(5);
                end_get_touche=main_loop();
                if(end_get_touche) break;
                cyclecount++;
                rest(5);
                end_get_touche=main_loop();
                cyclecount++;
                display_all();
                rest(5);
        }

return 0;
}

/********************************************************/
int pause()
{
int fin = 0;
        if(USE_TIMERS)
        {
                remove_int(increment_game_spd_counter);
                remove_int(fps_timer);
        }
        
        while(!fin)
        {
                display_all();
                rest(50);
                
                if (key [key_pause] && !(pltoggle_ispressed_flag & 2))
                        {
                        pltoggle_ispressed_flag |= 2;        
                        fin=1;
                        }
                if(!key[key_pause])
                        pltoggle_ispressed_flag &= ~2;
                        
                        
                if(key[key_console])
                        {
                        if(!(pltoggle_ispressed_flag & 16))
                                {
                                pltoggle_ispressed_flag |= 16;
                                if(!CONSOLE_IS_ACTIVE) bring_console();
                                else stop_console();
                                }
                        }
                else pltoggle_ispressed_flag &= ~16;
                        
                if(key[key_quit])
                {
                        return 1;
                }
        }
                        
        log_msg(1,"Game resumed.");
        GAME_PAUSED=0;
        if(USE_TIMERS)
        {
                install_int_ex(increment_game_spd_counter, BPS_TO_TIMER(GAMESPEED));
                install_int_ex(fps_timer,SECS_TO_TIMER(1));
        }
return 0;
}

/**********************************************************/
int zl_screen_msgbox(const char * title, const char * msg, const char action, void * parm)
{
        extern char page_flip;
int to_return = 0;
/*first of all, check the action*/
if(action != ZL_MESSAGE_TIMEWAIT && action != ZL_MESSAGE_BUTTONBOX && action != ZL_MESSAGE_YESNOBOX)
        return 1;

log_msg(3, "Displaying message box on the screen : %s", msg);
GAME_PAUSED = 1;
if(USE_TIMERS)
        {
        remove_int(increment_game_spd_counter);
        remove_int(fps_timer);
        }
                        
rectfill(game_frame[page_num], 0.15 * RESOL_X, 0.15 * zlogframe.l, 0.85 * RESOL_X, 0.85 * zlogframe.l, 0);
rect(game_frame[page_num], 0.15 * RESOL_X, 0.15 * zlogframe.l, 0.85 * RESOL_X, 0.85 * zlogframe.l, 255);
/*65 chars per line maximum*/
/*10 pixels between two lines*/
char * msgoffset = (char *)msg;
char msgline[80];
if(title)
        textout_centre_ex(game_frame[page_num], font, title, 0.5 * RESOL_X, 0.15 * zlogframe.l + 0.7 * 0.2 * zlogframe.l, 4, -1);
for(int y = 0.15 * zlogframe.l + 0.7 * 0.35 * zlogframe.l; y < 0.85 * zlogframe.l - 40; y += 10)
        {
        memset(msgline, 0, 80);
        int done = 0;
        unsigned int charcount = 0;
        while(charcount <= 65 && charcount < strlen(msgoffset) /*&& ( msgoffset[charcount] != ' ' || msgoffset[charcount] != '\n')*/)
                {
                charcount ++;
                if((charcount > 55 && msgoffset[charcount] == ' ') || msgoffset[charcount] == '\n')
                        break;
                }
        if(msgoffset[0] == ' ') msgoffset ++;
        
        if(charcount >= strlen(msgoffset))
               done = 1;
        strncpy(msgline, msgoffset, charcount);
        for(unsigned int i = 0; i < strlen(msgline); i++)
                {
                if(msgline[i] == '\n') msgline[i] = ' ';
                if(msgline[i] == '\t') msgline[i] = ' ';
                }
        msgoffset += charcount;
        textout_justify_ex(game_frame[page_num], font, msgline, 0.2 * RESOL_X, 0.8 * RESOL_X, y, 80, 255, -1);
 
        if(done) break;
        }

        if(action == ZL_MESSAGE_BUTTONBOX)
                {/*display the button*/
                rectfill(game_frame[page_num], 0.15 * RESOL_X + 0.7 * 0.4 * RESOL_X, 0.85 * zlogframe.l - 30, 0.15 * RESOL_X + 0.7 * 0.6 * RESOL_X, 0.85 * zlogframe.l - 5, 21);
                rect(game_frame[page_num], 0.15 * RESOL_X + 0.7 * 0.4 * RESOL_X, 0.85 * zlogframe.l - 30, 0.15 * RESOL_X + 0.7 * 0.6 * RESOL_X, 0.85 * zlogframe.l - 5, 255);

                char btnstr[15]; 
                memset(btnstr, 0, 15);
                if(parm) strncpy(btnstr, (char *)parm, 15);
                else strncpy(btnstr, "OK", 10);
                btnstr[14] = 0;
                textout_centre_ex(game_frame[page_num], font, btnstr, 0.15 * RESOL_X + 0.7 * 0.5 * RESOL_X, 0.85 * zlogframe.l - 20, 255, -1);
                }
                
        if(action == ZL_MESSAGE_YESNOBOX)
                {/*display the buttons*/
                rectfill(game_frame[page_num], 0.15 * RESOL_X + 0.7 * 0.3 * RESOL_X, 0.85 * zlogframe.l - 30, 0.15 * RESOL_X + 0.7 * 0.45 * RESOL_X, 0.85 * zlogframe.l - 5, 21);
                rectfill(game_frame[page_num], 0.15 * RESOL_X + 0.7 * 0.55 * RESOL_X, 0.85 * zlogframe.l - 30, 0.15 * RESOL_X + 0.7 * 0.7 * RESOL_X, 0.85 * zlogframe.l - 5, 21);
                rect(game_frame[page_num], 0.15 * RESOL_X + 0.7 * 0.3 * RESOL_X, 0.85 * zlogframe.l - 30, 0.15 * RESOL_X + 0.7 * 0.45 * RESOL_X, 0.85 * zlogframe.l - 5, 255);
                rect(game_frame[page_num], 0.15 * RESOL_X + 0.7 * 0.55 * RESOL_X, 0.85 * zlogframe.l - 30, 0.15 * RESOL_X + 0.7 * 0.7 * RESOL_X, 0.85 * zlogframe.l - 5, 255);

                textout_centre_ex(game_frame[page_num], font, "Yes", 0.15 * RESOL_X + 0.7 * 0.37 * RESOL_X, 0.85 * zlogframe.l - 20, 255, -1);
                textout_centre_ex(game_frame[page_num], font, "No", 0.15 * RESOL_X + 0.7 * 0.63 * RESOL_X, 0.85 * zlogframe.l - 20, 255, -1);
                }
        
if(!page_flip)
        {    

        if(!is_memory_bitmap(ecranv[0]))
                vsync();

        acquire_screen();
        blit(ecranv[0], screen, 0,0,0,0,RESOL_X,RESOL_Y);
        release_screen();
        }
else {
        show_video_bitmap(ecranv[page_num]);
        page_num = 1-page_num;
        }
        
        
if(action == ZL_MESSAGE_TIMEWAIT)
        {
        int time_to_wait = (int)parm;
        if(! time_to_wait)
                time_to_wait = 40 * strlen(msg);
        log_msg(3, "Message box : waiting %i milliseconds", time_to_wait);
        rest(time_to_wait);
        }
        
if(action == ZL_MESSAGE_BUTTONBOX)
                {
                while(key[KEY_ENTER] || key[KEY_SPACE])
                        rest(10);
                while(!key[KEY_ENTER] && !key[KEY_SPACE])
                        rest(10);
                }
                
if(action == ZL_MESSAGE_YESNOBOX)
                {
                while(key[KEY_Y] || key[KEY_N])
                        rest(10);
                while(!key[KEY_Y] && !key[KEY_N])
                        rest(10);
                if(key[KEY_Y])
                        {
                        if(parm) *(int *)parm = 1;
                        to_return=1;
                        }
                if(key[KEY_N])
                        {
                        if(parm) *(int *)parm = 0;
                        to_return=0;
                        }
                }
        
                
/*unpause the game*/
GAME_PAUSED=0;
if(USE_TIMERS)
        {
        install_int_ex(increment_game_spd_counter, BPS_TO_TIMER(GAMESPEED));
        install_int_ex(fps_timer,SECS_TO_TIMER(1));
        }
        
return to_return;
}
/*********************************************************/

int main_loop()
{
int plrt;
scheduler();
do_scroll(0);  
/*update_mouse(); temporarily disabled*/
   /*LIVEWALLS*/
make_livewalls();
update_enemies();
cycle_object_sprites();
update_liveplatforms_sprites();
    /*JUMP & FALL*/
   
for(plrt=0; plrt<obj_db.nombre_perso; plrt++)
	{
        liveplayer * target = &obj_db.perso[plrt];
	target->state |= ZL_PLAYER_IDLE;
        target->state &= ~ZL_SPRITE_ANIMATE;
        handle_player_zignals(target);
	make_jump(target);
	make_inertia(target);
	player_adj_coord(target);
        }
        
for(plrt=0; plrt<obj_db.nombre_enemies; plrt++)
	{
        liveplayer * target = &obj_db.enemies[plrt];
	target->state |= ZL_PLAYER_IDLE;
        target->state &= ~ZL_SPRITE_ANIMATE;
        handle_player_zignals(target);
	make_jump(target);
	make_inertia(target);
	player_adj_coord(target);
        }       

if(!CONSOLE_IS_ACTIVE)
        get_keypress();
else get_console_input();
return(fini);
}





/*********************************************/

/*********int get_keypress()*/
int get_keypress()
{
int plrot = 0;
for (plrot = 0; plrot < obj_db.nombre_perso ; plrot ++)
        {
        liveplayer * target = &obj_db.perso[plrot];

            
       if (key[pl_kbinds[DROITE][plrot]])
			{        
        	if(! (target->state & ZL_PLAYER_RUNNING))
				pl_move_right(&obj_db.perso[plrot], (float) (target->moving_spd.x));
            else
            	pl_move_right(&obj_db.perso[plrot], (float) (target->moving_spd.x * 1.5));
           	}
             
        if (key[pl_kbinds[GAUCHE][plrot]])
        	{
        	if(! (target->state & ZL_PLAYER_RUNNING))
				pl_move_left(&obj_db.perso[plrot], (float) (target->moving_spd.x));
            else
            	pl_move_left(&obj_db.perso[plrot], (float) (target->moving_spd.x * 1.5));
           	}
             

                        
        if(key[pl_kbinds[SAUT][plrot]])	
             {
             if(!(target->state & ZL_PLAYER_JPRESSED))
             	{ /*if the key was not pressed last cycle*/
             	target->state|=ZL_PLAYER_JPRESSED; /*it is pressed, now*/
             	if (!(target->state & ZL_PLAYER_JUMPING)) /*if we are not already jumping*/
                	if(target->no_xxx & NO_DOWN) /*if we are not falling*/
                   		setjump(target); /*make him jump*/
                }
             }
        
        else {	  /*if the key's not pressed*/
		     target->state&=~ZL_PLAYER_JPRESSED;	    	 
             if(target->state & ZL_PLAYER_JUMPING)
                 request_eojump(plrot);   
             }
  
    
    	/*lecture des switches*/
        if(key[pl_kbinds[RUN][plrot]])
                {
                if(!(pltoggle_ispressed_flag & 1))
                        {
                        pltoggle_ispressed_flag |= 1;
                        if(target->state & ZL_PLAYER_RUNNING)
                                obj_db.perso[plrot].state &= ~ZL_PLAYER_RUNNING;
                        else 
                                obj_db.perso[plrot].state |= ZL_PLAYER_RUNNING;
                        }
                }
                else
                        pltoggle_ispressed_flag &= ~1;
                
                
        
        
        if(key[pl_kbinds[CH_WEAP][plrot]])
    	        {
                ch_arme(plrot,target->armenb+1);
    	        }   
                
        if(key[key_pause])
                { /*remove timers, set GAME_PAUSED to 1*/
                if (!(pltoggle_ispressed_flag & 2))
                        {
                        pltoggle_ispressed_flag |= 2;
                        log_msg(1,"Game paused.");
                        GAME_PAUSED=1;
                        fini = pause();
                        }
                }
        else pltoggle_ispressed_flag &= ~2;
                
             
        
        if(key[KEY_J])
                {
                if(!(pltoggle_ispressed_flag & 4))
                        {
                        pltoggle_ispressed_flag |= 4;
                        create_savefile("test.sav");
                        zl_save_game();
                        }
                }
        else pltoggle_ispressed_flag &= ~4;
                
        if(key[KEY_H])
                {
                if(!(pltoggle_ispressed_flag & 8))
                        {
                        pltoggle_ispressed_flag |= 8;
                        if(!load_savefile("test.sav"))
                                {
                                zl_load_game();
                                zl_load_link_binary_data();
                                }
                        }
                }
        else pltoggle_ispressed_flag &= ~8;
        
        if(key[key_console])
                {
                if(!(pltoggle_ispressed_flag & 16))
                        {
                        pltoggle_ispressed_flag |= 16;
                        /*temporary removing*/
                        if(!CONSOLE_IS_ACTIVE) bring_console();
                        else stop_console();
                        }
                }
        else pltoggle_ispressed_flag &= ~16;
        
         if(key[KEY_PLUS_PAD])
	         gravite += 0.0050;
        

        if(key[KEY_MINUS_PAD])
             if(gravite >= 0.005)
             	gravite -= 0.0050;
        
        if(key[KEY_Y])
                {
                        int ceciestuntest = 0;
                zl_screen_msgbox("Test", "Ceci est un test assez long du systme d'affichage des messages de Zlog. Normalement, le programme est capable d'afficher du texte justifi et \nd'aller  la ligne\n lorsque c'est ncessaire. Sgolne est-elle belle ?", ZL_MESSAGE_YESNOBOX,  &ceciestuntest/*(void *)3000*/);
                if(ceciestuntest)
                                zl_screen_msgbox("Pas touche", "Trouvez vous quelqu'un d'autre, elle est  moi.", ZL_MESSAGE_BUTTONBOX, NULL);
                else {
                        zl_screen_msgbox("Prcision", "Vous trouvez que Sgolne n'est pas belle. C'est vrai que l'habillement laisse  dsirer, mais diriez-vous qu'elle est belle une fois nue ou habille correctement ?", ZL_MESSAGE_YESNOBOX, &ceciestuntest);
                        if(ceciestuntest)
                                zl_screen_msgbox("Pas touche", "Merci de me donner raison mais pas touche, mme en rve.", ZL_MESSAGE_BUTTONBOX, "J'accepte");
                        else zl_screen_msgbox("Mauvais got", "Au moins il n'y aura pas de concurrence. Mais vous avez mauvais got.", ZL_MESSAGE_TIMEWAIT, NULL);
                        }
                }

}	





/*
if(key[KEY_L])
    {
    clear_keybuf();
    rest(2500);
    log_msg(1,"Making level file \"leveledit.xml\"");
    make_level_file("leveledit.xml","This is an useless description");
    }*/

if(key[key_quit])
	fini=1;
	

return 0;
} /*fin de la fonction*/
	
	
/****************************************************/
