/*

Copyright (c) 2004-2005      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */



#include "all_inc.h"



extern char page_flip;
extern volatile int speed_counter;
extern volatile int fps_counter;
extern volatile int render_fps;
extern volatile int last_fps;
extern volatile int avg_fps;
extern volatile int nb_fps_cycles;
extern int cyclecount;


/* void display_cadre() : affichage du cadre principal de l'cran */
void display_cadre(gamescreen where)
{
rect(ecranv[page_num], where.cadrehg.x, where.cadrehg.y, where.cadrebd.x, where.cadrebd.y, 3);
}

/******************/



/* int disp_pl() affichage du personnage et de son arme */


int disp_pl(liveplayer * target)
{
extern int bpp;
/* affichage du player */
int l=target->xsize;
int L=target->ysize;
point plrefpt;
point nw,se;
int color = 1 << (bpp -  8);

plrefpt.x=target->refpt.x-obj_db.screen_pos.x;
plrefpt.y=target->refpt.y-obj_db.screen_pos.y;

if(color == 16)
        color --;
if(target->state & ZL_PLAYER_INVINCIBLE)
        color = 4;
        
if(target->current_sprite)
        draw_sprite(game_frame[page_num], target->current_sprite->spr, plrefpt.x, plrefpt.y);
else
        rectfill(game_frame[page_num],plrefpt.x,plrefpt.y,plrefpt.x+l,plrefpt.y+L, color);

/* affichage de l'obj_db.armenb[playernb] */

/*assignations de dpart*/
nw=plrefpt;


/*assignations modifies pour l'obj_db.armenb[playernb] : */

if(target->direction==2)
{/*si on va sur la droite*/
    nw.x+=((l)/4)*3; /*on dcale au trois quarts de la xsize du perso*/
    se.x=nw.x+ 25; 
        
    nw.y+=((L)/18)*5;
    se.y=nw.y+ 6;
    
}

if(target->direction==1)
{/*si on va sur la gauche*/
    nw.x+=((l)/4);
    nw.x-= 25; 
    se.x=plrefpt.x+((l)/4);
    
    
    nw.y+=((L)/18)*5;
    se.y=nw.y + 6;
}

rectfill(game_frame[page_num], nw.x, nw.y, se.x, se.y, target->armenb+1);
    
/*if(! playernb)
line(game_frame[page_num], (nw.x + se.x)/2, (nw.y + se.y) / 2, obj_db.perso[0].xsize /2 + obj_db.perso[0].refpt.x - obj_db.screen_pos.x + rel_mouse_pos_x,\
        obj_db.perso[0].ysize /2 + obj_db.perso[0].refpt.y - obj_db.screen_pos.y + rel_mouse_pos_y, 15);*/

return(0);
}
/*********************/

/****************/

int disp_kline(int klnb)
{
int posx=obj_db.klines[klnb].position.x-obj_db.screen_pos.x;
int posy=obj_db.klines[klnb].position.y-obj_db.screen_pos.y;
int taille=obj_db.klines[klnb].taille;
if(obj_db.klines[klnb].to_disp)
	rectfill(game_frame[page_num], posx, posy, posx+taille, posy+2, 5);
return 0;
}

/*****************************/

int disp_portal(int portalnb)
{
portal *target = &obj_db.portals[portalnb];
rect(game_frame[page_num], target->position.x - obj_db.screen_pos.x, target->position.y - obj_db.screen_pos.y, (target->position.x + target->xsize) - obj_db.screen_pos.x, (target->position.y + target->ysize) - obj_db.screen_pos.y, 4);
return 0;
}

/***********************/


int disp_wall(int wallnb)
{
int l, L, color;
extern int bpp;
point wallrefpt;
        if(obj_db.walls[wallnb].parms & WL_IS_INVISIBLE)
                return 1;
/* affichage du mur */
l=obj_db.walls[wallnb].xsize;
L=obj_db.walls[wallnb].ysize;
color = wallnb * (1 << (bpp -8)) + 1;

wallrefpt.x=obj_db.walls[wallnb].refpt.x-obj_db.screen_pos.x;
wallrefpt.y=obj_db.walls[wallnb].refpt.y-obj_db.screen_pos.y;
if (color == 16 || color == 17 || color == 18)
        color=15;

if(obj_db.walls[wallnb].sprite)
        draw_sprite(game_frame[page_num], *obj_db.walls[wallnb].sprite, wallrefpt.x, wallrefpt.y);
else
        rectfill(game_frame[page_num], wallrefpt.x, wallrefpt.y, wallrefpt.x+l, wallrefpt.y+L, color);
return 0;
}


/*******************************************/
void display_background()
{

unsigned int modx, mody;
unsigned int x, y;
int starrot;

modx = (/*obj_db.screen_pos.x - */background_offset_x) % 384;
mody = (/*obj_db.screen_pos.y - */background_offset_y) % 384;


for(starrot=0; starrot < nombre_stars; starrot ++)
        {
        
        if(stars[starrot].x > modx)
                x = stars[starrot].x - modx;
        else
                x = stars[starrot].x - modx + 384;
        for(; x < zlogframe.L; x += 384)
                {
                if(stars[starrot].y > mody)
                        y = stars[starrot].y - mody;
                else
                        y = stars[starrot].y - mody + 384;
                for(; y < RESOL_Y; y += 384)
                        {
                        putpixel(game_frame[page_num], x, y, stars[starrot].color);
                        if(!(starrot % 10))
                                stars[starrot].color = rand();
                        }
                }
        }
}

/***********************************************/
void display_console()
{
/*rectfill(console_frame[page_num], 1, 1, zlogframe.L - 4, 149, 18);*/
/*display the text field*/
rect(console_frame[page_num], 1, zl_console.console_size  - 18, zlogframe.L - 4, zl_console.console_size - 2, 14);
/*display the current command being typed*/
textprintf_ex(console_frame[page_num], font, 5, zl_console.console_size - 13, 255, -1, "> %s", zl_console.currentcmd);
/*display the cursor*/
vline(console_frame[page_num], 21 + zl_console.cur_pos * 8, zl_console.console_size - 14, zl_console.console_size - 5, 15);

/*now display the history*/
int entrynb=0;
console_history * cmdrot = zl_console.cmd_history;

while(zl_console.console_size - 20 - 12*entrynb > 5)
        {/*while we can display the string on the screen*/
        if(cmdrot == NULL)
                break;
        if(cmdrot->content == NULL)
                break;
        
        if(cmdrot->content)
                if(strlen(cmdrot->content))
                        {
                        if(cmdrot->content[0] != '!') /*then it is a command*/
                                {
                                textprintf_ex(console_frame[page_num], font, 5, zl_console.console_size - 30 - 12*entrynb, 255, -1, "%% %s", (cmdrot->content));
                                }
                        else
                                textprintf_ex(console_frame[page_num], font, 5, zl_console.console_size - 30 - 12*entrynb, 255, -1, "    %s", (cmdrot->content + 2));
                        entrynb++;
                        }
        if(cmdrot->NEXT)
                cmdrot = (console_history *)cmdrot->NEXT;
        if(cmdrot->NEXT == NULL)
                break;
        }
               


}


/*********************************************/
void display_stats()
{

int plrot=0;


textprintf_ex(ecranv[page_num],font,610,zlogframe.cadrebd.y+11,255,-1,"ScreenPos [%i;%i]",\
                                obj_db.screen_pos.x, obj_db.screen_pos.y);
textprintf_ex(ecranv[page_num], font, 610, zlogframe.cadrebd.y + 25, 255, -1, "Gravite %f", gravite);
for(plrot=statsplayer; plrot < obj_db.nombre_perso; plrot++)
    {
    if(plrot > statsplayer+2)
        break;
    textprintf_ex(ecranv[page_num],font,5+(200*plrot),zlogframe.cadrebd.y+11,255,-1,"%s %i,%i",obj_db.perso[plrot].name,\
                    obj_db.perso[plrot].refpt.x,obj_db.perso[plrot].refpt.y);
    
    textprintf_ex(ecranv[page_num],font,5+(200*plrot),zlogframe.cadrebd.y+11+fontsize,255,-1,"Arme %i",obj_db.perso[plrot].armenb);

    rect(ecranv[page_num],5+(200*plrot),zlogframe.cadrebd.y+11+2*fontsize,(200*plrot)+105,zlogframe.cadrebd.y+21+2*fontsize,4);
    rectfill(ecranv[page_num],5+(200*plrot),zlogframe.cadrebd.y+12+2*fontsize,5+(200*plrot)+obj_db.perso[plrot].life,\
                    zlogframe.cadrebd.y+20+2*fontsize,5);    

    
    
    if(MODE_DEBUG_ACTIF && (perso_to_debug >= 0))
        { /*si on dbuggue un player*/
                
                /*informations relatives aux coordones*/
                textprintf_ex(ecranv[page_num], font, 5, zlogframe.cadrebd.y+ 11 + 4*(fontsize+2), 255, -1, "ysize : %i xsize : %i",obj_db.perso[perso_to_debug].ysize, obj_db.perso[perso_to_debug].xsize);
                textprintf_ex(ecranv[page_num], font, 5, zlogframe.cadrebd.y+ 11 + 6*(fontsize+2), 255,-1, "Ref %i", obj_db.perso[perso_to_debug].ref_pform);
                textprintf_ex(ecranv[page_num], font, 5, zlogframe.cadrebd.y+ 11 + 7*(fontsize+2), 255,-1, "Dzone %i", delay_to_deadzone);
                textprintf_ex(ecranv[page_num], font, 5, zlogframe.cadrebd.y+ 11 + 5*(fontsize+2), 255, -1, "x+ %f y+ %f", obj_db.perso[perso_to_debug].add_x, obj_db.perso[perso_to_debug].add_y);
                
                /*flags du player courant*/
                textprintf_ex(ecranv[page_num], font, 700, zlogframe.cadrebd.y+ 11 + 6*(fontsize+2), 255, -1, "Jmp %i Jpd %i", obj_db.perso[perso_to_debug].state & ZL_PLAYER_JUMPING, obj_db.perso[perso_to_debug].state & ZL_PLAYER_JPRESSED);
                
                textprintf_ex(ecranv[page_num], font, 700, zlogframe.cadrebd.y+ 11 + 4*(fontsize+2), 255, -1, "Nol %i Nor %i", obj_db.perso[perso_to_debug].no_xxx & NO_LEFT, obj_db.perso[perso_to_debug].no_xxx & NO_RIGHT);
                textprintf_ex(ecranv[page_num], font, 700, zlogframe.cadrebd.y+ 11 + 3*(fontsize+2), 255, -1, "Nou %i Nod %i", obj_db.perso[perso_to_debug].no_xxx & NO_UP, obj_db.perso[perso_to_debug].no_xxx & NO_DOWN);
                textprintf_ex(ecranv[page_num], font, 700, zlogframe.cadrebd.y+ 11 + 5*(fontsize+2), 255, -1, "Idl %i Run %i", obj_db.perso[perso_to_debug].state & ZL_PLAYER_IDLE, obj_db.perso[perso_to_debug].state & ZL_PLAYER_RUNNING);
                textprintf_ex(ecranv[page_num], font, 610, zlogframe.cadrebd.y+ 11 + 6*(fontsize+2), 255, -1, "Zig %i %i", obj_db.perso[perso_to_debug].zignals.mask, obj_db.perso[perso_to_debug].zignals.parm[1][0]);
                
                /*informations relatives au saut en cours*/
                textprintf_ex(ecranv[page_num], font, 250, zlogframe.cadrebd.y+ 11 + 4*(fontsize+2), 255, -1, "Jti %f",obj_db.perso[perso_to_debug].jtime);
                textprintf_ex(ecranv[page_num], font, 250, zlogframe.cadrebd.y+ 11 + 5*(fontsize+2), 255, -1, "Spd x %f y %f",obj_db.perso[perso_to_debug].current_spd.x, obj_db.perso[perso_to_debug].current_spd.y);
                textprintf_ex(ecranv[page_num], font, 250, zlogframe.cadrebd.y+ 11 + 6*(fontsize+2), 255, -1, "MovSpd x %f y %f",obj_db.perso[perso_to_debug].moving_spd.x, obj_db.perso[perso_to_debug].moving_spd.y);
                textprintf_ex(ecranv[page_num], font, 250, zlogframe.cadrebd.y+ 11 + 7*(fontsize+2), 255, -1, "BJSpd %f MJSpd %f",obj_db.perso[perso_to_debug].base_jumping_speed, obj_db.perso[perso_to_debug].max_jumping_speed);
        }
        
        
     if(MODE_DEBUG_ACTIF && (pform_to_debug >= 0) && (perso_to_debug==-1))
        {  
        
            textprintf_ex(ecranv[page_num], font, 500, 550, 255,-1, "Pform #%i", pform_to_debug);
            textprintf_ex(ecranv[page_num], font, 500, 560, 255,-1, "%i;%i", obj_db.lwalls[pform_to_debug].refpt.x, obj_db.lwalls[pform_to_debug].refpt.y);
            textprintf_ex(ecranv[page_num], font, 500, 570, 255,-1, "State %i", obj_db.lwalls[pform_to_debug].state);
            textprintf_ex(ecranv[page_num], font, 500, 580, 255,-1, "Spd %i/%i", obj_db.lwalls[pform_to_debug].speed, obj_db.lwalls[pform_to_debug].speed & ZL_DIVIDE_SPD);
            textprintf_ex(ecranv[page_num], font, 350, 570, 255,-1, "Basemvt %i;%i", obj_db.lwalls[pform_to_debug].base_mvt.x, obj_db.lwalls[pform_to_debug].base_mvt.y);
            textprintf_ex(ecranv[page_num], font, 350, 580, 255,-1, "Rinert %f", obj_db.lwalls[pform_to_debug].resist_inert);
            textprintf_ex(ecranv[page_num], font, 500, 590, 255,-1, "L %i l %i", obj_db.lwalls[pform_to_debug].ysize, obj_db.lwalls[pform_to_debug].xsize);
            textprintf_ex(ecranv[page_num], font, 600, 590, 255,-1, "Mvt L %i W %i", obj_db.lwalls[pform_to_debug].mvt_ysize, obj_db.lwalls[pform_to_debug].mvt_xsize);
            textprintf_ex(ecranv[page_num], font, 600, 550, 255,-1, "dx %i dy %i", obj_db.lwalls[pform_to_debug].dx, obj_db.lwalls[pform_to_debug].dy);
            textprintf_ex(ecranv[page_num], font, 600, 560, 255,-1, "Direction %i", obj_db.lwalls[pform_to_debug].state & DIRECTION);
            textprintf_ex(ecranv[page_num], font, 600, 580, 255,-1, "Nl %i Nr %i Nu %i Nd %i",\
obj_db.lwalls[pform_to_debug].no_xxx & NO_LEFT, obj_db.lwalls[pform_to_debug].no_xxx & NO_RIGHT, \
obj_db.lwalls[pform_to_debug].no_xxx & NO_UP, obj_db.lwalls[pform_to_debug].no_xxx & NO_DOWN);
	    textprintf_ex(ecranv[page_num], font, 620, 570, 255,-1, "P. %i", obj_db.lwalls[pform_to_debug].state & LWL_PAUSE_MVT);
	}
            
    }
}


/********************************************/

int disp_lwall(int lwallnb)
{
int l, L, color;
point lwallrefpt;
        if(obj_db.lwalls[lwallnb].parms & WL_IS_INVISIBLE)
                return 1;
/* affichage du mur */
l=obj_db.lwalls[lwallnb].xsize;
L=obj_db.lwalls[lwallnb].ysize;

color = lwallnb * (1 << (bpp -8)) + 5;
lwallrefpt.x=obj_db.lwalls[lwallnb].refpt.x-obj_db.screen_pos.x;
lwallrefpt.y=obj_db.lwalls[lwallnb].refpt.y-obj_db.screen_pos.y;

if(color == 16)
        color --;
        
if(obj_db.lwalls[lwallnb].sprite)
        {
        set_clip_rect(game_frame[page_num], lwallrefpt.x, lwallrefpt.y, lwallrefpt.x + l - (*obj_db.lwalls[lwallnb].edgeright)->w, lwallrefpt.y + L );
        draw_sprite(game_frame[page_num], *obj_db.lwalls[lwallnb].sprite, lwallrefpt.x + (*obj_db.lwalls[lwallnb].edgeleft)->w, lwallrefpt.y);
        set_clip_rect(game_frame[page_num], 0, 0, game_frame[page_num]->w - 1, game_frame[page_num]->h - 1);
        draw_sprite(game_frame[page_num], *obj_db.lwalls[lwallnb].edgeleft, lwallrefpt.x, lwallrefpt.y);
        draw_sprite(game_frame[page_num], *obj_db.lwalls[lwallnb].edgeright, lwallrefpt.x + l - (*obj_db.lwalls[lwallnb].edgeright)->w, lwallrefpt.y);
        }
else
        rectfill(game_frame[page_num],lwallrefpt.x,lwallrefpt.y,lwallrefpt.x+l,lwallrefpt.y+L, color);
return 0;
}

/***********************************************************/

void display_mouse()
{
point scr_mouse;
scr_mouse.x = obj_db.perso[0].xsize /2 + obj_db.perso[0].refpt.x;
scr_mouse.y = obj_db.perso[0].ysize /2 + obj_db.perso[0].refpt.y;
scr_mouse.x -= obj_db.screen_pos.x;
scr_mouse.y -= obj_db.screen_pos.y;
scr_mouse.x += rel_mouse_pos_x;
scr_mouse.y += rel_mouse_pos_y;

log_msg(3, "scr_mouse.x = %i ; scr_mouse.y = %i", scr_mouse.x, scr_mouse.y);
putpixel(game_frame[page_num], scr_mouse.x, scr_mouse.y, 15);
putpixel(game_frame[page_num], scr_mouse.x + 4, scr_mouse.y, 15);
putpixel(game_frame[page_num], scr_mouse.x + 5, scr_mouse.y, 15);
putpixel(game_frame[page_num], scr_mouse.x - 4, scr_mouse.y, 15);
putpixel(game_frame[page_num], scr_mouse.x - 5, scr_mouse.y, 15);
putpixel(game_frame[page_num], scr_mouse.x, scr_mouse.y + 4, 15);
putpixel(game_frame[page_num], scr_mouse.x, scr_mouse.y + 5, 15);
putpixel(game_frame[page_num], scr_mouse.x, scr_mouse.y - 4, 15);
putpixel(game_frame[page_num], scr_mouse.x, scr_mouse.y - 5, 15);
}

/*************************************************************/

int display_all()
{
int rtpl;


if(!page_flip)
    {
    acquire_bitmap(ecranv[page_num]);
    }
clear_bitmap(ecranv[page_num]);

display_background();

if(CONSOLE_IS_ACTIVE)
        display_console();
        
display_stats();

for(rtpl=0; rtpl < obj_db.nombre_perso; rtpl++)
    disp_pl(&obj_db.perso[rtpl]);
    
for(rtpl=0; rtpl < obj_db.nombre_enemies; rtpl++)
    disp_pl(&obj_db.enemies[rtpl]);

for(rtpl=0; rtpl < obj_db.nombre_klines; rtpl++)
    disp_kline(rtpl);

for(rtpl=0; rtpl < obj_db.nombre_walls; rtpl++)
    disp_wall(rtpl);

for(rtpl=0; rtpl < obj_db.nombre_lwalls; rtpl++)
    disp_lwall(rtpl);

for(rtpl=0; rtpl < obj_db.nombre_portals; rtpl++)
    disp_portal(rtpl);
    

/*display_mouse(); temporarily disabled*/

textprintf_ex(ecranv[page_num], font, 610, 13, 255, -1, "Driver %s",gfx_driver->name);
textprintf_ex(ecranv[page_num], font, 610, 28, 255, -1, "FPS : %i",last_fps);
textprintf_ex(ecranv[page_num], font, 610, 43, 255, -1, "GameTime : %i ; %i ", cyclecount, nb_fps_cycles);
display_cadre(zlogframe);

scheduler_disp();


if(!page_flip)
	release_bitmap(ecranv[page_num]);
 

if(!page_flip)
    {    

    if(!is_memory_bitmap(ecranv[0]))
		vsync();

    acquire_screen();
    blit(ecranv[0], screen, 0,0,0,0,RESOL_X,RESOL_Y);
    release_screen();
    }
else {
    show_video_bitmap(ecranv[page_num]);
    page_num = 1-page_num;
}

return(0);
}
/************************************************************/

int display_splash(char *message)
{

log_msg(3, "Resolution X : %i, Resolution Y : %i", RESOL_X, RESOL_Y);
rectfill(screen, 0, 0, RESOL_X, RESOL_Y, 7);
textout_ex(screen, font, message, 0.40*RESOL_X, 0.48*RESOL_Y, 1, 255);

return 0;
}

/*********************************************************/

void display_schedmsg(int counter, int iparm, void * message)
{
        counter = 0;
        iparm = 0;
        if(message != NULL)
                        textout_ex(ecranv[page_num], font, message, 400, 570, 255, -1);
}

