#!/bin/bash
##########################################################
#                   console_autocode.sh                  #
#--------------------------------------------------------#
#   Automatically generates the console parsing code     #
#              using the objects.h file.                 #
#--------------------------------------------------------#
#          Copyright (c) 2004 Arthur Huillet             #
#     This file, as a part of Zlog, is released under    #
#                 the MIT licence.                       #
##########################################################


#on va rcuprer tous les int et floats qui sont en dehors de "l'autocode object list", 
#et lire ceux l en priorit
TEMP1=`mktemp`
TEMP2=`mktemp`
LIGNE_FIN_OBJETS=`grep -n '\/\*-=AUTOCODE OBJECT LIST ENDS HERE=-\*\/' objects.h | sed 's/\:.*//'`
echo Object list ends line `expr $LIGNE_FIN_OBJETS` of objects.h
tail -n +`expr $LIGNE_FIN_OBJETS + 1` objects.h > $TEMP1
egrep '.*int .*$' $TEMP1 | grep -v '()' | egrep -v ' \*' | egrep -v '\[|\]' | sed 's/\/\*.*\*\///' > $TEMP2
cat $TEMP2 | sed 's/\;//' > $TEMP1
echo The following global objects will be recognized : 
cat $TEMP1
rm $TEMP2

rm csl_autocode.zh

echo 'int get_console_cmd_target(char *source) {
zl_console.target_type = CONSOLE_TARGET_UNKN;
zl_console.itarget = 0;
zl_console.ctarget = NULL;
if(!strchr(source, '\'.\''))
        {
                ' > csl_autocode.zc
i=1
while test "$i" -le "`cat $TEMP1 | wc -l`"
	do
	LIGNE=`tail +$i $TEMP1 | sed q`
        SINT=`echo $LIGNE | grep short | sed 's/short.*/s/'`
        echo -n '          if(!strcmp(source, "'`echo $LIGNE | sed 's/.*int //'`'"))
                {
                zl_console.target_type = CONSOLE_TARGET_'$SINT'INT;
                zl_console.'$SINT'itarget = ' >> csl_autocode.zc
                if [ "$SINT" != "s" ]; then
                        echo -n '(int *)' >> csl_autocode.zc
                fi
                echo '&('`echo $LIGNE | sed 's/.*int //'`');
                return 0;
                }
        ' >> csl_autocode.zc
        i=`expr $i + 1`
        done
         
 echo '         zl_console.target_type = CONSOLE_TARGET_UNKN;
        return 0;
        }
 ' >> csl_autocode.zc
rm $TEMP1

# ce point l on a dj fait pas mal du boulot
#il nous reste  dtecter si l'utilisateur fait rfrence  un lment de obj_db, 
#reprer le type de cet lment, trouver son numro, et lancer la suite.

#looking for objects defs
LIGNE_DEBUT_OBJETS=`grep -n '\/\*-=AUTOCODE OBJECT LIST BEGINS HERE=-\*\/' objects.h | sed 's/\:.*//'`
echo Object list begins line $LIGNE_DEBUT_OBJETS of objects.h
TEMP1=`mktemp`
TEMP2=`mktemp`
tail -n +`expr $LIGNE_DEBUT_OBJETS + 1` objects.h > $TEMP1
LIGNE_FIN_OBJETS=`grep -n '\/\*-=AUTOCODE OBJECT LIST ENDS HERE=-\*\/' $TEMP1 | sed 's/\:.*//'`
echo Object list ends line `expr $LIGNE_FIN_OBJETS + $LIGNE_DEBUT_OBJETS` of objects.h
cat $TEMP1 | sed `expr ${LIGNE_FIN_OBJETS} - 1`q > $TEMP2
rm $TEMP1
echo Object list stored at $TEMP2

#looking for object database
LIGNE_DEBUT_OBJDB=`grep -n '\/\*-=OBJ DATABASE BEGINS=-\*\/' $TEMP2 | sed 's/\:.*//'`
LIGNE_DEBUT_OBJDB=`expr $LIGNE_DEBUT_OBJDB + 1`
echo Object database begins line $LIGNE_DEBUT_OBJDB of $TEMP2
OBJ_DB=`mktemp`
tail -n +$LIGNE_DEBUT_OBJDB $TEMP2 > $OBJ_DB

#object database parsing
TEMP1=`mktemp`
cat $OBJ_DB | egrep -v '{|}|int |\[' | sed 's/\*/-/;' > $TEMP1

i=2
while test "$i" -lt "`cat $TEMP1 | wc -l`"
	do
	LIGNE=`tail +$i $TEMP1 | sed q`
	TYPE=`echo $LIGNE | sed 's/ -.*//'`
	AZE=$TYPE
	if [ $TYPE = "liveplayer" ]; then
	AZE="perso"
	fi
	if [ $TYPE = "wall" ]; then 
	AZE="walls";
	fi
	if [ $TYPE = "livewall" ]; then 
	AZE="lwalls"
	fi
	if [ $TYPE = 'killing_line' ]; then 
	AZE="klines"
	fi
	if [ $TYPE = "portal" ]; then 
	AZE="portals"
	fi
        if [ $TYPE = "enemy" ]; then
        AZE="enemies"
        fi
	echo Writing code for $TYPE
        echo 'if(strstr(source, "obj_db.'$AZE'"))
        {
        char * find_nb;
        char cobjnb[5];
        memset(cobjnb, 0, 5);
        int offset = 0;
        int objnb = 0;
        if(!strchr(source, '\'[\''))
                {
                zl_console.target_type = CONSOLE_TARGET_UNKN;
                return 0;
                }
        find_nb = strchr(source, '\'[\'');
        find_nb++;
        while(isdigit(find_nb[offset]))
                offset++;
        strncpy(cobjnb, find_nb, offset);
        objnb = atoi(cobjnb);
        while(*source != '\']\'')
                source++;
        source++;
        if(!(*source))
                {
                zl_console.target_type = CONSOLE_TARGET_UNKN;
                return 0;
                }
                        
        '$TYPE' * parameter_struct = &obj_db.'$AZE'[objnb];
        cslparm_retrieve_'$TYPE'(parameter_struct, source);
        return 0;
        }
        ' >> csl_autocode.zc
        echo 'int cslparm_retrieve_'$TYPE'('$TYPE'*, char *);' >> csl_autocode.zh
        i=`expr $i + 1`
        done

#la fin de la fonction, si on a rien trouv, on dit qu'on a rien.
echo '
zl_console.target_type = CONSOLE_TARGET_UNKN;
return 0;
}
' >> csl_autocode.zc


rm $OBJ_DB
rm $TEMP1
TEMP1=`mktemp`
cat $TEMP2 | egrep -v '{|}' > $TEMP1
rm $TEMP2


#premire boucle qui va faire crer les cslparm_retrieve_xxxx
i=1
while test "$i" -lt "`cat $TEMP1 | wc -l`"
	do
	LIGNE=`tail +$i $TEMP1 | sed q`
	if [ "$LIGNE" = '/*-=OBJ DATABASE BEGINS=-*/' ]; then
		i=50000
	fi
        #si la ligne dcrit un nouvel objet (/*-=_liveplayer_=-*/)
	SI_OBJET=`echo $LIGNE | egrep '\-\=_.*_\=\-'`
	if [ $SI_OBJET ]; then
		TYPE=`echo $SI_OBJET | sed 's/\/\*\-\=_//; s/_\=\-\*\///;'`
		echo Creating : cslparm_retrieve_$TYPE'()'
		echo 'int cslparm_retrieve_'$TYPE'('$TYPE' * target, char * source)
{
if((!strlen(source)) || (*source != '\'.\''))
        {
        zl_console.target_type = CONSOLE_TARGET_UNKN;
        return 0;
        }
source++;
' >> csl_autocode.zc
        fi
        
        
        if [ ! $SI_OBJET ]; then
		if [ ! $SI_FIN ]; then
			PAS_COMMENTAIRE=`echo $LIGNE | egrep -v '\/\*|\*\/'`
			if [ "${PAS_COMMENTAIRE}" ]; then
				#on vire les qualificatifs
				SINT=`echo $LIGNE | grep short | sed 's/.*short.*/s/'`
                                LIGNE=`echo $LIGNE | sed 's/unsigned //; s/short //; s/ \*/ /; s/\[.*\]//;'`
				TYPE_VARIABLE=`echo $LIGNE | sed 's/ .*;$//'`
				NOM_VARIABLE=`echo $LIGNE | sed 's/^.* //; s/;//'`
                                
				#echo Variable de type $TYPE_VARIABLE, nom $NOM_VARIABLE

                                if [ $TYPE_VARIABLE = "char" ]; then
                                        echo 'if(!strcmp(source, "'$NOM_VARIABLE'"))
        {
        zl_console.target_type = CONSOLE_TARGET_CHAR;
        zl_console.ctarget = (char *)&(target->'$NOM_VARIABLE');
        return 0;
        }' >> csl_autocode.zc
                                fi
                                
                                if [ $TYPE_VARIABLE = "int" ]; then
                                        echo -n 'if(!strcmp(source, "'$NOM_VARIABLE'"))
        {
        zl_console.target_type = CONSOLE_TARGET_'$SINT'INT;
        zl_console.'$SINT'itarget = ' >> csl_autocode.zc
                                        if [ "$SINT" != "s" ]; then
                                                echo -n '(int *)' >> csl_autocode.zc
                                        else
                                                echo -n '(short int *)' >> csl_autocode.zc
                                        fi
        echo '&(target->'$NOM_VARIABLE');
        return 0;
        }' >> csl_autocode.zc
                                fi
        
                                if [ $TYPE_VARIABLE = "float" ]; then
                                        echo 'if(!strcmp(source, "'$NOM_VARIABLE'"))
        {
        zl_console.target_type = CONSOLE_TARGET_FLOAT;
        zl_console.itarget = (int *)&(target->'$NOM_VARIABLE');
        return 0;
        }' >> csl_autocode.zc
                                fi
                                
                                
                                if [ "$TYPE_VARIABLE" = "point" -o "$TYPE_VARIABLE" = "speed" ]; then
                                        echo 'if(strstr(source, "'$NOM_VARIABLE'"))
        {
        int soffset;
        char * tdefcontent = strstr(source, "'$NOM_VARIABLE'");
        soffset = strlen("'$NOM_VARIABLE'");
        if (strlen("'$NOM_VARIABLE'") == strlen(source))
                {
                zl_console.target_type = CONSOLE_TARGET_'$TYPE_VARIABLE';
                zl_console.'$TYPE_VARIABLE'_target = ('$TYPE_VARIABLE' *)&(target->'$NOM_VARIABLE');
                return 0;
                }
        else {
                tdefcontent += soffset;
                tdefcontent++;
                cslparm_retrieve_'$TYPE_VARIABLE'(&(target->'$NOM_VARIABLE'), tdefcontent);
                }
        }' >> csl_autocode.zc
                                fi
                        fi
		fi
	fi
        
        
        
        
        
        
        SI_FIN=`echo $LIGNE | egrep 'ENDOFSTRUCT'`
	if [ $SI_FIN ]; then
		echo End of function
		echo 'return 0;
}
' >> csl_autocode.zc
        fi
        i=`expr $i + 1`
        done

rm $TEMP1
