
/*

Copyright (c) 2003-2005      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */





#define COLLDET_C
#include "all_inc.h"

#define GIVE_NW_POINT(OTYPE, ONB) obj_db.OTYPE[ONB].refpt

#define GIVE_NE_POINT(OTYPE, ONB) {obj_db.OTYPE[ONB].refpt.x + obj_db.OTYPE[ONB].xsize, \
                obj_db.OTYPE[ONB].refpt.y}
                

#define GIVE_SW_POINT(OTYPE, ONB) {obj_db.OTYPE[ONB].refpt.x, \
                obj_db.OTYPE[ONB].refpt.y + obj_db.OTYPE[ONB].ysize}
                
                
#define GIVE_SE_POINT(OTYPE, ONB) { (obj_db.OTYPE[ONB].refpt.x + obj_db.OTYPE[ONB].xsize), \
                (obj_db.OTYPE[ONB].refpt.y + obj_db.OTYPE[ONB].ysize)}
                

/*
tableau tests pour 5 objets

0 1 2 3 4 

n o o o o   0               x, o : ancien test
x n o o o   1               o : new
x x n o o   2               n : aucun
x x x n o   3
x x x x n   4
*/

void colldet()
{
reset_forbids();

pl_colldet_lwalls();
pl_colldet_player();

pl_colldet_walls();
pl_colldet_klines();
pl_colldet_portals();
}

/**********************************************************/

void reset_forbids()
{
int plrotate;
    for(plrotate=0; plrotate < obj_db.nombre_perso; plrotate++)
        {
        obj_db.perso[plrotate].no_xxx &= ~NO_LEFT;
        obj_db.perso[plrotate].no_xxx &= ~NO_RIGHT;
        obj_db.perso[plrotate].no_xxx &= ~NO_DOWN;
        obj_db.perso[plrotate].no_xxx &= ~NO_UP;
        obj_db.perso[plrotate].ref_pform=0;
        }
    for(plrotate=0; plrotate < obj_db.nombre_enemies; plrotate++)
        {
        obj_db.enemies[plrotate].no_xxx &= ~NO_LEFT;
        obj_db.enemies[plrotate].no_xxx &= ~NO_RIGHT;
        obj_db.enemies[plrotate].no_xxx &= ~NO_DOWN;
        obj_db.enemies[plrotate].no_xxx &= ~NO_UP;
        obj_db.enemies[plrotate].ref_pform=0;
        }
    for(plrotate=0; plrotate < obj_db.nombre_lwalls; plrotate++)
        {

            obj_db.lwalls[plrotate].no_xxx &= ~NO_LEFT;
            obj_db.lwalls[plrotate].no_xxx &= ~NO_RIGHT;
            obj_db.lwalls[plrotate].no_xxx &= ~NO_DOWN;
            obj_db.lwalls[plrotate].no_xxx &= ~NO_UP;

        }
}


/**************************************************************/


void pl_colldet_player()
{


int yrt,xrt, zrt;
    for(yrt = 0; yrt < obj_db.nombre_perso; yrt++)
        {
        for(xrt = 0; yrt+1+xrt < obj_db.nombre_perso; xrt++)
                {
                if((abs(obj_db.perso[yrt].refpt.x-obj_db.perso[yrt+1+xrt].refpt.x)<\
                                obj_db.perso[yrt].xsize+obj_db.perso[yrt+1+xrt].xsize)&&\
                   (abs(obj_db.perso[yrt].refpt.y-obj_db.perso[yrt+1+xrt].refpt.y)<\
                                obj_db.perso[yrt].ysize+obj_db.perso[yrt+1+xrt].ysize))
                _plvpltest(yrt,yrt+1+xrt, ZL_PLAYER_HUMAN, ZL_PLAYER_HUMAN);
                }
                
        for(xrt = 0; xrt < obj_db.nombre_enemies; xrt++)
                {
                if((abs(obj_db.perso[yrt].refpt.x-obj_db.enemies[xrt].refpt.x)<\
                                obj_db.perso[yrt].xsize+obj_db.enemies[xrt].xsize)&&\
                   (abs(obj_db.perso[yrt].refpt.y-obj_db.enemies[xrt].refpt.y)<\
                                obj_db.perso[yrt].ysize+obj_db.enemies[xrt].ysize))
                _plvpltest(yrt,xrt, ZL_PLAYER_HUMAN, ZL_PLAYER_ENNEMY);
                for(zrt = 0; xrt+1+zrt < obj_db.nombre_enemies; zrt ++)
                        {
                        if((abs(obj_db.enemies[xrt].refpt.x-obj_db.enemies[xrt+1+zrt].refpt.x)<\
                                obj_db.enemies[xrt].xsize+obj_db.enemies[xrt+1+zrt].xsize)&&\
                   (abs(obj_db.enemies[xrt].refpt.y-obj_db.enemies[xrt+1+zrt].refpt.y)<\
                                obj_db.enemies[xrt].ysize+obj_db.enemies[xrt+1+zrt].ysize))
                _plvpltest(xrt,xrt+1+zrt, ZL_PLAYER_ENNEMY, ZL_PLAYER_ENNEMY);
                        }
                }
                
        }
}


/***************************************************************/

void pl_colldet_walls()
{


int yrt,xrt;
point plrefpt;
point wallrefpt;
for(yrt = 0; yrt < obj_db.nombre_perso; yrt++)
        {
        plrefpt.x=obj_db.perso[yrt].refpt.x-obj_db.screen_pos.x;
        plrefpt.y=obj_db.perso[yrt].refpt.y-obj_db.screen_pos.y;
            for(xrt = 0; xrt < obj_db.nombre_walls; xrt++)
                {
                wallrefpt.x=obj_db.walls[xrt].refpt.x-obj_db.screen_pos.x;
                wallrefpt.y=obj_db.walls[xrt].refpt.y-obj_db.screen_pos.y;
                
                if((abs(wallrefpt.x-plrefpt.x)<(obj_db.walls[xrt].xsize+obj_db.perso[yrt].xsize)))
                    if((abs(wallrefpt.y-plrefpt.y)<(obj_db.walls[xrt].ysize+obj_db.perso[yrt].ysize)))
                        _plvwalltest(yrt,xrt, ZL_PLAYER_HUMAN);
                }
        }
        
for(yrt = 0; yrt < obj_db.nombre_enemies; yrt++)
        {
        plrefpt.x=obj_db.enemies[yrt].refpt.x-obj_db.screen_pos.x;
        plrefpt.y=obj_db.enemies[yrt].refpt.y-obj_db.screen_pos.y;
            for(xrt = 0; xrt < obj_db.nombre_walls; xrt++)
                {
                wallrefpt.x=obj_db.walls[xrt].refpt.x-obj_db.screen_pos.x;
                wallrefpt.y=obj_db.walls[xrt].refpt.y-obj_db.screen_pos.y;
                if((abs(wallrefpt.x-plrefpt.x)<(obj_db.walls[xrt].xsize+obj_db.enemies[yrt].xsize)))
                    if((abs(wallrefpt.y-plrefpt.y)<(obj_db.walls[xrt].ysize+obj_db.enemies[yrt].ysize)))
                        _plvwalltest(yrt,xrt, ZL_PLAYER_ENNEMY);
                }
        }
      
}

/****************************************************************/

void pl_colldet_klines()
{
int yrt, xrt;


for(xrt = 0; xrt < obj_db.nombre_klines; xrt++)
        {
        for(yrt = 0; yrt < obj_db.nombre_perso; yrt++)
                _plvkltest(yrt, xrt, ZL_PLAYER_HUMAN);
        for(yrt = 0; yrt < obj_db.nombre_enemies; yrt++)
                _plvkltest(yrt, xrt, ZL_PLAYER_ENNEMY);
        }
	
}
/****************************************************************/

void pl_colldet_portals()
{
int yrt, xrt;

for(yrt = 0; yrt < obj_db.nombre_perso; yrt++)
        for(xrt = 0; xrt< obj_db.nombre_portals; xrt++)
                _plvportaltest(yrt, xrt);
}
/***********************************************************/


void pl_colldet_lwalls()
{


int yrt,xrt;
point plrefpt;
point lwallrefpt;

for(xrt = 0; xrt < obj_db.nombre_lwalls; xrt++)
        { /*contre chaque mur*/
        lwallrefpt.x=obj_db.lwalls[xrt].refpt.x-obj_db.screen_pos.x; 
        lwallrefpt.y=obj_db.lwalls[xrt].refpt.y-obj_db.screen_pos.y;
        for(yrt = 0; yrt < obj_db.nombre_perso; yrt++)
                { /*on teste chaque player*/
                plrefpt.x=obj_db.perso[yrt].refpt.x-obj_db.screen_pos.x; /*position x  l'cran*/
                plrefpt.y=obj_db.perso[yrt].refpt.y-obj_db.screen_pos.y; /*position y  l'cran*/                
        
                if((abs(lwallrefpt.x-plrefpt.x)<(obj_db.lwalls[xrt].xsize+obj_db.perso[yrt].xsize)))
                        if((abs(lwallrefpt.y-plrefpt.y)<(obj_db.lwalls[xrt].ysize+obj_db.perso[yrt].ysize)))
                                _plvlwalltest(yrt,xrt, ZL_PLAYER_HUMAN);
                }
        for(yrt = 0; yrt < obj_db.nombre_enemies; yrt++)
                { /*on teste chaque player*/
                plrefpt.x=obj_db.enemies[yrt].refpt.x-obj_db.screen_pos.x; /*position x  l'cran*/
                plrefpt.y=obj_db.enemies[yrt].refpt.y-obj_db.screen_pos.y; /*position y  l'cran*/                
        
                if((abs(lwallrefpt.x-plrefpt.x)<(obj_db.lwalls[xrt].xsize+obj_db.enemies[yrt].xsize)))
                        if((abs(lwallrefpt.y-plrefpt.y)<(obj_db.lwalls[xrt].ysize+obj_db.enemies[yrt].ysize)))
                                _plvlwalltest(yrt,xrt, ZL_PLAYER_ENNEMY);
                }
}
}


/*********************************************************/




int _plvpltest(int playernb, int testplnb, char type1, char type2)
{
point pl1ne, pl1nw, pl1se, pl1sw;
point pl2ne, pl2nw, pl2se, pl2sw;
liveplayer * target1; 
liveplayer * target2;
switch(type1) {
        case ZL_PLAYER_HUMAN :
                pl1ne=(point)GIVE_NE_POINT(perso, playernb);
                pl1nw=GIVE_NW_POINT(perso, playernb);
                pl1se=(point)GIVE_SE_POINT(perso, playernb);
                pl1sw=(point)GIVE_SW_POINT(perso,playernb);
                target1 = (liveplayer *)&obj_db.perso[playernb];
                break;
        case ZL_PLAYER_ENNEMY : 
                pl1ne=(point)GIVE_NE_POINT(enemies, playernb);
                pl1nw=GIVE_NW_POINT(enemies, playernb);
                pl1se=(point)GIVE_SE_POINT(enemies, playernb);
                pl1sw=(point)GIVE_SW_POINT(enemies,playernb);
                target1 = (liveplayer *)&obj_db.enemies[playernb];
                break;
        default : return -1;
        }
switch(type2) {
        case ZL_PLAYER_HUMAN :
                pl2ne=(point)GIVE_NE_POINT(perso, testplnb);
                pl2nw=GIVE_NW_POINT(perso, testplnb);
                pl2se=(point)GIVE_SE_POINT(perso, testplnb);
                pl2sw=(point)GIVE_SW_POINT(perso,testplnb);
                target2 = &obj_db.perso[testplnb];
                break;
        case ZL_PLAYER_ENNEMY : 
                pl2ne=(point)GIVE_NE_POINT(enemies, testplnb);
                pl2nw=GIVE_NW_POINT(enemies, testplnb);
                pl2se=(point)GIVE_SE_POINT(enemies, testplnb);
                pl2sw=(point)GIVE_SW_POINT(enemies,testplnb);
                target2 = &obj_db.enemies[testplnb];
                break;
        default : return -1;
        }


    if(_segmenttest(&pl1nw, &pl1sw, &pl2ne, &pl2se))
    /*alors collision gauche pl1 droite pl2  interdire*/
        {
        target1->no_xxx |= NO_LEFT;
        target2->no_xxx |= NO_RIGHT;
        if(target1->ref_pform == 0 && target2->ref_pform != 0)
                {
                target1->ref_pform = target2->ref_pform;
                }
        
        if(target2->ref_pform == 0 && target1->ref_pform != 0)
                {
                target2->ref_pform = target1->ref_pform;
                }
        if(type1 == ZL_PLAYER_ENNEMY && type2 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target2, 50);
                raise_zignal(&target2->zignals, ZIGNAL_GOT_HURT, 0, 0);
                /*target2->state |= ZL_PLAYER_INVINCIBLE;
                target2->trigger_flagmask |= ZL_PLAYER_INVINCIBLE;
                target2->trigger_flagmask = -target1->trigger_flagmask;
                add_scheduler_fnct(alarm_zignal, PLEFFECTOR_TRIGGER_FLAG, &target2->zignals, 300);*/
                }
        if(type2 == ZL_PLAYER_ENNEMY && type1 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target1, 50);
                raise_zignal(&target1->zignals, ZIGNAL_GOT_HURT, 0, 0);
                }        
        return 0;
        }
    
    if(_segmenttest(&pl1ne, &pl1se, &pl2nw, &pl2sw))
    /*alors collision droite pl1 gauche pl2  interdire*/
        {
        target1->no_xxx |= NO_RIGHT;
        target2->no_xxx |= NO_LEFT;
        
         if(target1->ref_pform == 0 && target2->ref_pform != 0)
                {
                target1->ref_pform = target2->ref_pform;
                }
        
        if(target2->ref_pform == 0 && target1->ref_pform != 0)
                {
                target2->ref_pform = target1->ref_pform;
                }
                
        if(type1 == ZL_PLAYER_ENNEMY && type2 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target2, 50);
                raise_zignal(&target2->zignals, ZIGNAL_GOT_HURT, 0, 0);
                }
        if(type2 == ZL_PLAYER_ENNEMY && type1 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target1, 50);
                raise_zignal(&target1->zignals, ZIGNAL_GOT_HURT, 0, 0);
                }   
        return 0;
        }
        
    if(_segmenttest(&pl1sw, &pl1se, &pl2nw, &pl2ne))
    /*alors collision bas pl1 haut pl2  interdire*/
        {
        target1->no_xxx |= NO_DOWN;
        target2->no_xxx |= NO_UP;
        if(target2->ref_pform > 0)
            target1->ref_pform = target2->ref_pform;

        if(type1 == ZL_PLAYER_ENNEMY && type2 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target2, 50);
                raise_zignal(&target2->zignals, ZIGNAL_GOT_HURT, 0, 0);
                }
        if(type2 == ZL_PLAYER_ENNEMY && type1 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target2, 100);
                }   
        return 0;
        }
   
    if(_segmenttest(&pl1nw, &pl1ne, &pl2sw, &pl2se))
    /*alors collision haut pl1 bas pl2  interdire*/
        {
        target1->no_xxx |= NO_UP;
        target2->no_xxx |= NO_DOWN;
        if(target1->ref_pform > 0)
            target2->ref_pform = target1->ref_pform;

        if(type2 == ZL_PLAYER_ENNEMY && type1 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target1, 50);
                raise_zignal(&target1->zignals, ZIGNAL_GOT_HURT, 0, 0);
                }
        if(type1 == ZL_PLAYER_ENNEMY && type2 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target1, 100);
                }   
        return 0;
        }
return 0;
}



/**********************************************************/

int _plvportaltest(int playernb, int portalnb)
{
portal * target= &obj_db.portals[portalnb];
point pl1ne=GIVE_NE_POINT(perso, playernb);
point pl1nw=GIVE_NW_POINT(perso, playernb);
point pl1se=GIVE_SE_POINT(perso, playernb);
point pl1sw=GIVE_SW_POINT(perso,playernb);
point portalnw;
portalnw.x = target->position.x;
portalnw.y = target->position.y;
point portalne = portalnw;
portalne.x += target->xsize;
point portalsw = portalnw;
portalsw.y += target->ysize;
point portalse= portalne;
portalse.y += target->ysize;


if(_segmenttest(&pl1nw, &pl1ne, &portalsw, & portalse) || \
        _segmenttest(&pl1sw, &pl1se, &portalnw, &portalne) || \
        _segmenttest(&pl1ne, &pl1se, &portalnw, &portalsw) || \
        _segmenttest(&pl1nw, &pl1sw, &portalne, &portalse) )
        {
        if( !strcmp(target->target_level, "endpoint"))
                {
                log_msg(1, "Reached endpoint - game over !");
                add_scheduler_dispfnct(display_schedmsg, 1, "GAME OVER", 150);
                zl_screen_msgbox("Endpoint", "This is an endpoint. The game is now over !", ZL_MESSAGE_BUTTONBOX, "Restart");
                runtime_level_loader("level_test.xml");
                return 1;
                }
        else
                {
                zl_screen_msgbox("Warper", "You are about to be warped to another level !", ZL_MESSAGE_BUTTONBOX, "Teleport");
                runtime_level_loader(target->target_level);
                log_msg(1, "Player warped");
                return 1;
                }
        }
 
return 0;
}
/**********************************************************/

int _plvwalltest(int playernb, int testwlnb, char type)
{
point pl1ne, pl1nw, pl1se, pl1sw;
liveplayer * target;
switch(type) {
        case ZL_PLAYER_HUMAN :
                pl1ne=(point)GIVE_NE_POINT(perso, playernb);
                pl1nw=GIVE_NW_POINT(perso, playernb);
                pl1se=(point)GIVE_SE_POINT(perso, playernb);
                pl1sw=(point)GIVE_SW_POINT(perso,playernb);
                target = &obj_db.perso[playernb];
                break;
        case ZL_PLAYER_ENNEMY : 
                pl1ne=(point)GIVE_NE_POINT(enemies, playernb);
                pl1nw=GIVE_NW_POINT(enemies, playernb);
                pl1se=(point)GIVE_SE_POINT(enemies, playernb);
                pl1sw=(point)GIVE_SW_POINT(enemies,playernb);
                target = &obj_db.enemies[playernb];
                break;
        default : return -1;
        }

point wlne=GIVE_NE_POINT(walls, testwlnb);
point wlnw=GIVE_NW_POINT(walls, testwlnb);
point wlse=GIVE_SE_POINT(walls, testwlnb);
point wlsw=GIVE_SW_POINT(walls,testwlnb);


    if(_segmenttest(&pl1nw, &pl1sw, &wlne, &wlse))
        {
        target->no_xxx |= NO_LEFT;
        raise_zignal(&target->zignals, ZIGNAL_COLLISION_W, testwlnb,0);
        return 0;
        }
    
    if(_segmenttest(&pl1ne, &pl1se, &wlnw, &wlsw))
        {
        target->no_xxx |= NO_RIGHT;
        raise_zignal(&target->zignals, ZIGNAL_COLLISION_E, testwlnb,0);
        return 0;
        }
    if(_segmenttest(&pl1sw, &pl1se, &wlnw, &wlne))
        {
        target->no_xxx |= NO_DOWN;
        target->ref_pform=-testwlnb -1;
        raise_zignal(&target->zignals, ZIGNAL_COLLISION_S, testwlnb,0);
        return 0;
        }
   
    if(_segmenttest(&pl1nw, &pl1ne, &wlsw, &wlse))
        {
        target->no_xxx |= NO_UP;
        raise_zignal(&target->zignals, ZIGNAL_COLLISION_N, testwlnb,0);
        if(target->ref_pform > 0)
            {
            /*obj_db.lwalls[obj_db.perso[playernb].ref_pform].state|=LWL_HALT_CONTACT;*/
           /* obj_db.lwalls[obj_db.perso[playernb].ref_pform].no_xxx|=NO_UP;
          log_msg(3, "Refpf %i of pl %i is stopped because of collision",obj_db.perso[playernb].ref_pform,\
                                   playernb);*/
            /*if(!(obj_db.lwalls[obj_db.perso[playernb].ref_pform].state & LWL_PAUSE_MVT))
                pf_pause_invert(obj_db.perso[playernb].ref_pform);*/
            }
        return 0;
        }
        
return 0;
}


/*************************************************************/

int _plvbltstest(int playernb, int testplayernb, char type)
{/*
int bltrot;
point currentbltrefpt;
int currentbltdamage;
point ne=GIVE_NE_POINT(perso, playernb);
point nw=GIVE_NW_POINT(perso, playernb);
point se=GIVE_SE_POINT(perso, playernb);
point sw=GIVE_SW_POINT(perso,playernb);


    for(bltrot=0; bltrot < MAXBLTS-1; bltrot++)
        {
        if(obj_db.coups_de_feu[testplayernb][bltrot].state & EXISTS)
            {
                                      
            currentbltrefpt=obj_db.coups_de_feu[testplayernb][bltrot].refpt;
            currentbltdamage=obj_db.coups_de_feu[testplayernb][bltrot].damage;
            if((_ptsegtest(&currentbltrefpt,&nw,&ne))||\
               (_ptsegtest(&currentbltrefpt,&nw,&sw)) ||\
                (_ptsegtest(&currentbltrefpt,&ne,&se))||\
                 (_ptsegtest(&currentbltrefpt,&sw,&se)))
                        {
                        unit_lose_hp(playernb,currentbltdamage);
                        obj_db.coups_de_feu[testplayernb][bltrot].state&=~EXISTS;
                        }
            }
        }*/
return playernb + testplayernb + type;
}


/**********************************************/

/**********************************************************/      

int _plvlwalltest(int playernb, int testlwlnb, char type)
{
livewall * lwl=&obj_db.lwalls[testlwlnb];

point pl1ne, pl1nw, pl1se, pl1sw;
liveplayer * target;
switch(type) {
        case ZL_PLAYER_HUMAN :
                pl1ne=(point)GIVE_NE_POINT(perso, playernb);
                pl1nw=GIVE_NW_POINT(perso, playernb);
                pl1se=(point)GIVE_SE_POINT(perso, playernb);
                pl1sw=(point)GIVE_SW_POINT(perso,playernb);
                target = &obj_db.perso[playernb];
                break;
        case ZL_PLAYER_ENNEMY : 
                pl1ne=(point)GIVE_NE_POINT(enemies, playernb);
                pl1nw=GIVE_NW_POINT(enemies, playernb);
                pl1se=(point)GIVE_SE_POINT(enemies, playernb);
                pl1sw=(point)GIVE_SW_POINT(enemies,playernb);
                target = &obj_db.enemies[playernb];
                break;
        default : return -1;
        }

point lwlne=GIVE_NE_POINT(lwalls, testlwlnb);
point lwlnw=GIVE_NW_POINT(lwalls, testlwlnb);
point lwlse=GIVE_SE_POINT(lwalls, testlwlnb);
point lwlsw=GIVE_SW_POINT(lwalls, testlwlnb);



    if(_segmenttest(&pl1nw, &pl1sw, &lwlne, &lwlse))
        {
        target->no_xxx |= NO_LEFT;
        lwl->no_xxx |= NO_RIGHT;
        if(!(lwl->state & LWL_PAUSE_MVT) && lwl->mvt_xsize==0)
                pf_pause_invert(testlwlnb);
        raise_zignal(&lwl->zignals, ZIGNAL_COLLISION_E, playernb, 0);
        raise_zignal(&target->zignals, ZIGNAL_COLLISION_W, testlwlnb, 0);
        return 0;
        }
    
    if(_segmenttest(&pl1ne, &pl1se, &lwlnw, &lwlsw))
        {
        target->no_xxx |= NO_RIGHT;
        lwl->no_xxx |= NO_LEFT;     
	if(!(lwl->state & LWL_PAUSE_MVT) && lwl->mvt_xsize==0)
                pf_pause_invert(testlwlnb);  
        raise_zignal(&lwl->zignals, ZIGNAL_COLLISION_W, playernb, 0);
        raise_zignal(&target->zignals, ZIGNAL_COLLISION_E, testlwlnb, 0);
        return 0;
        }
    if(_segmenttest(&pl1sw, &pl1se, &lwlnw, &lwlne))
        {
        target->no_xxx |= NO_DOWN;
        target->ref_pform=testlwlnb +1;
        raise_zignal(&lwl->zignals, ZIGNAL_COLLISION_N, playernb, 0);
        raise_zignal(&target->zignals, ZIGNAL_COLLISION_S, testlwlnb, 0);
        /*flag triggering*/
        /*if(obj_db.lwalls[testlwlnb].trigger_flagmask > 0)
                obj_db.lwalls[testlwlnb].parms |= obj_db.lwalls[testlwlnb].trigger_flagmask;
        else 
                obj_db.lwalls[testlwlnb].parms &= ~(-obj_db.lwalls[testlwlnb].trigger_flagmask);*/
        return 0;
        }
   
    if(_segmenttest(&pl1nw, &pl1ne, &lwlsw, &lwlse))
        {
        
	target->no_xxx |= NO_UP;
        lwl->no_xxx |= NO_DOWN;
        
        raise_zignal(&lwl->zignals, ZIGNAL_COLLISION_S, playernb, 0);
        raise_zignal(&target->zignals, ZIGNAL_COLLISION_N, testlwlnb, 0);
        
	if(target->ref_pform != -1)
	    { /*if we have a referer, tell it to stop and invert - ie,  go down - */
		obj_db.lwalls[target->ref_pform].no_xxx|=NO_UP;
        pf_pause_invert(target->ref_pform);
		}
        
	if(!(lwl->state & LWL_PAUSE_MVT) && lwl->mvt_ysize==0 && !(target->state & ZL_PLAYER_JPRESSED))
                pf_pause_invert(testlwlnb);
        return 0;
        }
        
return 0;
}


/*************************************************************/  
int _plvkltest(int playernb, int klnb, char type)
{
/* on vrifie chaque point X du player par rapport aux bornes de la ligne
	si dedans, alors on teste le y, si suprieur killed sinon return 0*/


point position = obj_db.klines[klnb].position;
point endpos = obj_db.klines[klnb].position;
endpos.x += obj_db.klines[klnb].taille;

point pl1ne, pl1nw;
liveplayer * target;
switch(type) {
        case ZL_PLAYER_HUMAN :
                pl1ne=(point)GIVE_NE_POINT(perso, playernb);
                pl1nw=GIVE_NW_POINT(perso, playernb);
                target = &obj_db.perso[playernb];
                break;
        case ZL_PLAYER_ENNEMY : 
                pl1ne=(point)GIVE_NE_POINT(enemies, playernb);
                pl1nw=GIVE_NW_POINT(enemies, playernb);
                target = &obj_db.enemies[playernb];
                break;
        default : return -1;
        }
        
if(_segmenttest(&pl1nw, &pl1ne, &position, &endpos))
	{
	unit_lose_hp(target, target->life+1);
	}
return 0;
}
	
	
/**************************************************************/
int _segmenttest(const point *seg1b1,const point *seg1b2, const point *seg2b1,const  point *seg2b2)
{



int SENS=0;


#define HORZ 1
#define VERT 2

    if(abs(seg1b1->x-seg1b2->x)==0)
        SENS=VERT; /*car la variation en x est nulle*/
    if(abs(seg1b1->y-seg1b2->y)==0)
        SENS=HORZ; /*car la variation en y est nulle*/
    
    
   
    switch(SENS){
        case VERT:  if((seg1b1->x!=seg2b1->x-1) && (seg1b1->x!=seg2b1->x+1) && (seg1b1->x!=seg2b1->x))
                        return 0; /*si les segments sont pas colls l'un  l'autre ni superposs*/
        
                      if(abs(seg1b1->y-seg1b2->y)>=abs(seg2b1->y-seg2b2->y))
                        { /*si le premier segment est plus long que le second*/
                        /*alors ncessairement collision = un des points de seg2 appartient  seg1*/
                            
                            if(seg2b1->y>=seg1b1->y)
                                if(seg2b1->y<=seg1b2->y)
                                    return 1;
                            if(seg2b2->y>=seg1b1->y)
                                if(seg2b2->y<=seg1b2->y)
                                    return 1;   
                        }
                        
                      if(abs(seg1b1->y-seg1b2->y)<abs(seg2b1->y-seg2b2->y))
                        { /*resp. si le second seg. est le plus long....*/
                            if(seg1b1->y>=seg2b1->y)
                                if(seg1b1->y<=seg2b2->y)
                                    return 1;
                            if(seg1b2->y>=seg2b1->y)
                                if(seg1b2->y<=seg2b2->y)
                                    return 1; 
                        }  
                        break;
        
        case HORZ:
                if((seg1b1->y!=seg2b1->y)&&(seg1b1->y!=seg2b1->y-1)\
                                &&(seg1b1->y!=seg2b1->y+1))
                        return 0;  
                if(abs(seg1b1->x-seg1b2->x)>=abs(seg2b1->x-seg2b2->x))
                        {
                            if(seg2b1->x>=seg1b1->x)
                                if(seg2b1->x<=seg1b2->x)
                                    return 1;
                            if(seg2b2->x>=seg1b1->x)
                                if(seg2b2->x<=seg1b2->x)
                                    return 1;
                        }
                        
                if(abs(seg1b1->x-seg1b2->x)<abs(seg2b1->x-seg2b2->x))
                        {
                            if(seg1b1->x>=seg2b1->x)
                                if(seg1b1->x<=seg2b2->x)
                                    return 1;
                            if(seg1b2->x>seg2b1->x)
                                if(seg1b2->x<seg2b2->x)
                                    return 1;
                        }  
                        break;
        } /* fin du switch*/
    return 0;
}
                        
        
        
        
        
        
        
        
/*******************************************/        
        
        
        
        
        
int _ptsegtest(const point *pt, const point *segb1, const point *segb2)
{
    int SENS=0;
    
    if(abs(segb1->x - pt->x)<2)
        SENS=VERT; /*car la variation en x est nulle*/
    if(abs(segb1->y - pt->y)<2)
        SENS=HORZ; /*car la variation en y est nulle*/
    
    if(!SENS)
        {
        return 0;
        }
     
    
    if(SENS==VERT) 
        {
             if((segb1->y > segb2->y))
                {
                if((pt->y-2 < segb1->y) && (pt->y+2 > segb2->y))
                    return 1;
                else return 0;
                }
                
             if((segb1->y < segb2->y))
                {
                if((pt->y+2 > segb1->y) && (pt->y-2 < segb2->y))
                    return 1;
                else return 0;
                }
            
         }
       
    if(SENS==HORZ) 
        {
             if((segb1->x > segb2->x))
                {
                if((pt->x-2 < segb1->x) && (pt->x+2 > segb2->x))
                    return 1;
                else return 0;
                }
                
            if((segb1->x < segb2->x))
                {
                if((pt->x+2 > segb1->x) && (pt->x-2 < segb2->x))
                    return 1;
                else return 0;
                }
            
         }          
        
    

return 0;
}

