/*

Copyright (c) 2002-2005 Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/


#define ACTION_C
#include "all_inc.h"
#include <math.h>



/************ 
deplacement
***************/



/*void gauche() makes a player move to the left by "combien" points, checking
for collision between two movements*/
int pl_move_left(liveplayer * target, float combien)
{
int i;
int combien_now = nearbyintf(combien);

	
if (target->direction == GAUCHE && combien)
	{ /*si le player est entrain de se dplacer, mais vers la gauche uniquement*/
	float imax = target->inert_max_speed_walk;
	if(target->state & ZL_PLAYER_RUNNING)
		{ /*s'il court*/
		imax = target->inert_max_speed_run; /*d'abord on paramtre l'inertie maximale*/
		if(! (target->state & ZL_PLAYER_JUMPING))
			target->moving_spd.y = 1.225 * target->base_jumping_speed; /* et la vitesse de saut qui augmente*/
		} 
	else 
		{ /*s'il ne court pas*/
		if(! (target->state & ZL_PLAYER_JUMPING))
			target->moving_spd.y = target->base_jumping_speed; /*la vitesse de saut (potentielle) diminue*/
		}
	if (target->current_spd.x > - imax)
		{
		/*si son inertie est infrieure  l'inertie max de marche*/
		target->current_spd.x -= 0.010;
		}
	}
else /*si il y a changement de direction*/
        { 
        if(target->direction == DROITE)
                {
                        /*on change le sprite*/
                log_msg(3, "Changing sprite due to direction change : %x -> %x", target->current_sprite, target->spriteset[SPRSET_GOING_LEFT]);
                target->current_sprite = target->spriteset[SPRSET_GOING_LEFT];
                target->spritecycling_parms &= ~SPR_REVERSE;
                }
        }

	

target->direction = GAUCHE;

/*on le dplace du nombre de points spcifis, et on retourne la taille du mvt*/ 

target->add_x -= combien - combien_now;

for (i = 0; i < combien_now; i++)
	{
	if ( !(target->no_xxx & NO_LEFT))
       	target->refpt.x--;
	colldet();
        /*le player n'est plus idle puisqu'on le fait bouger*/
        target->state &= ~ZL_PLAYER_IDLE;
	if (target->no_xxx & NO_LEFT)
	   	return i;
	}
/*le sprite doit tre anim*/
if(target->no_xxx & NO_DOWN && (!(target->state & ZL_PLAYER_IDLE)))
        target->state |= ZL_SPRITE_ANIMATE;
return i;
}


/***********************************************************/


int lwl_move_left(int lwlnb, int combien)
{
int i;

for(i=0; i < combien; i++)
    {
    if(!(obj_db.lwalls[lwlnb].state & NO_LEFT))
        obj_db.lwalls[lwlnb].refpt.x--;
    colldet();    
    if(obj_db.lwalls[lwlnb].state & NO_LEFT)
        return i;
    }
return i;
}
    
    
/*******************************************************************************/

/*void droite() makes a player move to the right by "combien" points, checking
for collision between two movements*/
int pl_move_right(liveplayer * target, float combien)
{
int i;
int combien_now = nearbyintf(combien);

/*on s'occupe tout d'abord de lui donner une inertie*/
if (target->direction == DROITE && combien)
	{ /*si le player est entrain de se dplacer, mais vers la droite uniquement*/
	float imax=target->inert_max_speed_walk;
	if(target->state & ZL_PLAYER_RUNNING)
		{
		imax=target->inert_max_speed_run;
		if(! (target->state & ZL_PLAYER_JUMPING))
			target->moving_spd.y = 1.225 * target->base_jumping_speed; /*la vitesse de saut augmente*/
		}
	else 
		{ /*s'il ne court pas*/
		target->moving_spd.y = target->base_jumping_speed; /*la vitesse de saut (potentielle) diminue*/
		}
	if (target->current_spd.x < imax)
		target->current_spd.x += 0.010;
	}
else /*si il y a changement de direction*/
        { 
        if(target->direction == GAUCHE)
                {
                /*on change le sprite*/
                log_msg(3, "Changing sprite due to direction change : %x -> %x", target->current_sprite, target->spriteset[SPRSET_GOING_RIGHT]);
                target->current_sprite = target->spriteset[SPRSET_GOING_RIGHT];
                target->spritecycling_parms &= ~SPR_REVERSE;
                }
        }
		



target->direction=DROITE;
target->add_x += combien - combien_now;

for(i=0; i < combien_now; i++)
    {
    if(!(target->no_xxx & NO_RIGHT))
        target->refpt.x++;
	colldet();   
        target->state &= ~ZL_PLAYER_IDLE;
    if(target->no_xxx & NO_RIGHT)
        return i;
}
if((target->no_xxx & NO_DOWN) && (!(target->state & ZL_PLAYER_IDLE)))
        target->state |= ZL_SPRITE_ANIMATE;
return i;

}
/***********************************************/

int lwl_move_right(int lwlnb, int combien)
{
int i;

for(i=0; i < combien; i++)
    {

    if(!(obj_db.lwalls[lwlnb].state & NO_RIGHT))
        obj_db.lwalls[lwlnb].refpt.x++;
    
    colldet();    
    
    if(obj_db.lwalls[lwlnb].state & NO_RIGHT)
        return i;
    }

return i;
}


/*****int up() dplace pl vers le haut*/

int pl_move_up(liveplayer * target, int combien)
{
int i;

target->state&=~ZL_PLAYER_IDLE;
    for(i=0;i<combien;i++)
    {
	if(!(target->no_xxx & NO_UP))
		if(target->refpt.y>1)    
            target->refpt.y--;
		else return i;
	else return i;
	colldet();
    }
    
    return i;
}
/*******************************************/
int lwl_move_up(int lwlnb, int combien)
{
  int i;

  
    for(i=0;i<combien;i++)
    {

        if(!(obj_db.lwalls[lwlnb].state & NO_UP))
          if(obj_db.lwalls[lwlnb].refpt.y>1)    
            obj_db.lwalls[lwlnb].refpt.y--;
          else return i;
        else return i;
        
           colldet(); 
    }
    
    return i;
}

/***** int down() d?place player vers le bas*/

int pl_move_down(liveplayer * target, int combien)
{
    int i;

    for(i=0;i<combien;i++)
    {
    
    
     if(target->no_xxx & NO_DOWN)
        return i;
      if(!(target->no_xxx & NO_DOWN))
        {
        target->refpt.y++;
        }
         colldet(); 
    }
    return i;
}

/******************************************************************/

int lwl_move_down(int lwlnb, int combien)
{

    int i;

    for(i=0;i<combien;i++)
    {
      
      
      if(obj_db.lwalls[lwlnb].state & NO_DOWN)
        return i;
      if(!(obj_db.lwalls[lwlnb].state & NO_DOWN))
        obj_db.lwalls[lwlnb].refpt.y++;
        
          colldet();
    }
    return i;
}







/*****setjump() met en place les variables pour effectuer un saut*/

void setjump(liveplayer * target)
{ 
if(target->no_xxx & NO_DOWN)
    {
    target->jtime = 0;
    target->state |= ZL_PLAYER_JUMPING;
    }
}





/****request_eojump()*/
int request_eojump(int playernb)
{
liveplayer *target = &obj_db.perso[playernb];
if(target->state & ZL_PLAYER_JUMPING)
	{
	target->state &=~ZL_PLAYER_JUMPING;
	target->jtime=0;        
	}
return 0;
}



/***************************************************/
    
void ch_arme(int playernb,int quellearme)
{
liveplayer *target = &obj_db.perso[playernb];
if(quellearme==30)
quellearme=0;
if(target->armenb!=quellearme)
    {
    target->armenb=quellearme;
    }
}    
    
    
    /***********************************************************/   
    
void unit_lose_hp(liveplayer * target, int howmuch)
{
if(!(target->state & ZL_PLAYER_INVINCIBLE))
        {
        target->life -= howmuch;
        if(target->life<=0)
            unit_gets_killed(target);
        }
}

/**********************************************************/

void unit_gets_killed(liveplayer * target)
{
char level_def[150];
target->used = 0;
sprintf(killmsg,"%s is dead",target->name);
add_scheduler_dispfnct(display_schedmsg, 1, killmsg, 150);
if(obj_db.perso[0].life > 0)
        defrag_struct();
if(obj_db.perso[0].life <=0)
        {
        memset(level_def, 0, 149);
        strncpy(level_def, target->level_def, 149);
        return_player(level_def, target, ZL_PLAYER_HUMAN);
        zl_screen_msgbox("You died", "You will respawn at the starting point.", ZL_MESSAGE_BUTTONBOX, "PLAY");
        }
colldet();
}

/****************************************************/

void defrag_struct()
{
/*defragmentation de la structure principale*/
/*we remove the unused structures everywhere*/
int objrotate;
int objnb;
int did_rmv = 0;
log_msg(3, "Defragmenting obj_db");
objnb = obj_db.nombre_perso;
for(objrotate = 0; objrotate < objnb; objrotate++)
        {
        did_rmv = 0;
        if(!obj_db.perso[objrotate].used)
                {
                if(objrotate + 1 < objnb)
                        {
                        memcpy(&obj_db.perso[objrotate], &obj_db.perso[objrotate + 1], sizeof(liveplayer));
                        obj_db.perso[objrotate + 1].used = 0;
                        }
                did_rmv = 1;
                }
        }
if(did_rmv) obj_db.nombre_perso--;

objnb = obj_db.nombre_enemies;
did_rmv =  0;
for(objrotate = 0; objrotate < objnb; objrotate++)
        {
        if(!obj_db.enemies[objrotate].used)
                {
                if(objrotate + 1 < objnb)
                        {
                        memcpy(&obj_db.enemies[objrotate], &obj_db.enemies[objrotate + 1], sizeof(liveplayer));
                        obj_db.enemies[objrotate + 1].used = 0;
                        }
                did_rmv = 1;
                }
        }
if(did_rmv) obj_db.nombre_enemies--;
}

/*************************************************/


int do_scroll(int playernb)
{
liveplayer *target = &obj_db.perso[playernb];
extern int use_deadzone;
point basepos = obj_db.screen_pos;
/*dfilement centr*/
/*we set the screen pos to have the player on the center of the screen*/

if (!use_deadzone)
	
	{
	
	if(target->refpt.x>(GAMESCR_RESOL_X/2))
		obj_db.screen_pos.x = target->refpt.x - ((GAMESCR_RESOL_X - target->xsize) / 2); /*x au milieu de l'cran*/
	else obj_db.screen_pos.x = 0;
   
    
	obj_db.screen_pos.y = target->refpt.y - ((GAMESCR_RESOL_Y - target->ysize) / 2); /*y au milieu de l'cran */
	}


else { /*deadzone*/

	point deadzone_nw; /*les coordonnes du rectangle de la deadzone*/
	point deadzone_se;
	/*on calcule les coordonnes de la deadzone*/
	deadzone_nw.x = (GAMESCR_RESOL_X - GAMESCR_RESOL_X * DEADZONE_RATE /100) /2;
	deadzone_nw.y = (GAMESCR_RESOL_Y - GAMESCR_RESOL_Y * DEADZONE_RATE /100) /2;
	deadzone_se.x = GAMESCR_RESOL_X - deadzone_nw.x;
	deadzone_se.y = GAMESCR_RESOL_Y - deadzone_nw.y;
	
	/*comment doit on dfiler*/

	while((target->refpt.x < deadzone_nw.x + obj_db.screen_pos.x) && (obj_db.screen_pos.x > 0))
		obj_db.screen_pos.x--;
	while(target->refpt.x + target->xsize > deadzone_se.x + obj_db.screen_pos.x)
		obj_db.screen_pos.x++;
	while((target->refpt.y < deadzone_nw.y + obj_db.screen_pos.y) && (obj_db.screen_pos.y > 0))
		obj_db.screen_pos.y--;
	while(target->refpt.y + target->ysize > deadzone_se.y + obj_db.screen_pos.y)
		obj_db.screen_pos.y++;

	/*si le player est en idle on doit maintenant se rapprocher du centre __lentement__*/
	if((target->state & ZL_PLAYER_IDLE))
		{

		if(delay_to_deadzone > 0) /*si on est dj entrain d'attendre*/
			delay_to_deadzone--;
		if(delay_to_deadzone == 0) /*si on arrive  la fin du dlai, on lance le dfilement*/
			{
			if(obj_db.screen_pos.x > target->refpt.x - ((GAMESCR_RESOL_X - target->xsize) / 2))
				obj_db.screen_pos.x --;
			if(obj_db.screen_pos.x < target->refpt.x - ((GAMESCR_RESOL_X - target->xsize) / 2))
				obj_db.screen_pos.x ++;
			if(obj_db.screen_pos.y > target->refpt.y - ((GAMESCR_RESOL_Y - target->ysize) / 2))
				obj_db.screen_pos.y --;
			if(obj_db.screen_pos.y < target->refpt.y - ((GAMESCR_RESOL_Y - target->ysize) / 2))
				obj_db.screen_pos.y ++;
			}
		if(delay_to_deadzone == -1) /*si aucun timer n'est lanc*/
			{
			delay_to_deadzone = 150; /*alors on en met un*/
			}
		}
	if(! (target->state & ZL_PLAYER_IDLE))
		{
		delay_to_deadzone = -1;
		}
	
		
			
	
	}
/*-----------------*/
int b;
#define POSITIVE_CONGR(X) b = ((- X) % 384); X = 384 - b;
float val;
val = (float)((int)obj_db.screen_pos.x - (int)basepos.x) / 2;
background_offset_x += (int)val; /*(obj_db.screen_pos.x - basepos.x) / 2;*/
add_bgoffsetx += val - (int)val;
val = (float)((int)obj_db.screen_pos.y - (int)basepos.y) / 2;
background_offset_y += (int)val;
add_bgoffsety += val - (int)val;

if(add_bgoffsetx >= 0.5)
        {
        background_offset_x ++;
        add_bgoffsetx --;
        }
if(add_bgoffsetx <=  - 0.5)
        {
        background_offset_x --;
        add_bgoffsetx ++;
        }
if(add_bgoffsety >= 0.5)
        {
        background_offset_y ++;
        add_bgoffsety --;
        }
if(add_bgoffsety <=  - 0.5)
        {
        background_offset_y --;
        add_bgoffsety ++;
        }
POSITIVE_CONGR(background_offset_x);
POSITIVE_CONGR(background_offset_y);
/*printf("X %i, Y %i\n", background_offset_x, background_offset_y);*/
/*if((background_offset_y % 384) == 0)
        background_offset_y = 0;*/
return 0;
}

/********************************************/
int update_mouse()
{
int mousexoffset, mouseyoffset;
get_mouse_mickeys(&mousexoffset, &mouseyoffset);
rel_mouse_pos_x += mousexoffset;
rel_mouse_pos_y += mouseyoffset;

if(sqrt(rel_mouse_pos_x*rel_mouse_pos_x + rel_mouse_pos_y*rel_mouse_pos_y) < 100)
        { /*thorme de Thals*/
        int x0 = rel_mouse_pos_x;
        int y0 = rel_mouse_pos_y;
        int r0 = sqrt(rel_mouse_pos_x*rel_mouse_pos_x + rel_mouse_pos_y*rel_mouse_pos_y);
        if(!r0) r0 = 1;
        
        rel_mouse_pos_x = (100*x0) / r0;
        rel_mouse_pos_y = (100*y0) / r0;
        }
        
if(sqrt(rel_mouse_pos_x*rel_mouse_pos_x + rel_mouse_pos_y*rel_mouse_pos_y) > 300)
        { /*thorme de Thals*/
        int x0 = rel_mouse_pos_x;
        int y0 = rel_mouse_pos_y;
        int r0 = sqrt(rel_mouse_pos_x*rel_mouse_pos_x + rel_mouse_pos_y*rel_mouse_pos_y);
        if(!r0) r0 = 1;
        
        rel_mouse_pos_x = (300*x0) / r0;
        rel_mouse_pos_y = (300*y0) / r0;
        }
return 0;
}

/********************************************/

void message_kill()
{
textout_ex(ecranv[page_num], font, killmsg, 400, 570, 255, -1);
}       


/****************************************/
int player_adj_coord(liveplayer * target)
{
if(target->add_x >= 0.5)
	{
	if ( !(target->no_xxx & NO_RIGHT))
       	target->refpt.x++;
	colldet();
	target->add_x-=1;
	return 1;
	}
if(target->add_x <= -0.5)
	{
	if ( !(target->no_xxx & NO_LEFT))
       	target->refpt.x--;
	colldet();
	target->add_x+=1;
	return 1;
	}
	
if(target->add_y >= 0.5)
	{
	if ( !(target->no_xxx & NO_DOWN))
	pl_move_down(target, 1);
	target->add_y-=1;
	return 1;
	}
if(target->add_y <= -0.5)
	{
	if ( !(target->no_xxx & NO_UP))
	pl_move_up(target, 1);
	target->add_y+=1;
	return 1;
	}
return 0;
}
/****************************************/
int make_inertia(liveplayer * target)
{
int i;
if(target->current_spd.x > 0) 
	{ /*going to right*/
	target->add_x += (target->current_spd.x - nearbyintf(target->current_spd.x));
	for (i=0; i < nearbyintf(target->current_spd.x); i++)
		{
		if ( !(target->no_xxx & NO_RIGHT))
       		target->refpt.x++;
		colldet();
		}

	/*pl_move_right(playernb, (int)(target->current_spd.x));*/
	}
else
	{
	target->add_x -= (target->current_spd.x * -1 - nearbyintf(target->current_spd.x) * -1);
	for (i=0; i < nearbyintf(target->current_spd.x) * -1; i++)
		{
		if ( !(target->no_xxx & NO_LEFT))
       		target->refpt.x--;
		colldet();
		}
	/*pl_move_left(playernb, (int)(target->current_spd.x) * -1);*/
	}
	

/*rduction de vitesse de au frottement*/
	/*d'abord on calcule cette rduction*/
if(target->ref_pform != 0)
	{ /*si on est sur une plateforme, alors frottement*/
	float reduc;
	if(target->ref_pform > 0)
		{ /*alors il s'agit d'un livewall*/
		reduc = obj_db.lwalls[target->ref_pform -1].resist_inert;
		}
	else
		{ /*alors c'est un wall*/
		reduc = obj_db.walls[- target->ref_pform -1].resist_inert;
		}
	/*maintenant on applique cette rduction*/
	if(target->current_spd.x > 0)
		{ /*alors on va vers la droite, soustraction*/
		if(reduc < target->current_spd.x)
			target->current_spd.x -= reduc;
		else
			target->current_spd.x = 0;
		}
	if(target->current_spd.x < 0)
		{ /*alors on va vers la gauche, addition*/
		if(target->current_spd.x + reduc < 0)
			target->current_spd.x += reduc;
		else
			target->current_spd.x = 0;
		}
	}
else
	{ /*si pas sur plateforme, CODE EXPERIMENTAL !*/
	float reduc=0.008;
	if(target->current_spd.x > 0)
		{ /*alors on va vers la droite, soustraction*/
		if(reduc < target->current_spd.x)
			target->current_spd.x -= reduc;
		else
			target->current_spd.x = 0;
		}
	if(target->current_spd.x < 0)
		{ /*alors on va vers la gauche, addition*/
		if(target->current_spd.x + reduc < 0)
			target->current_spd.x += reduc;
		else
			target->current_spd.x = 0;
		}
	}
	



	
return 0;
}

/****************************************/
int make_jump(liveplayer * target)
{
if (target->state & ZL_PLAYER_IDLE && ! (target->state & ZL_PLAYER_JUMPING) )
	{ /*si le player ne bouge pas, vitesse de saut de base*/
	target->moving_spd.y = target-> base_jumping_speed;
	}
        
if(! (target->no_xxx & NO_DOWN)) {
        if((target->state & ZL_PLAYER_JUMPING) == 0)
		{	 /*if the player is falling*/
		target->current_spd.y = (gravite * target->jtime); 
		target->jtime ++;
		target->add_y += (target->current_spd.y - nearbyint(target->current_spd.y));
		pl_move_down(target, nearbyint(target->current_spd.y));
		}
        }
	
if(target->state &ZL_PLAYER_JUMPING)
	{
	target->current_spd.y = target->moving_spd.y - (gravite * target->jtime);

		if((gravite * target->jtime) >= target->moving_spd.y)
			{
			target->state &= ~ZL_PLAYER_JUMPING;
			target->jtime=0;
			return 0;
			}

			target->jtime++;
			if(pl_move_up(target, nearbyint(target->current_spd.y)) < nearbyint(target->current_spd.y))
				{ 
				target->state &= ~ZL_PLAYER_JUMPING;
				target->jtime=0;
                                return 0;
				}
			target->add_y += (target->current_spd.y - nearbyint(target->current_spd.y));
        }

if(target->no_xxx & NO_DOWN)
	{
	target->jtime=0;
        target->current_spd.y = 0;
	target->state &= ~ZL_PLAYER_JUMPING;
	}

return 0;
} /*fin de la fonction*/
   

/********************************************/



