#include "main.h"



void DGame::Load_Hs(HI_SCORE &h)
{
	int p=0;
	if (exists("tetris.hs"))
	{
		ifstream fin("tetris.hs",ios::binary);

		if (!fin)
		{	
			p=1;
		}
		else
		{
			fin.read((char*) &h,sizeof h);
			fin.close();
		}
	}
	else
	{
		p=1;
	}
	if (p==1)
	{
		strcpy(hs.nam,"D Harmon");
		h.points=0;
	}
}

void DGame::Save_Hs(HI_SCORE &h)
{
	ofstream fout("tetris.hs",ios::binary);

	if (!fout)
	{
	}
	else
	{
		fout.write((char*) &h,sizeof h);
		fout.close();
	}
}

void DGame::Init_Game(int s)
{
	score=0;
	cl=0;
	Reset_Game();
	lines=0;
	Game_Type=s;
	Board.Clear();
	Block.New_Block(Game_Type);									
	Block.New_Block(Game_Type);									
}

void DGame::Init_All()
{
	srand((int)time(NULL));

	vol=128;

	data=load_datafile("data.dat");

	set_palette((RGB*)data[MY_PAL].dat);


	Load_Hs(hs);

	text_mode(-1);

	Screen.Create(640,480);

	Button[0].Create(460,80,80,16,"New Game");
	Button[1].Create(460,100,80,16,"About");
	Button[6].Create(460,120,80,16,"Quit");

	Button[2].Create(460,240,20,14,"<-");
	Button[3].Create(460,260,20,14,"->");
	Button[4].Create(460,280,60,14,"Rotate");
	Button[5].Create(460,300,60,14,"Drop");

	Button[7].Create(460,340,60,14,"Pause");

	Button[8].Create(460,160,80,14,"Sound On");

	Board.Create((BITMAP*)data[COLORS].dat);
	Board.Clear();

	Block.Create((BITMAP*)data[COLORS].dat);
	Block.New_Block(Game_Type);

	Init_Game(0);
}

void DGame::Inc_Score(int s)
{

	int sc[5]={50,200,500,1000,2500};

	score+=sc[s-1];
	lines+=s;
	cl+=s;
	if (cl>=9)
	{
		cl-=10;
		Lower_Speed();
	}
}

void DGame::Draw_All()
{
	char msg[80];
	int i;

	Board.Draw(Screen);
	Block.Draw(Screen);

//	Title_Window(bmp,30,180,130,270,UP,"Next Block");

	Title_Window(Screen,NULL,30,290,130,324,"Score");

	sprintf(msg,"%d",score);
	Screen.Text_C(msg,80,310);

	Title_Window(Screen,NULL,30,340,130,374,"Lines");

	sprintf(msg,"%d",lines);
	Screen.Text_C(msg,80,360);

	Title_Window(Screen,NULL,30,400,130,444,"High Score");

	Screen.Text_C(hs.nam,80,420);
	sprintf(msg,"%d",hs.points);
	Screen.Text_C(msg,80,430);

//	sprintf(msg,"%d",curr_speed);
//	Screen.Text_C(msg,20,20);


	Screen.Text("Click  or  Press:",460,220);
	Screen.Text("Left",554,240);
	Screen.Text("Right",554,260);
	Screen.Text("Up",554,280);
	Screen.Text("Down",554,300);


	for (i=0; i<NUM_BUTT; i++)
	{
		Button[i].Draw(Screen);
	}

	Draw_Screen();
}

void DGame::Delete_All()
{
	int i;

	for (i=0; i<NUM_BUTT; i++)
	{
		Button[i].Delete();
	}

	Board.Delete();
	Block.Delete();

	Mouse.UnInstall();
	Screen.Delete();
	unload_datafile(data);
}


void DGame::Play(int s)
{
	play_sample((SAMPLE*)data[SAMP00+s].dat, vol, 255,1000, FALSE);
}

void DGame::Turn_Sound(DButton &bt)
{
	int t=0;
	if (vol==0)
	{
		t=128;
		strcpy(bt.text,"Sound On");
	}
	else
	{
		t=0;
		strcpy(bt.text,"Sound Off");
	}

	vol=t;
}


int DGame::Which_Button()
{
	int i,h=100;
	for (i=0; i<NUM_BUTT; i++)
	{
		if (Button[i].Pressed()) h=i;
	}
	return h;
}

void DGame::Program()
{
	int dn=0,mouse_state=UP,jj,ll,mm=0,oo,pp,vv,p,ww,l,h,aa;
	

	Init_All();

	strcpy(Pop.text[0],"Normal Blocks");
	strcpy(Pop.text[1],"---");
	strcpy(Pop.text[2],"Wacky Blocks");
	strcpy(Pop.text[3],"@@@");
	strcpy(Pop.text[4],"@@@");
	strcpy(Pop.text[5],"@@@");
	strcpy(Pop.text[6],"@@@");
	strcpy(Pop.text[7],"@@@");
	strcpy(Pop.text[8],"@@@");
	strcpy(Pop.text[9],"@@@");

	aa=Random(3);
	clear(Screen.Bitmap);
	Title_Window(Screen,(BITMAP*)data[TILE1+aa].dat,0,0,640,480,"Tetris");

	Draw_All();

	Block.New_Block(Game_Type);
	Block.New_Block(Game_Type);

	draw_sprite(Screen.Bitmap,(BITMAP*)data[TITLE_SCREEN].dat,20,40);

	Screen.Text_C("Click Mouse to Start",319,180);

	do
	{
		Mouse.Draw(Screen);		
		acquire_screen();
		Screen.Draw(screen,0,0,0,0,640,480);
		release_screen();
		Mouse.Replace(Screen);

	} while (!(mouse_b & 1));
	do
	{
	} while (mouse_b & 1);

	oo=ww=vv=jj=ll=0;	
	pp=10;		

	clear(Screen.Bitmap);
	Title_Window(Screen,(BITMAP*)data[TILE1+aa].dat,0,0,640,480,"Tetris");


	do
	{
		ll++;oo++;p=100;

		p=Which_Button();		

/*
		if (key[KEY_Q])
		{
			do
			{} while (key[KEY_Q]);
			curr_speed--;
		}
		if (key[KEY_W])
		{
			do
			{} while (key[KEY_W]);
			curr_speed++;
		}
*/


		if (mouse_b & 1)
		{
			if (p==0) 
			{
				l=Popup(Screen,Button[p],Pop);
				if (l==0)
				{
					if (Message(Screen,"New Game","Yes","No",
									"Do you Want to",
									"Start a New Game",
									"Using Basic Blocks?","@@@")==0)
					{
						Init_Game(l);
						Title_Window(Screen,(BITMAP*)data[TILE1+Random(3)].dat,0,0,640,480,"Tetris");						
					}
				}
				if (l==2)
				{
					if (Message(Screen,"New Game","Yes","No",
									"Do you Want to",
									"Start a New Game",
									"Using Wacky Blocks?","@@@")==0)
					{
						Init_Game(l);				
						Title_Window(Screen,(BITMAP*)data[TILE1+Random(3)].dat,0,0,640,480,"Tetris");
					}
				}
			}
			mouse_state=DOWN;
		}

		if (!(mouse_b & 1))
		{	
			if (mouse_state==DOWN)
			{
				if (p==1) 
				{
					about(2000);

				}
				if (p==5)
				{		
					do
					{} while (Block.Move_Down(Board)==0);			
					Play(DROP);
					h=Board.Check_Clear();
					if (h>0)
					{
						Inc_Score(h);
						Play(CLEAR);
						h=0;
					}
					Block.New_Block(Game_Type);			
					if (Block.Check_Hit(Board))
					{
						mm=1;				
					}
				}		
				if ((key[KEY_ESC]) || p==6)
				{
					if (Message(Screen,"Are You Sure","Yes","No",
									"Do you want to Quit?","@@@")==0)
					{
						dn=1;
					}
				}
				if (p==7) 
				{
					Info_Box(Screen,"Pause","Ok",
								"Game Paused","@@@");

				}
				if (p==8) 
				{
					Turn_Sound(Button[p]);
				}
			}
			mouse_state=UP;
			p=100;
		}
			
		if (!(key[KEY_DOWN]))
		{
			jj=0;
		}

		if (!(key[KEY_UP]))
		{
			vv=0;
		}

		if (p!=4)
		{
			ww=0;
		}

		if (oo==pp)
		{
			oo=0;

			if ((key[KEY_LEFT]) || p==2)
			{
				Block.Move_Left(Board);				
			}

			if ((key[KEY_RIGHT]) || p==3)
			{
				Block.Move_Right(Board);
			}
		}

		if (key[KEY_UP])
		{
			if (vv==0)
			{
				vv=1;
				Block.Turn_Left(Board);
			}
		}

		if (key[KEY_DOWN])
		{
			if (jj==0)
			{
				jj=1;
				do
				{} while (Block.Move_Down(Board)==0);			
				Play(DROP);
				h=Board.Check_Clear();
				if (h>0)
				{
					Inc_Score(h);
					Play(CLEAR);
					h=0;
				}
				Block.New_Block(Game_Type);			
				if (Block.Check_Hit(Board))
				{
					mm=1;				
				}
			}		
		}
		if (p==4)
		{
			if (ww==0)
			{
				ww=1;
				Block.Turn_Left(Board);
			}
		}

		if (Drop()==1)
		{
			ll=0;
			if (Block.Move_Down(Board))
			{				
				Play(DROP);
				h=Board.Check_Clear();
				if (h>0)
				{
					Inc_Score(h);
					Play(CLEAR);
					h=0;
				}
				Block.New_Block(Game_Type);			
				if (Block.Check_Hit(Board))
				{
					mm=1;				
				}
			}
		}

		if (mm==1)
		{
			mm=0;
			if (score>hs.points)
			{
				hs.points=score;
				Edit_Box(Screen,"High Score",hs.nam,10,"Ok",
					"You have made the",
					"Highest Score",
					"Enter your Name!","@@@");
				Save_Hs(hs);
			}
			if (Message(Screen,"Game Over","Yes","No",
								"Do you Want to",
								"Play Again?","@@@")==0)
			{
				Init_Game(Game_Type);
				Title_Window(Screen,(BITMAP*)data[TILE1+Random(3)].dat,0,0,640,480,"Tetris");
			}
			else
			{
				dn=1;
			}
		}

		Draw_All();


	} while (!dn);

	Delete_All();
}
