#include "main.h"

void DBoard::Create(BITMAP *bmp)
{
	
	board=create_bitmap(BOARD_W,BOARD_H);
	temp=create_bitmap(BOARD_W,BOARD_H);

	for (int i=0; i<MAX_COLOR; i++)
	{
		cl[i]=create_bitmap(16,16);
		blit(bmp,cl[i],0,i*16,0,0,16,16);
	}
}

void DBoard::Delete()
{
	destroy_bitmap(board);
	destroy_bitmap(temp);
	for (int i=0; i<MAX_COLOR; i++)
	{
		destroy_bitmap(cl[i]);
	}
}

void DBoard::Draw(DBitmap &bmp)
{
	int i,j,p;

	for (i=3; i<BOARD_W; i++)
	{
		for (j=0; j<BOARD_H; j++)
		{
			p=getpixel(board,i,j);
			rectfill(bmp.Bitmap,B_X+i*16,41+j*16,15+B_X+i*16,15+41+j*16,0);

			if (p>0 && p<MAX_COLOR)
			{	
				blit(cl[p-1],bmp.Bitmap,0,0,B_X+i*16,41+j*16,16,16);
			}

			if (p==MAX_COLOR+8)
			{
				blit(cl[MAX_COLOR-1],bmp.Bitmap,0,0,B_X+i*16,41+j*16,16,16);
			}
		}
	}
}

void DBoard::Clear()
{
	clear(board);
	hline(board,3,BOARD_H-1,BOARD_W-1,MAX_COLOR+8);
	vline(board,3,0,BOARD_H-1,MAX_COLOR+8);	
	vline(board,BOARD_W-1,0,BOARD_H-1,MAX_COLOR+8);	
}

int DBoard::Check_Clear()
{
	int i,j,k,l,m,p,h=0;

	clear(temp);
	hline(temp,3,BOARD_H-1,BOARD_W-1,MAX_COLOR+8);
	vline(temp,3,0,BOARD_H-1,MAX_COLOR+8);	
	vline(temp,BOARD_W-1,0,BOARD_H-1,MAX_COLOR+8);	


	k=BOARD_H-2;
	for (j=BOARD_H-2; j>-1; j--)
	{		
		l=0;
		for (i=4; i<BOARD_W; i++)
		{
			if (getpixel(board,i,j)==0)
			{
				l=1;
			}
		}
		if (l)
		{
			for (m=0; m<BOARD_W; m++)
			{
				p=getpixel(board,m,j);
				putpixel(temp,m,k,p);
			}
			k--;
		}
		else
		{
			h++;
		}
	}

	blit(temp,board,0,0,0,0,BOARD_W,BOARD_H);

	return h;
}

