#include <allegro.h>
#include <stdio.h>
#include <fstream.h>
#include <time.h>
#include <dlgraph.h>
#include "data.h"

#define GAME_TITLE		"Tetris"

#define NUM_BUTT		9

#define BOARD_W			16
#define BOARD_H			25

#define B_X				167 

#define MAX_COLOR		6

#define CLEAR			0
#define DROP			1

typedef struct HI_SCORE
{
	char nam[20];
	long points;
} HI_SCORE;

class DBoard
{
public:
	void Create(BITMAP *);
	void Delete();
	void Draw(DBitmap &);
	void Clear();
	int Check_Clear();
	BITMAP *board,*temp,*cl[MAX_COLOR];
};

class DBlock
{
public:
	void Create(BITMAP *);
	void Delete();
	void New_Block(int);
	int Check_Hit(DBoard &);
	void Turn_Left(DBoard &);
	void Turn_Right(DBoard &);
	int Move_Down(DBoard &);
	void Move_Left(DBoard &);
	void Move_Right(DBoard &);
	void Draw(DBitmap &);
	BITMAP *block,*temp,*next,*cl[MAX_COLOR];
	USHORT x_pos,y_pos,col;
};

class DGame
{
public:
	void Load_Hs(HI_SCORE &);
	void Save_Hs(HI_SCORE &);
	void Init_Game(int);
	void Init_All();
	void Inc_Score(int);
	void Dec_Speed();
	void Draw_All();
	void Delete_All();
	void Play(int);
	void Turn_Sound(DButton &);
	int Which_Button();
	void Program();

	DButton Button[NUM_BUTT];
	DATAFILE *data;	
	HI_SCORE hs;	
	DBoard Board;
	DBlock Block;
	int lines,
		Game_Type,
		cl,
		vol;
	long score;
	PopupStruct Pop;
};

void C_Speed(void);
void Lower_Speed();
int Drop();
void Reset_Game();
int main();