#include "main.h"

void DBlock::Create(BITMAP *bmp)
{
	block=create_bitmap(4,4);
	clear(block);
	temp=create_bitmap(4,4);
	clear(temp);
	next=create_bitmap(4,4);
	clear(next);

	for (int i=0; i<MAX_COLOR; i++)
	{
		cl[i]=create_bitmap(16,16);
		blit(bmp,cl[i],0,i*16,0,0,16,16);
	}
	New_Block(0);
}

void DBlock::Delete()
{
	destroy_bitmap(block);
	destroy_bitmap(temp);
	destroy_bitmap(next);
	for (int i=0; i<MAX_COLOR; i++)
	{
		destroy_bitmap(cl[i]);
	}
}

void DBlock::New_Block(int s)
{
	int j;

	blit(next,block,0,0,0,0,4,4);

	col=Random(MAX_COLOR-1)+1;

	clear(next);
	if (s==0)
	{
		j=Random(7);
		if (j==0)
		{
			putpixel(next,1,1,col);
			putpixel(next,2,1,col);
			putpixel(next,1,2,col);
			putpixel(next,2,2,col);
		}
		if (j==1)
		{
			putpixel(next,1,0,col);
			putpixel(next,1,1,col);
			putpixel(next,1,2,col);
			putpixel(next,1,3,col);
		}
		if (j==2)
		{
			putpixel(next,1,1,col);
			putpixel(next,2,1,col);
			putpixel(next,2,2,col);
			putpixel(next,3,2,col);
		}
		if (j==3)
		{
			putpixel(next,1,0,col);
			putpixel(next,0,1,col);
			putpixel(next,1,1,col);
			putpixel(next,2,1,col);
		}
		if (j==4)
		{
			putpixel(next,1,0,col);
			putpixel(next,1,1,col);
			putpixel(next,1,2,col);
			putpixel(next,2,2,col);
		}
		if (j==5)
		{
			putpixel(next,2,0,col);
			putpixel(next,2,1,col);
			putpixel(next,2,2,col);
			putpixel(next,1,2,col);
		}
		if (j==6)
		{
			putpixel(next,1,2,col);
			putpixel(next,2,2,col);
			putpixel(next,2,1,col);
			putpixel(next,3,1,col);
		}
	}
	else
	{
		j=Random(11);
		if (j==0)
		{
			putpixel(next,1,1,col);
			putpixel(next,2,1,col);
			putpixel(next,1,2,col);
			putpixel(next,2,2,col);
		}
		if (j==1)
		{
			putpixel(next,1,0,col);
			putpixel(next,1,1,col);
			putpixel(next,1,2,col);
			putpixel(next,1,3,col);
		}
		if (j==2)
		{
			putpixel(next,1,1,col);
			putpixel(next,2,1,col);
			putpixel(next,2,2,col);
			putpixel(next,3,2,col);
		}
		if (j==3)
		{
			putpixel(next,1,0,col);
			putpixel(next,0,1,col);
			putpixel(next,1,1,col);
			putpixel(next,2,1,col);
		}
		if (j==4)
		{
			putpixel(next,1,0,col);
			putpixel(next,1,1,col);
			putpixel(next,1,2,col);
			putpixel(next,2,2,col);
		}
		if (j==5)
		{
			putpixel(next,2,0,col);
			putpixel(next,2,1,col);
			putpixel(next,2,2,col);
			putpixel(next,1,2,col);
		}
		if (j==6)
		{
			putpixel(next,1,2,col);
			putpixel(next,2,2,col);
			putpixel(next,2,1,col);
			putpixel(next,3,1,col);
		}
		if (j==7)
		{
			putpixel(next,1,1,col);
		}
		if (j==8)
		{
			putpixel(next,1,1,col);
			putpixel(next,1,0,col);
			putpixel(next,1,2,col);
			putpixel(next,0,1,col);
			putpixel(next,2,1,col);
		}
		if (j==9)
		{
			putpixel(next,1,1,col);
			putpixel(next,1,2,col);
		}
		if (j==10)
		{
			putpixel(next,1,0,col);
			putpixel(next,1,1,col);
			putpixel(next,2,1,col);
		}

	}

	x_pos=8;
	y_pos=0;
}

void DBlock::Draw(DBitmap &bmp)
{
	int i,j,p;
	for (i=0; i<4; i++)
	{
		for (j=0; j<4; j++)
		{
			p=getpixel(block,i,j);
			if (p>0)
			{	
				blit(cl[p-1],bmp.Bitmap,0,0,B_X+(x_pos+i)*16,41+(y_pos+j)*16,16,16);
			}
		}
	}

	Title_Window(bmp,NULL,30,180,130,270,"Next Block");

	
	for (i=0; i<4; i++)
	{
		for (j=0; j<4; j++)
		{
			p=getpixel(next,i,j);
			if (p>0)
			{	
				blit(cl[p-1],bmp.Bitmap,0,0,48+i*16,200+j*16,16,16);
			}
		}
	}
}


int DBlock::Check_Hit(DBoard &brd)
{
	int i,j;
	
	for (i=0; i<4; i++)
	{
		for (j=0; j<4; j++)
		{
			if (getpixel(block,i,j)>0)
			{	
				if (getpixel(brd.board,x_pos+i,y_pos+j)!=0)
					return TRUE;
			}
		}
	}

	return FALSE;
}

void DBlock::Turn_Left(DBoard &brd)
{
	int i,j,p,l[4]={3,2,1,0};
	blit(block,temp,0,0,0,0,4,4);
	clear(block);
	for (i=0; i<4; i++)
	{
		for (j=0; j<4; j++)
		{
			p=getpixel(temp,i,j);
			putpixel(block,j,l[i],p);
		}
	}
	if (Check_Hit(brd))
	{
		Turn_Right(brd);
	}
}

void DBlock::Turn_Right(DBoard &brd)
{
	int i,j,p,l[4]={3,2,1,0};
	blit(block,temp,0,0,0,0,4,4);
	clear(block);
	for (i=0; i<4; i++)
	{
		for (j=0; j<4; j++)
		{
			p=getpixel(temp,i,j);
			putpixel(block,l[j],i,p);
		}
	}
	if (Check_Hit(brd))
	{
		Turn_Left(brd);
	}
}

int DBlock::Move_Down(DBoard &brd)
{
	int i,j,h=0,p;
	y_pos++;
	if (Check_Hit(brd)) 
	{
		h=1;
		y_pos--;
		for (i=0; i<4; i++)
		{
			for (j=0; j<4; j++)
			{
				p=getpixel(block,i,j);
				if (p>0)
				{
					putpixel(brd.board,x_pos+i,y_pos+j,p);
				}
			}
		}
	}
	return h;
}

void DBlock::Move_Left(DBoard &board)
{
	x_pos--;
	if (Check_Hit(board)) x_pos++;
}

void DBlock::Move_Right(DBoard &board)
{
	x_pos++;
	if (Check_Hit(board)) x_pos--;
}
