/****************************Project*******************************
 * This Project is called "Sprite Pozer." It will opperate similar
 * to the 3d model Pozer programs only with 2d sprite based models.
 * This program is intended to be used as a tool for game development.
 * It will write files that can be read into this program or another 
 * program with the same class files
 *
 * This Project was Started
 * 05/07/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the poze class. I contain layers, angels, and indexes that  
 * corrilate to bodyParts in the body. I also have a point that 
 * indicates where in the output texture the body should be centered 
 * in. I have functions that can copy other pozes and interpolate 
 * between two pozes.
 * 
 * This File Was Written:
 * 05/09/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include "poze.h"
#include <math.h>


/******************************************************************
 * I am the constructor
 ******************************************************************/
Poze::Poze(){
	int itor;
	center = new PozePoint;
	isHflip = false;

	for(itor = 0; itor < PARTCOUNT; itor++){
		ang[itor] = 0.0;
		index[itor] = 0;
		layer[itor] = 5;
	}

}

Poze::~Poze(){ 
	delete(center);
}



/******************************************************************
 * I am the copy function
 ******************************************************************/
void Poze::Copy( Poze * tgt){
	int itor;
	center->Copy(tgt->center);
	isHflip = tgt->isHflip;

	for(itor = 0; itor < PARTCOUNT; itor++){
		ang[itor]   = tgt->ang[itor];
		index[itor] = tgt->index[itor];
		layer[itor] = tgt->layer[itor];
	}
}

/******************************************************************
 * I am the interpolator funciton I average out the rotation values
 * and center values
 ******************************************************************/
void Poze::Interpol(Poze * start, Poze * end, double frac){
	int itor;
	center->x = start->center->x*(1.0-frac) + end->center->x*frac;
	center->y = start->center->y*(1.0-frac) + end->center->y*frac;
	
	for(itor = 0; itor < PARTCOUNT; itor++){
		ang[itor] = SetAvg(start->ang[itor], end->ang[itor], frac);
		if( frac < 0.5){
			index[itor] = start->index[itor];
			layer[itor] = start->layer[itor];
			isHflip = start->isHflip;
		} else {
			index[itor] = end->index[itor];
			layer[itor] = end->layer[itor];
			isHflip = end->isHflip;
		}
	}
	return;
}


/******************************************************************
 * I am tha angle interpolator. I find the angle that would result
 * between start and end at the ratio of frac. This function takes into
 * consideration the circular nature of angle rotations
 ******************************************************************/
double Poze::SetAvg(double start, double end, double frac){
	if(start < end){
		while(fabs(end - start) > 180 && start < end +180){
			start += 360;
		}
	} else {
		while(fabs(start - end) > 180 && start > end -180){
			start -= 360;
		}
	}
	return start*(1.0 - frac) + end*frac;
}

