/****************************Project*******************************
 * I am the speed hack 2006 project of Wilson Saunders. I will be 
 * a fighting game consisting of non humanoid warriors trying to
 * leap into each others brains. I will use code from the sprite pozer
 * as well as the sprite pozer program to animate these warriors.
 *
 * This Project was Started
 * 08/04/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the fighter class. I am the template class for all fighters
 * I contain a body which takes care of my rendering but I must calculate
 * what poze it should be in based on the animaiton data.
 * 
 * This File Was Written:
 * 08/05/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include <stdio.h>
#include "fighter.h"

/******************************************************************
 * I am the constructor I initilize memory
 ******************************************************************/
Fighter::Fighter(){
	int itor;

	for(itor = 0; itor < PK_TOTAL; itor++){
		OldInp[itor] = Input[itor] =false;
	}

		//physical data
	center = new PozePoint;
	hurtPt = new PozePoint;
	hurtval = 0;
	dx = dy = velox = veloy = 0;


	

		// exBlocks initilizes externally
	isDead = isAI = false;

		// repulsor points
	repFoot = new PozePoint;
	repHead = new PozePoint;
	repLefthi = new PozePoint;
	repLeftlo = new PozePoint;
	repRighthi = new PozePoint;
	repRightlo = new PozePoint;

		
		// render data
	level = create_bitmap( 300, 300);
	myBody = new Body;
	curPoze = new Poze;
	lastPoze = new Poze;

	animTime = 0;
	animMode = 0;
	BananaCount = 0;
	Nova = 0;

	aStand = new Animation;
	aWalkF = new Animation;
	aWalkB = new Animation;
	aJump = new Animation;
	aReel = new Animation;
	aFall = new Animation;
	aRecover = new Animation;
	aWattack = new Animation;
	aSattack = new Animation;
	aCrouchAtk = new Animation;
	aWfly = new Animation;
	aSfly = new Animation;
	aDive = new Animation;
	aDead = new Animation;

		// sound data
	Sounds[0] = load_wav("sounds\\hit1.wav");
	Sounds[1] = load_wav("sounds\\hit2.wav");
	Sounds[2] = load_wav("sounds\\powerDive.wav");
	Sounds[3] = load_wav("sounds\\splash.wav");
	Sounds[4] = load_wav("sounds\\swipe.wav");
	Sounds[5] = load_wav("sounds\\nova.wav");
}


/******************************************************************
 * I am the destructor I clean up memory
 ******************************************************************/
Fighter::~Fighter(){
	delete(center);
	delete(myBody);

		// exBlocks initilizes externally

		// repulsor points
	delete(repFoot);
	delete(repHead);
	delete(repLefthi);
	delete(repLeftlo);
	delete(repRighthi);
	delete(repRightlo);
}

/******************************************************************
 * I am the local value intitilizer I should be over written when
 * the fighter classes are written. For now I load Jack
 ******************************************************************/
void Fighter::LoadLocal(){
	FILE * file;
		// load body
	file = fopen("bodys\\Poke.bdy","r");
	myBody->Read(file);
	fclose(file);

		// read normal animationfiles
	file = fopen("anim\\pStand.anm","r");
	aStand->Read(file,0); //
	fclose(file);

	file = fopen("anim\\pWalkB.anm","r");
	aWalkB->Read(file,0); 
	fclose(file);

	file = fopen("anim\\pWalkF.anm","r");
	aWalkF->Read(file,0); 
	fclose(file);

	file = fopen("anim\\pJump.anm","r");
	aJump->Read(file,0); 
	fclose(file);

	file = fopen("anim\\pReel.anm","r");
	aReel->Read(file,0); 
	fclose(file);

	file = fopen("anim\\pFall.anm","r");
	aFall->Read(file,0); 
	fclose(file);

	file = fopen("anim\\pRecover.anm","r");
	aRecover->Read(file,0); 
	fclose(file);

//	file = fopen("anim\\pBlock.anm","r");
//	aBlock->Read(file,0); 
//	fclose(file);

	file = fopen("anim\\pWattack.anm","r");
	aWattack->Read(file,0); 
	fclose(file);

	file = fopen("anim\\pSattack.anm","r");
	aSattack->Read(file,0); 
	fclose(file);

	file = fopen("anim\\pCrouchAtk.anm","r");
	aCrouchAtk->Read(file,0); 
	fclose(file);

	file = fopen("anim\\pWfly.anm","r");
	aWfly->Read(file,0); 
	fclose(file);

	file = fopen("anim\\pSfly.anm","r");
	aSfly->Read(file,0); 
	fclose(file);

	file = fopen("anim\\pDive.anm","r");
	aDive->Read(file,0); 
	fclose(file);



		// load death pose and save it to level
	file = fopen("anim\\pDead.anm","r");
	aDead->Read(file,0); 
	aDead->SetToTime(curPoze, 0);
	fclose(file);
	myBody->SetToPoze(curPoze);
	blit( myBody->Render, level, 0,0, 0,0, level->w, level->h);
	LevelDinge();

		// set curanim
	curAnim = 
		aStand;
//		aWalkB;
//		aWalkF;
//		aJump;
//		aReel;
//		aFall;
//		aRecover;
//		aWattack;
//		aSattack;
//		aCrouchAtk;
//		aWfly;
//		aSfly;
//		aDive;
//		aDead;

}

/******************************************************************
 * I am the Level dinger I make the level look dingey by averageing
 * the colors to 100
 ******************************************************************/
void Fighter::LevelDinge(){
	int Xitor,Yitor;
	int color;
	int r,g,b;

	for(Yitor = 0; Yitor < level->h; Yitor++){
		for(Xitor = 0; Xitor < level->w; Xitor++){	
			color = getpixel(level, Xitor, Yitor);
			if( getr(color) == 255 && 
				getg(color) == 0 &&
				getb(color) == 255)
			{	
			}else{
				r= (5*getr(color)+120)/6;
				g= (8*getg(color)+120)/9;
				b= (5*getb(color)+120)/6;
				putpixel(level, Xitor, Yitor, makecol(r,g,b));
			}
		}
	}
	return;
}

/******************************************************************
 * I am the repulsor point setter I set the repulsor points
 * arround the center point such that the an detect collitions
 * with the ground or the opponent's attacks
 ******************************************************************/
void Fighter::SetRepulsors(){
	double dx =40;
	double dy1 =40; 
	double dy2 = 90;

	repFoot->x = center->x; repFoot->y = center->y;
	repHead->x = center->x; repHead->y = center->y- 150;
	repLefthi->x = center->x-dx; repLefthi->y = center->y-dy2;
	repLeftlo->x = center->x-dx/2; repLeftlo->y = center->y-dy1;
	repRighthi->x = center->x+dx; repRighthi->y = center->y-dy2;
	repRightlo->x = center->x+dx/2; repRightlo->y = center->y-dy1;

}

/******************************************************************
 * I am a value fetch funciton. I retrive a block index
 ******************************************************************/
int Fighter::GetBlockLo( double xval){
	int val = ( xval/(2*ARENASIZE/NUMBLOCKS));
	if(val < 0) val = 0; 
	if(val >= NUMBLOCKS) val = NUMBLOCKS-1; 
	return val;
}
int Fighter::GetBlockHi( double xval){
	int val = ( GetBlockLo(xval) + NUMBLOCKS/2);
	if(val < 0) val = 0; 
	if(val >= NUMBLOCKS) val = NUMBLOCKS-1; 
	return val;
}


/******************************************************************
 * I am the Update function. I handle calls to the body animation, 
 * uset input, AI and every thing else that has to be don on a
 * regular basis.
 ******************************************************************/
void Fighter::Update(){
	int itor;



		// eat up bananas in the area
	if(rand()%2 == 1){	// be greedy
		if(exBananas->Eat(center->x, center->y)){
			BananaCount += 1;
			play_sample(Sounds[4]  , 255, 128, 1000, false);
		}
	}else {	// offer first dibs to opponent
		if(exEnemy->exBananas->Eat(exEnemy->center->x, exEnemy->center->y)){
			exEnemy->BananaCount += 1;
			play_sample(Sounds[4]  , 255, 128, 1000, false);
		}
	}
	if(BananaCount > 50 )BananaCount = 50;
	if(BananaCount < 0 )BananaCount = 0;


		// if we are controlled by the AI call this funciotn
		// and short curcuit user input
	if( isAI){
		DoAI();
	}

		// summon Nova
	if( Input[PK_STRONG] && !OldInp[PK_STRONG] && 
		Input[PK_DOWN] && BananaCount > 8){
			Nova = 20;
			BananaCount -= 6;
			play_sample(Sounds[5]  , 255, 128, 1000, false);
	}
		// do nova stuff here
	if( Nova >15 ){
		Nova += 20;
			// swat opponent
		if( center->DistTo(exEnemy->center) < Nova){
			if(center->x > exEnemy->center->x){
				exEnemy->velox = -18;
			}else{
				exEnemy->velox = 18;
			}
			exEnemy->veloy = -30;
			exEnemy->center->x += exEnemy->velox; exEnemy->center->y += exEnemy->veloy;
			exEnemy->animTime = -5; exEnemy->curAnim = exEnemy->aFall; exEnemy->lastPoze->Copy(curPoze);
		}
			// end nova
		if(Nova > 300) Nova = 0;
	}
		


	PozeHub();
	DoMovement();
	setmyHurt();
		// dont get hurt if already hurting
	if(curAnim != aReel && curAnim != aFall && curAnim != aRecover )
		getHurt();

	

		// check for end of animation
		// that is when the current time of the animation
		// passes the time line location of the last frame
	if(animTime >= curAnim->maxAge ){
		animTime = 0;
	}


		// store input values for refrance next update
	for(itor = 0; itor < PK_TOTAL; itor++){
		OldInp[itor] = Input[itor];
	}
}


/******************************************************************
 * I am the get hurt dammage checker I check my opponent's hurt 
 * valeus and see if I am dammaged
 ******************************************************************/
void Fighter::getHurt(){
	int itor;

	
		// not getting wounded
	if(this->exEnemy->hurtval == 0) return;
		// check if hurt point is outside our area box
	if( exEnemy->hurtPt->x < repLefthi->x-20 ) return;
	if( exEnemy->hurtPt->x > repRighthi->x+20) return;
	if( exEnemy->hurtPt->y > repFoot->y ) return;
	if( exEnemy->hurtPt->y < repHead->y-20 )return;

		// -- if controll gets here we are in a world of hurt -- //

		// play sound depending on the ammount of hurt
	if(exEnemy->hurtval < 4){
		play_sample(Sounds[0]  , 255, 128, 1000, false);
	} else if( exEnemy->hurtval < 10){
		play_sample(Sounds[1]  , 255, 128, 1000, false);
	}else{
		play_sample(Sounds[2]  , 255, 128, 1000, false);
	}

			// check for death
	if( exEnemy->hurtval == 10 && BananaCount <= 0)
		isDead = true;

		// start be lobbing bananas everywhere
	for(itor = exEnemy->hurtval - (rand()%10); itor >=0 ; itor -=1){
		if( BananaCount > 0){
			exBananas->Spawn(exEnemy->hurtPt->x, exEnemy->hurtPt->y);
			BananaCount -= 1;
		}
	}

		

	
		// set animation to display the pain
		// tell enemy diver he has suceeded
	if(exEnemy->aDive == exEnemy->curAnim){
		exEnemy->animTime = -5;
		exEnemy->curAnim = exEnemy->aReel; 
		exEnemy->lastPoze->Copy(exEnemy->curPoze);
	}

	if( exEnemy->hurtval < 4){
		animTime = -5; curAnim = aReel; lastPoze->Copy(curPoze);
		if(center->x > exEnemy->center->x){
			velox = 8;
		}else{
			velox = -8;
		}
		veloy = -10;
		center->x +=velox; center->y +=veloy;

	}else {
		if(center->x > exEnemy->center->x){
			velox = 10;
		}else{
			velox = -10;
		}
		veloy = -20;
		center->x +=velox; center->y +=veloy;
		animTime = -5; curAnim = aFall; lastPoze->Copy(curPoze);
	}



}

/******************************************************************
 * I am the hurt point location setter
 ******************************************************************/
void Fighter::setmyHurt(){

		// return raely if before the assault
	if(animTime < 5)return;
		// default no hurt situation
//	hurtPt->Copy(curPoze->center);
	hurtval =  0;

	if(aWattack == curAnim ) {
		hurtval =  2;
		hurtPt->Copy(myBody->RootLoc[0]);
		hurtPt->x -= 80;
	}
	if(aSattack == curAnim ){
		hurtval =  6;
		hurtPt->Copy(myBody->RootLoc[0]);
		hurtPt->x -= 30;
	}

	if(aWfly == curAnim) {
		hurtval = 3;
		hurtPt->Copy(myBody->RootLoc[10]);
		hurtPt->x -= 30;
	}
	if(aSfly == curAnim) {
		hurtval = 8;
		hurtPt->Copy(myBody->RootLoc[0]);
		hurtPt->x -= 30;
		hurtPt->y += 90;
	}

	if(aDive == curAnim) {
		hurtval = 10;
		hurtPt->Copy(myBody->RootLoc[0]);
		hurtPt->y += 80;
	}
		
	if(aCrouchAtk == curAnim) {
		hurtval = 9;
		hurtPt->y -= 20;
		hurtPt->Copy(myBody->RootLoc[0]);
	}

	// if not hurt has been assigned return
	if(hurtval == 0) return;
		// shift by center locaiton
	if(	(curPoze->isHflip && exEnemy->center->x < center->x )||
		(!curPoze->isHflip && exEnemy->center->x > center->x ))
	{
		hurtPt->x = -hurtPt->x + center->x + myBody->Render->w/2;
		hurtPt->y = hurtPt->y + center->y - myBody->Render->h;
	}else {
		hurtPt->x = hurtPt->x + center->x - myBody->Render->w/2;
		hurtPt->y = hurtPt->y + center->y - myBody->Render->h;
	}
		



}



/******************************************************************
 * I am the Poze Hub function. I set Curpoze to the correct value
 * aswell as set the velocities of the fighter. I should be called 
 * on update to handle input and shift animation
 ******************************************************************/
void Fighter::PozeHub(){

		// first we update the time counter
	animTime++;

		// myaWalkB handeler
	if(curAnim == aStand){
			// default keep standing
		if(animTime >= curAnim->maxAge ) // recycle animation
			animTime = 0; 
		
			// handle key presses
		if(	(Input[PK_RIGHT] && exEnemy->center->x < center->x )||
			(Input[PK_LEFT] && exEnemy->center->x > center->x ))
		{
			animTime = -5; curAnim = aWalkB; lastPoze->Copy(curPoze);
		}

			// handle key presses
		if(	(Input[PK_LEFT] && exEnemy->center->x < center->x )||
			(Input[PK_RIGHT] && exEnemy->center->x > center->x ))
		{
			animTime = -5; curAnim = aWalkF; lastPoze->Copy(curPoze);
		}

			// handle jump
		if(Input[PK_UP] && !OldInp[PK_UP]){
			animTime = -5; curAnim = aJump; lastPoze->Copy(curPoze);
		}
			// handle attacks
		if(Input[PK_WEAK] && !OldInp[PK_WEAK]){
			if(Input[PK_DOWN]){
				animTime = -5; curAnim = aCrouchAtk; lastPoze->Copy(curPoze);
			}else{
				animTime = -5; curAnim = aWattack; lastPoze->Copy(curPoze);
			}
		}
		if(Input[PK_STRONG] && !OldInp[PK_STRONG]){
			animTime = -5; curAnim = aSattack; lastPoze->Copy(curPoze);
		}

	}
		// myaWalkB handeler
	if(curAnim == aWalkB){
		if(Input[PK_RIGHT] )velox =9;
		if(Input[PK_LEFT] )velox =-9;
			// handle key presses
		if(	(Input[PK_RIGHT] && exEnemy->center->x < center->x )||
			(Input[PK_LEFT] && exEnemy->center->x > center->x ))
		{
			if(animTime >= curAnim->maxAge )	// recycle animation
				animTime = 0; 
		}
			// chainge directions
		if(	(Input[PK_LEFT] && exEnemy->center->x < center->x )||
			(Input[PK_RIGHT] && exEnemy->center->x > center->x ))
		{
			curAnim = aWalkF;
		}
					// handle jump
		if(Input[PK_UP] && !OldInp[PK_UP]){
			animTime = -5; curAnim = aJump; lastPoze->Copy(curPoze);
		}
			// stop moving
		if(!Input[PK_RIGHT] && !Input[PK_LEFT]){
			animTime = -5; curAnim = aStand; lastPoze->Copy(curPoze);
		}
			// handle attacks
		if(Input[PK_WEAK] && !OldInp[PK_WEAK]){
			if(Input[PK_DOWN]){
				animTime = -5; curAnim = aCrouchAtk; lastPoze->Copy(curPoze);
			}else{
				animTime = -5; curAnim = aWattack; lastPoze->Copy(curPoze);
			}
		}
		if(Input[PK_STRONG] && !OldInp[PK_STRONG]){
			animTime = -5; curAnim = aSattack; lastPoze->Copy(curPoze);
		}
	}

		// myaWalkF handeler
	if(curAnim == aWalkF){
		if(Input[PK_RIGHT] )velox =9;
		if(Input[PK_LEFT] )velox =-9;
			// handle key presses
			// chainge directions
		if(	(Input[PK_RIGHT] && exEnemy->center->x < center->x )||
			(Input[PK_LEFT] && exEnemy->center->x > center->x ))
		{
			curAnim = aWalkB;
			
		}
			
		if(	(Input[PK_LEFT] && exEnemy->center->x < center->x )||
			(Input[PK_RIGHT] && exEnemy->center->x > center->x ))
		{
			if(animTime >= curAnim->maxAge )	// recycle animation
				animTime = 0; 
		}

					// handle jump
		if(Input[PK_UP] && !OldInp[PK_UP]){
			animTime = -5; curAnim = aJump; lastPoze->Copy(curPoze);
		}
			// stop moving
		if(!Input[PK_RIGHT] && !Input[PK_LEFT]){
			animTime = -5; curAnim = aStand; lastPoze->Copy(curPoze);
		}
					// handle attacks
		if(Input[PK_WEAK] && !OldInp[PK_WEAK]){
			if(Input[PK_DOWN]){
				animTime = -5; curAnim = aCrouchAtk; lastPoze->Copy(curPoze);
			}else{
				animTime = -5; curAnim = aWattack; lastPoze->Copy(curPoze);
			}
		}
		if(Input[PK_STRONG] && !OldInp[PK_STRONG]){
			animTime = -5; curAnim = aSattack; lastPoze->Copy(curPoze);
		}
	}
	
		// myaWattack myaSattack myaCrouchAtk handelers
	if(curAnim == aWattack){	// weak attack
		if(animTime >= curAnim->maxAge )	// return to stand
		{animTime = 0; curAnim = aStand; lastPoze->Copy(curPoze);}
	}
	if(curAnim == aSattack){	// strong attack
		if(animTime >= curAnim->maxAge )	// return to stand
		{animTime = 0; curAnim = aStand; lastPoze->Copy(curPoze);}
	}
	if(curAnim == aCrouchAtk){	// crouching attack
		if(animTime >= curAnim->maxAge )	// return to stand
		{animTime = 0; curAnim = aStand; lastPoze->Copy(curPoze);}
	}

		// myaJump handeler
	if(curAnim == aJump && (animTime > 4)){
			// modify velocities a little
		if(Input[PK_RIGHT] && velox < 15)velox +=1;
		if(Input[PK_LEFT] && velox > -15)velox -=1;
			
			//at end of jump anim stay in jump poze
		if(animTime >= curAnim->maxAge )	
			animTime -=1;
			// if recieveing another jump order jump again
		if(Input[PK_UP] && !OldInp[PK_UP] && animTime > 0){
			animTime = 6; curAnim = aJump; lastPoze->Copy(curPoze);
		}
			// do y move
		if(animTime == 5)center->y+= 5;
		if(animTime == 6)veloy = -30;

			// check for safe landing
		if((exBlocks[GetBlockLo(repFoot->x+dx*5)]->
			IsInside(repFoot->x+dx*5, repFoot->y+dy*5 - 3)) ||
			(exBlocks[GetBlockHi(repFoot->x+dx*5)]->
			IsInside(repFoot->x+dx*5, repFoot->y+dy*5 - 3)) )
		{
			animTime = -5; curAnim = aStand; lastPoze->Copy(curPoze);
		}
			// check attacks
		if(Input[PK_WEAK] && !OldInp[PK_WEAK]){
			if(Input[PK_DOWN] && this->BananaCount > 4){
				animTime = 5; curAnim = aDive; lastPoze->Copy(curPoze);
			}else{
				animTime = 0; curAnim = aWfly; lastPoze->Copy(curPoze);
			}
		}
		if(Input[PK_STRONG] && !OldInp[PK_STRONG]){
			animTime = 0; curAnim = aSfly; lastPoze->Copy(curPoze);
		}
	}

		// myaWfly myaSfly myaDive handelers
	if(curAnim == aWfly){
		// modify velocities a little
		if(Input[PK_RIGHT] && velox < 15)velox +=1;
		if(Input[PK_LEFT] && velox > -15)velox -=1;
		//at end of jump anim stay in jump poze
		if(animTime >= curAnim->maxAge ){
			animTime = aJump->maxAge-1; curAnim = aJump;
			veloy -= 0.2;
		} 
		veloy -= 0.2;
		
		// check for safe landing
		if (animTime > 8){
			if((exBlocks[GetBlockLo(repFoot->x+dx*5)]->
				IsInside(repFoot->x+dx*5, repFoot->y+dy*5+1 - 3)) ||
				(exBlocks[GetBlockHi(repFoot->x+dx*5)]->
				IsInside(repFoot->x+dx*5, repFoot->y+dy*5+1 - 3)) )
			{
				animTime = -5; curAnim = aStand; lastPoze->Copy(curPoze);
			}
		}
	}
	if(curAnim == aSfly){
		// modify velocities a little
		if(Input[PK_RIGHT] && velox < 15)velox +=1;
		if(Input[PK_LEFT] && velox > -15)velox -=1;
			// go to jump poze already in progress
		if(animTime >= curAnim->maxAge ){
			animTime  -= 1;//= aJump->maxAge; curAnim = aJump;
		} 
		if( animTime < 10){	// float in mid air
			veloy = 2;
		}
		// check for safe landing
		if((exBlocks[GetBlockLo(repFoot->x+dx*5)]->
			IsInside(repFoot->x+dx*5, repFoot->y+dy*5+1)) ||
			(exBlocks[GetBlockHi(repFoot->x+dx*5)]->
			IsInside(repFoot->x+dx*5, repFoot->y+dy*5+1)) )
		{
			animTime = -5; curAnim = aStand; lastPoze->Copy(curPoze);
		}
	}
	if(curAnim == aDive){
		// modify velocities a little
		if(Input[PK_RIGHT] && velox < 15)velox +=1;
		if(Input[PK_LEFT] && velox > -15)velox -=1;
		//at end of jump anim stay in jump poze
		if(animTime >= curAnim->maxAge ){
			animTime -=1;
			veloy = 150;
		} 
		if( animTime < 17){	// float in mid air
			veloy = -15;
		}
		// check for safe landing
		if((exBlocks[GetBlockLo(repFoot->x+dx*5)]->
			IsInside(repFoot->x+dx*5, repFoot->y+dy*5+1)) ||
			(exBlocks[GetBlockHi(repFoot->x+dx*5)]->
			IsInside(repFoot->x+dx*5, repFoot->y+dy*5+1)) )
		{
			animTime = -5; curAnim = aRecover; lastPoze->Copy(curPoze);
			play_sample(Sounds[2]  , 255, 128, 1000, false);
			if(center->x > exEnemy->center->x){
				velox = 4;
			}else{
				velox = -4;
			}
			veloy = -20;
			center->x +=velox; center->y +=veloy;
			// exact banana tole on dive manuver
			if(BananaCount > 2 ) {
				BananaCount -= 2;
				exBananas->Spawn(center->x, center->y); exBananas->Spawn(center->x, center->y);
			} else {
				BananaCount = 0;
			}
			
		}
	}

		// myaReel handeler
	if(curAnim == aReel){	
		if(animTime >= curAnim->maxAge )	// return to stand
		{animTime = 0; curAnim = aStand; lastPoze->Copy(curPoze);}
	}
	if(curAnim == aFall){
		// check for safe landing
		if((exBlocks[GetBlockLo(repFoot->x+dx*5)]->
			IsInside(repFoot->x+dx*5, repFoot->y+dy*5+1)) ||
			(exBlocks[GetBlockHi(repFoot->x+dx*5)]->
			IsInside(repFoot->x+dx*5, repFoot->y+dy*5+1)) )
		{
			animTime = -5; curAnim = aRecover; lastPoze->Copy(curPoze);
		}
	}
	if(curAnim == aRecover){
		if(animTime >= curAnim->maxAge )	// return to stand
		{animTime = 0; curAnim = aStand; lastPoze->Copy(curPoze);}
	}
		// Set curPoze value to the what ever curAnim Says
	if (animTime >= 0){
		curAnim->SetToTime(curPoze, animTime);
	} else {	// interpolate between lastPoze and nextPoze
		curPoze->Interpol(lastPoze, curAnim->anim[0], (5.0+(float)(animTime))/5.0);
	}

}


/******************************************************************
 * I am the Update function for physical movement 
 ******************************************************************/
void Fighter::DoMovement(){
	int index;
	bool boing = false;
		// update velocity values
//	if(Input[PK_RIGHT])velox = 9;
//	if(Input[PK_LEFT])velox = -9;
	//if(Input[PK_DOWN])veloy = 0;
//	if(Input[PK_UP] && !OldInp[PK_UP])veloy = -15;

	

		// set delta values to velocity values
	dx = velox;
	dy = veloy;
		// check keyboard input
	



	SetRepulsors();

			// check foot repulsor
	repFoot->x += dx;
	repFoot->y += dy;
	index = GetBlockLo(repFoot->x);
	if(!boing && exBlocks[index]->IsInside(repFoot->x, repFoot->y)){
		dy += exBlocks[index]->RepellN(repFoot->x, repFoot->y);
		boing = true;
		veloy = 0;
		velox = 0;
	}
	index = GetBlockHi(repFoot->x);
	if(!boing && exBlocks[index]->IsInside(repFoot->x, repFoot->y)){
		dy += exBlocks[index]->RepellN(repFoot->x, repFoot->y);
		boing = true;
		veloy = 0;
		velox = 0;
	}
		// check left sholder repulsor
	repLefthi->x += dx;
	repLefthi->y += dy;
	index = GetBlockLo(repLefthi->x);
	if( exBlocks[index]->IsInside(repLefthi->x, repLefthi->y)){
		dx += exBlocks[index]->RepellE(repLefthi->x, repLefthi->y);
		boing = true;
		velox = 0;
	}
	index = GetBlockHi(repLefthi->x);
	if( exBlocks[index]->IsInside(repLefthi->x, repLefthi->y)){
		dx += exBlocks[index]->RepellE(repLefthi->x, repLefthi->y);
		boing = true;
		velox = 0;
	}

	// check right sholder repulsor
	repRighthi->x += dx;
	repRighthi->y += dy;
	index = GetBlockLo(repRighthi->x);
	if( exBlocks[index]->IsInside(repRighthi->x, repRighthi->y)){
		dx += exBlocks[index]->RepellW(repRighthi->x, repRighthi->y);
		boing = true;
		velox = 0;
	}
	index = GetBlockHi(repRighthi->x);
	if( exBlocks[index]->IsInside(repRighthi->x, repRighthi->y)){
		dx += exBlocks[index]->RepellW(repRighthi->x, repRighthi->y);
		boing = true;
		velox = 0;
	}

		// check left knee repulsor
	repLefthi->x += dx;
	repLefthi->y += dy;
	index = GetBlockLo(repLeftlo->x);
	if( exBlocks[index]->IsInside(repLeftlo->x, repLeftlo->y)){
		dx += exBlocks[index]->RepellE(repLeftlo->x, repLeftlo->y);
		boing = true;
		velox = 0;
	}
	index = GetBlockHi(repLeftlo->x);
	if( exBlocks[index]->IsInside(repLeftlo->x, repLeftlo->y)){
		dx += exBlocks[index]->RepellE(repLeftlo->x, repLeftlo->y);
		boing = true;
		velox = 0;
	}

	// check right knee repulsor
	repRightlo->x += dx;
	repRightlo->y += dy;
	index = GetBlockLo(repRightlo->x);
	if( exBlocks[index]->IsInside(repRightlo->x, repRightlo->y)){
		dx += exBlocks[index]->RepellW(repRightlo->x, repRightlo->y);
		boing = true;
		velox = 0;
	}
	index = GetBlockHi(repRightlo->x);
	if( exBlocks[index]->IsInside(repRightlo->x, repRightlo->y)){
		dx += exBlocks[index]->RepellW(repRightlo->x, repRightlo->y);
		boing = true;
		velox = 0;
	}

		// check head repulsor
	repHead->x += dx;
	repHead->y += dy;
	index = GetBlockLo(repHead->x);
	if(!boing && exBlocks[index]->IsInside(repHead->x, repHead->y)){
		dy += exBlocks[index]->RepellS(repHead->x, repHead->y);
		boing = true;
		veloy = 0;
	}

	
		// use dx and dy to set new center location
	center->x += dx;
	center->y += dy;

		// enforce center bounds;
		// by re hatching player in the middle
	if(center->x < 20 ||
		center->x > ARENASIZE -20 ||
		center->y > SCREEN_H + 80)
	{
			// plas splash sound
		play_sample(Sounds[3]  , 255, 128, 1000, false);
			// reset motion variables
		velox = veloy = 0;
			center->y = 50;
			// set location need the enemy
		if(center->x < ARENASIZE/2){
			center->x = exEnemy->center->x + (50 * (rand()%10));
			
		}else{
			center->x = exEnemy->center->x - (50  * (rand()%10));
		}
			// power dive him back in
		curAnim = aDive; this->animTime = aDive->maxAge ;lastPoze->Copy(curPoze);
			// exact banana tole 
		if(BananaCount > 4 ) {
			BananaCount -= 4;
			exBananas->Spawn(center->x, center->y); exBananas->Spawn(center->x, center->y);
			exBananas->Spawn(center->x, center->y); exBananas->Spawn(center->x, center->y);
		} else {
			BananaCount = 0;
		}
		


		
	}
		// enforce distance to opponent bounding
	if(center->x - exEnemy->center->x > SCREEN_W -80) 
		center->x = exEnemy->center->x + SCREEN_W - 80;
	if(center->x - exEnemy->center->x < -SCREEN_W +80) 
		center->x = exEnemy->center->x - SCREEN_W + 80;


	SetRepulsors();
		// update felocity values
	veloy = 0.99*veloy+1.5;
	if(veloy > 50) veloy = 50;
	velox = (69*velox)/70;
	

	return;
}



/******************************************************************
 * I am the AI action function. I just mash buttons and hope for the 
 * best
 ******************************************************************/
void Fighter::DoAI(){
	this ->AIdelay -= 1;
	if (AIdelay <= 0 ){	// choose next action
		AIaction = rand()%10;
		AIdelay = rand()%50 +20; 
	}
	switch (AIaction){
	case 0:
		// do nothing
	break;
	case 1:	// walk left
		Input[PK_LEFT] = true;
	break;
	case 2:	// walk right
		Input[PK_RIGHT] = true;
	break;
	case 3:	// Jump up
		Input[PK_UP] = true;
	break;
	case 4:	// Jump up and left
		Input[PK_UP] = true;
		Input[PK_LEFT] = true;
	break;
	case 5:	// Jump up and right
		Input[PK_UP] = true;
		Input[PK_RIGHT] = true;
	break;
	case 6:	// week attack
		Input[PK_WEAK] = true;
	break;
	case 7:	// stong attack
		Input[PK_STRONG] = true;
	break;
	case 8:	// week attack with down modifier
		Input[PK_WEAK] = true;
		Input[PK_DOWN] = true;
	break;
	case 9:	// stong attackwith down modifier
		Input[PK_STRONG] = true;
		Input[PK_DOWN] = true;
	break;
    
	}
	return;
}

/******************************************************************
 * I am the draw function. I set the body to the correct pose then I
 * draw it.
 ******************************************************************/
void Fighter::Draw(BITMAP * buffer, int CamX){
	int itor;

	// draw encirceling nova rings
	if(Nova > 25) {
		for (itor = 0; itor < 5; itor ++){
			circlefill(buffer, center->x -CamX, center->y-50, 5+Nova-itor, 
				makecol(250- itor*10, 250- itor*10, 250- itor*10));
		}
		for (itor = 0; itor < 10; itor ++){
			circlefill(buffer, center->x -CamX, center->y-50, Nova-itor, 
				makecol(200+ itor*5, 200+ itor*5, 200+ itor*5));
		}
	}

		// draw body
	myBody->SetToPoze(curPoze);
			// draw the body's render data
	if(	(curPoze->isHflip && exEnemy->center->x < center->x )||
		(!curPoze->isHflip && exEnemy->center->x > center->x )){
		draw_sprite_h_flip(buffer, myBody->Render, 
			center->x-CamX - myBody->Render->w/2, center->y - myBody->Render->h); 
	} else {
		draw_sprite(buffer, myBody->Render, 
			center->x-CamX - myBody->Render->w/2, center->y - myBody->Render->h);
	}

		// for now draw the repulsor points
//	vline(buffer, repHead->x-CamX, repHead->y , repFoot->y, makecol(0, 5, 0)); 
//	hline(buffer, repLefthi->x-CamX ,repLefthi->y, repRighthi->x-CamX, makecol(0, 5, 0));
//	hline(buffer, repLeftlo->x-CamX,repLeftlo->y, repRightlo->x-CamX, makecol(0, 5, 0));
//	line(buffer,hurtPt->x-CamX, hurtPt->y, repHead->x-CamX, repHead->y, makecol(0, 5, 0)); 
	

}
