/****************************Project*******************************
 * This Project is called "Sprite Pozer." It will opperate similar
 * to the 3d model Pozer programs only with 2d sprite based models.
 * This program is intended to be used as a tool for game development.
 * It will write files that can be read into this program or another 
 * program with the same class files
 *
 * This Project was Started
 * 05/07/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the body part class. I contain pointers into the texture that
 * define the body part's limits. I contain anchor points for other 
 * body parts to join to this one. I also refrance another body part
 * and anchor number that I attach to.
 * 
 * This File Was Written:
 * 05/08/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include "bodypart.h"


/*****************************************************************
 * I am the constructor
 ******************************************************************/
BodyPart::BodyPart(){
	texX = texY = 0;
	texW = texH = 0;
	Anchor[0] = new PozePoint;
	Anchor[1] = new PozePoint;
	Anchor[2] = new PozePoint;
	Root = new PozePoint;
}


BodyPart::~BodyPart(){
	delete(Anchor[1]);
	delete(Anchor[2]);
	delete(Anchor[0]);
	delete(Root);
}


/*****************************************************************
 * I am the file writer. I write the state of this body part out to
 * a text file 
 ******************************************************************/
void BodyPart::Write(FILE * file){
	fprintf(file, "%d %d %d %d %d %d %d %d %d %d %d %d\n",
		texX, texY, texW, texH, 
		(int)Root->x, (int)Root->y, (int)Anchor[0]->x,  (int)Anchor[0]->y,
		(int)Anchor[1]->x,  (int)Anchor[1]->y, (int)Anchor[2]->x,  (int)Anchor[2]->y);
	return;
}


/*****************************************************************
 * I am the file reader. I read the state of a body part out from
 * a text file 
 ******************************************************************/
void BodyPart::Read(FILE * file){
	int rx, ry;
	int a0x, a0y, a1x, a1y, a2x, a2y;
	fscanf(file, "%d %d %d %d %d %d %d %d %d %d %d %d\n",
		&texX, &texY, &texW, &texH, &rx, &ry, 
		&a0x, &a0y, &a1x, &a1y, &a2x, &a2y);

	Root->x = rx;
	Root->y = ry;
	Anchor[0]->x = a0x;
	Anchor[0]->y = a0y;
	Anchor[1]->x = a1x;
	Anchor[1]->y = a1y;
	Anchor[2]->x = a2x;
	Anchor[2]->y = a2y;

	DefRotate = Root->AngTo(Anchor[0]);
	return;
}

