/****************************Project*******************************
 * This Project is called "Sprite Pozer." It will opperate similar
 * to the 3d model Pozer programs only with 2d sprite based models.
 * This program is intended to be used as a tool for game development.
 * It will write files that can be read into this program or another 
 * program with the same class files
 *
 * This Project was Started
 * 05/07/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the body class. I contain all the body parts and the 
 * texture they refrance. I do a bunch of calculations that result 
 * in a Pose being taken in and a temporary texture comming out.
 * 
 * This File Was Written:
 * 05/09/06
 * By:
 * Wilson Saunders
 ******************************************************************/
#include <allegro.h>
#include "body.h"


/*****************************************************************
 * I am the constructor, I initilize the internal values
 ******************************************************************/
Body::Body(){
	int itor1, itor2;

	for (itor1 = 0; itor1 < PARTCOUNT; itor1++){
		boundToPart[itor1] = -1;
		boundAtAnchor[itor1] = 0;
		for(itor2 = 0; itor2 < NUMVIEWS; itor2++){
			bodyParts[itor1][itor2] = NULL; 
		}
		bodyParts[itor1][0] = new BodyPart;
		RootLoc[itor1] = new PozePoint;
		AnchLoc[itor1] = new PozePoint;	// temp
		RootValid[itor1] = false;
	}

	Render = create_bitmap( 300, 300);
	PartTemp = create_bitmap( 100, 100);

	for (itor1 = 0; itor1 < 9; itor1++){
		inLayerTop[itor1] = 0;
	}
}

/*****************************************************************
 * I am the destructor, I exist for good form
 ******************************************************************/
Body::~Body(){
	int itor1, itor2;

	for (itor1 = 0; itor1 < PARTCOUNT; itor1++){

		for(itor2 = 0; itor2 < NUMVIEWS; itor2++){
			if(bodyParts[itor1][itor2] != NULL)
                delete(bodyParts[itor1][itor2]);
		}

		delete(RootLoc[itor1]);

	}

}


/*****************************************************************
 * I am the file writer. I write the state of this body  out to
 * a text file. I will handel closing the file passed to me
 ******************************************************************/
void Body::Write(FILE * file){
	int itor1, itor2;
	int count = 0;

	for(itor1 = 0; itor1 < PARTCOUNT; itor1++){
		for(itor2 = 0; itor2 < NUMVIEWS; itor2++){
			if(bodyParts[itor1][itor2] != NULL) count +=1;
		}
	}
	fprintf(file, " %d %d %d ", Render->w, Render->h, count);
	
		// loop through all bodyparts writing only the valid ones
	for(itor1 = 0; itor1 < PARTCOUNT; itor1++){
		for(itor2 = 0; itor2 < NUMVIEWS &&
			bodyParts[itor1][itor2] != NULL; itor2++)
		{
				// do draw only valid points
			if(bodyParts[itor1][itor2]->texW > 0 &&
				bodyParts[itor1][itor2]->texH > 0 )
			{
				fprintf(file, "%d %d %d %d\n", itor1, itor2, 
						boundToPart[itor1], boundAtAnchor[itor1] );
				bodyParts[itor1][itor2]->Write(file);
			}
		}
	}
	fclose(file);
	return;
}

/*****************************************************************
 * I am the file reader. I read the state of this body from
 * a text file. I will handel closing the file passed to me
 ******************************************************************/
void Body::Read(FILE * file){
	int part, view;
	int toPart = 5;
	int atAnch = 0;
	int itor;
	int maxW = 0;
	int maxH = 0;
	char str[20];
	BITMAP * temp = Render;
		// read in the render size and number of parts
	fscanf(file, " %s ", &str);
	fscanf(file, " %d %d %d ", &toPart, &atAnch, &itor);
	Render = create_bitmap(toPart, atAnch); 
	destroy_bitmap(temp);

		// read in body parts untill EOF is reached
	for( itor =0; itor < NUMVIEWS*PARTCOUNT; itor++){
			// check valid read case
		if( 4 == fscanf(file, " %d %d %d %d", &part, &view, &toPart, &atAnch)){
			if(bodyParts[part][view] == NULL){
				bodyParts[part][view] = new BodyPart;
			}
			boundToPart[part] = toPart;
			boundAtAnchor[part] = atAnch;
			bodyParts[part][view]->Read(file);
				// check for new max w and h
			if(bodyParts[part][view]->texW > maxW)
				maxW = bodyParts[part][view]->texW;
			if(bodyParts[part][view]->texH > maxH)
				maxH = bodyParts[part][view]->texH;

		} else { // stop looping
			itor = NUMVIEWS*PARTCOUNT+2;
		}
	}
		// reset internal part temp texture to match maxH and maxW
	temp = PartTemp;
	PartTemp = create_bitmap(maxW, maxH);
	destroy_bitmap(temp);


	fclose(file);
	return;
}





/*****************************************************************
 * I am the Set part to pose function. I set the specified part
 * to its location as determined by the pose. I requre that the
 * part this part is anchored to be at its final location. So
 * I call myself recursivly untill that is done.
 ******************************************************************/
void Body::SetPartToPoze(int part, Poze *tgt, int depth){
		// return early if this part has already been calculated
	if(RootValid[part] == true) return;
		// return if recursing beyond 20 to prevent stack overflow
	if(depth > 20)return;

		// if this part I am depended on is not calculated or is not
		// the root recurse on that point to guarantee it is placed
		// propperly
	if( boundToPart[part] != -1 &&
		RootValid[boundToPart[part]] == false)
	{
		SetPartToPoze(boundToPart[part], tgt, depth+1);
	}
		// if the bound to part value is -1 attach this to pose center 
		// becuse this is a body part is attached to the root of all
	if(boundToPart[part] == -1){
		RootAng[part] = tgt->ang[part];
		RootLoc[part]->Copy(tgt->center);
		RootValid[part] = true;
				// temporary anchor loction computation
		AnchLoc[part]->Copy(bodyParts[part][tgt->index[part]]->Anchor[0]);
		AnchLoc[part]->RotateBy(RootAng[part]);
		AnchLoc[part]->Translate(tgt->center->x, tgt->center->y);
		return;	// no more processing needed
	}
		// if controll reaches here we can assume 
		// the part we are depended on has been moved and rotated
		// propperly and so we can use it to calculate this part
	if(bodyParts[boundToPart[part]][tgt->index[boundToPart[part]]] != NULL){
		RootLoc[part]->Copy( bodyParts[boundToPart[part]][tgt->index[boundToPart[part]]]
				->Anchor[boundAtAnchor[part]]);
	}
	RootLoc[part]->RotateBy(RootAng[boundToPart[part]]);
	RootLoc[part]->Translate(RootLoc[boundToPart[part]]->x , 
				RootLoc[boundToPart[part]]->y);
	RootAng[part] = RootAng[boundToPart[part]] + tgt->ang[part];
	RootValid[part] = true;

		// temporary anchor loction computation
	if(bodyParts[part][tgt->index[part]] != NULL){
		AnchLoc[part]->Copy(bodyParts[part][tgt->index[part]]->Anchor[0]);
		AnchLoc[part]->RotateBy(RootAng[part]);
		AnchLoc[part]->Translate(RootLoc[part]->x, RootLoc[part]->y);
	}

	return;	// done with processing
}



/*****************************************************************
 * I am the Set pose function. I set the entire body to the position
 * denoted by the tgt poze. I play arround with a lot of internal 
 * variables. In the end the output is rendered to the internal bitmap
 * which can be sprite drawn to the buffer or game screen at the 
 * appropriate place to represent the figure.
 ******************************************************************/
void Body::SetToPoze(Poze *tgt){
	int itor, itor2;
	BodyPart *curPart;
		// reset the root valid data so I have to recompute all
		// the points and angles
	for(itor =0; itor < PARTCOUNT; itor++){
		RootValid[itor] = false;
	}
		// reset layer array so we may enter new values to it
	for(itor = 0; itor < 9; itor ++){
		inLayerTop[itor] = 0;
	}
		// clear old Render Bitmap to transparent color
	clear_to_color(Render, makecol(255, 0, 255));
		// compute all the RootLoc and RootAng array values using
		// SetPartToPoze
	for(itor =0; itor < PARTCOUNT; itor++){
			// do the part calculations
		SetPartToPoze(itor, tgt, 0);
			// also place this part in it's corrisponding layer
		inLayer[tgt->layer[itor]][inLayerTop[tgt->layer[itor]]] = itor;
			// incriment inLayer Top to point at the next open spot
		inLayerTop[tgt->layer[itor]] += 1;
	}
		// Now we are ready to render all the parts onto the render surface
		// we will render layer 0 first then 1 and so on so propper overlapping 
		// occures.
	for(itor =0; itor < 9; itor++){
		for(itor2 = 0; itor2 < PARTCOUNT && itor2 < inLayerTop[itor]; itor2++){
				// set curPart so we don't have to do write the refrancing
				// code all the time
			if(tgt->index[itor2] != 0){
				itor2 = itor2;
			}
			curPart = bodyParts[inLayer[itor][itor2]][tgt->index[inLayer[itor][itor2]]];
				// if curpart is not valid reset
			if( curPart == NULL || curPart->texW < 2)curPart = bodyParts[inLayer[itor][itor2]][0];

				// clear PartTemp texture
			clear_to_color(PartTemp , makecol(255, 0, 255));
				// blit the appropriate section of Skin to PartTempt
			blit( Skin , PartTemp, 
				curPart->texX , curPart->texY, 
				0,0, 
				curPart->texW , curPart->texH);
				// pivot the PartTemp into the Render at the appropriate location
			pivot_sprite(Render, PartTemp, 
				RootLoc[inLayer[itor][itor2]]->x, 
				RootLoc[inLayer[itor][itor2]]->y, 
				curPart->Root->x, curPart->Root->y, 
				ftofix(-0.71111*RootAng[inLayer[itor][itor2]]) ); 
		}
	}

		// by now the render should be done
	return;
}


		
	


