/****************************Project*******************************
 * I am the speed hack 2006 project of Wilson Saunders. I will be 
 * a fighting game consisting of non humanoid warriors trying to
 * leap into each others brains. I will use code from the sprite pozer
 * as well as the sprite pozer program to animate these warriors.
 *
 * This Project was Started
 * 08/04/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the banana controll I maintain a list of bananas  that bounce
 * arround the battle field for the players to collect
 * 
 * This File Was Written:
 * 08/06/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include "bananaCtrl.h"
#include <math.h>
#include <allegro.h>


BananaCtrl::BananaCtrl(){
	int itor;

	helper1 = new PozePoint;
	helper2 = new PozePoint;

	for(itor =0; itor < NUM_BANANA; itor++){
		center[itor] = new  PozePoint;
		rotate[itor] = 0;
		active[itor] = false;
		bounces[itor] = 5;
		dx[itor] = 0;
		dy[itor] = 0;
	}
	timeTillDrop = 20;

	hand = create_bitmap( 3, 100);
	clear_to_color(hand, makecol(255, 0, 255));
	vline(hand, 0, 20, 40,makecol(100, 100, 100));
	vline(hand, 1, 0, 50,makecol(50, 50, 50));
	vline(hand, 2, 20, 40,makecol(0, 0, 0));
}

BananaCtrl::~BananaCtrl(){}



	// creat a banana here and toss it in a random direction
void BananaCtrl::Spawn(double x,double y){
	int itor;
	
		// find the first inactive banana
	for(itor = 0; itor < NUM_BANANA; itor++){
		if( active[itor] == false){
			active[itor] = true;
			dx[itor] = rand()%20 -10;
			dy[itor] = rand()% 20 -30;
			center[itor]->x = x +dx[itor]*8;
			center[itor]->y = y +dy[itor]*8;
			bounces[itor] = 10;
				// banana is ready to go
			return;
		}
	}
	return;
}

	// remove a banana from active and return true
	// if the banana is in the eating box
bool BananaCtrl::Eat(double x,double y){
	int itor;
	for(itor = 0; itor < NUM_BANANA; itor++){
		if( active[itor] == true &&
	//		bounces[itor] < 9 &&
			center[itor]->x > x-100 &&
			center[itor]->y > y-100 &&
			center[itor]->x < x+100 &&
			center[itor]->y < y+100 )
		{
			active[itor] = false;
			return true;
		}
	}



return false;
}


void BananaCtrl::UpdateUnit(int num){
	double deflect;
	double nextX = center[num]->x + dx[num];
	if(active[num] == false)return;

	dy[num] = 0.99*dy[num]+1.5;
	if(dy[num] > 30) dy[num] = 30;

	center[num]->x += dx[num];
	center[num]->y += dy[num];
	rotate[num] = (rotate[num] % 256) +dx[num];
	if(center[num]->y > SCREEN_H +20) active[num] = false;
    

		// check bounce
	if( exBlocks[ GetBlockLo(nextX) ]->
		IsInside(nextX, center[num]->y+dy[num]) && 
		dy > 0 &&
		bounces[num] >  0)
	{
			// if too deep inside repulse latterlily
		if(//exBlocks[ GetBlockLo(nextX) ]->
			//GetHiVal(nextX) > center[num]->y + 5*dy[num])
			false)
		{
			if( nextX > (exBlocks[ GetBlockLo(nextX) ]->hiYleft +
					exBlocks[ GetBlockLo(nextX) ]->hiYright)/2)
			{
				dx[num] = fabs(dx[num]);
				center[num]->x =  exBlocks[ GetBlockLo(nextX) ]->hiYright +2;
			}else{
				dx[num] = fabs(dx[num]) * -1.0;
				center[num]->x =  exBlocks[ GetBlockLo(nextX) ]->hiYleft -2;
			}
			bounces[num] -=1;
		}else {	// othewise repulse vertically
			deflect = exBlocks[ GetBlockLo(nextX) ]->hiYright -
				exBlocks[ GetBlockLo(nextX) ]->hiYleft;
			dx[num] = dx[num]* 0.9 + deflect *0.1;
			dy[num] = fabs(dy[num])*-0.95;
			bounces[num] -=1;
		}
	}


	return;

}

		
/******************************************************************
 * I am a value fetch funciton. I retrive a block index
 ******************************************************************/
int BananaCtrl::GetBlockLo( double xval){
	int val = ( xval/(2*ARENASIZE/NUMBLOCKS));
	if(val < 0) val = 0; 
	if(val >= NUMBLOCKS) val = NUMBLOCKS-1; 
	return val;
}
int BananaCtrl::GetBlockHi( double xval){
	int val = ( GetBlockLo(xval) + NUMBLOCKS/2);
	if(val < 0) val = 0; 
	if(val >= NUMBLOCKS) val = NUMBLOCKS-1; 
	return val;
}


void BananaCtrl::DrawBack(BITMAP * buffer, int left, int right){
	int itor;
	// draw the clock
	circlefill(buffer, SCREEN_W/2, 70, 55, makecol(200, 210, 200)); 
	circle(buffer, SCREEN_W/2, 70, 40, makecol(250, 250, 250)); 
	circle(buffer, SCREEN_W/2, 70, 55, makecol(50, 50, 50)); 
//	rotate_sprite(buffer, Image , SCREEN_W/2, 20, ftofix(timeTillDrop));
	pivot_sprite(buffer, Image , SCREEN_W/2, 70, Image->w,Image->h , ftofix(256 - timeTillDrop));

	// draw Background lines
	for (itor = 0; itor < SCREEN_H ; itor += 30){
		hline(buffer, 0,itor, SCREEN_W, makecol(200, 200, 255));

	}

	// draw left score board
	for (itor = 0; itor < 25; itor++){
		if( left > itor ){
			draw_sprite(buffer, Image, itor*SCREEN_W/60 ,5);
		}
		if( left-25 > itor ){
			draw_sprite(buffer, Image, itor*SCREEN_W/60 ,68);
		}
	}
	// draw right score board
	for (itor = 0; itor < 25; itor++){
		if( right > itor ){
			draw_sprite_h_flip(buffer, Image, SCREEN_W - (Image->w+itor*SCREEN_W/60) ,5);
		}
		if( right-25 > itor ){
			draw_sprite_h_flip(buffer, Image, SCREEN_W - (Image->w+itor*SCREEN_W/60) ,68);
		}
	}

}

void BananaCtrl::DrawUnit(BITMAP * buffer, int num, int dx){
	if(active[num] == false)
		return;

	rotate_sprite(buffer, Image , center[num]->x-dx, center[num]->y, itofix(rotate[num])); 
	return;
}
