/****************************Project*******************************
 * This Project is called "Sprite Pozer." It will opperate similar
 * to the 3d model Pozer programs only with 2d sprite based models.
 * This program is intended to be used as a tool for game development.
 * It will write files that can be read into this program or another 
 * program with the same class files
 *
 * This Project was Started
 * 05/07/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the Animation class. I contain a list of poses and delay values
 * I can set an external pose to a point anywhere in my time line. 
 * To facilitate faster processing I also have internal time markers.
 * 
 * This File Was Written:
 * 05/28/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include "animation.h"


/******************************************************************
 * I am the constructor I set the defaults and initilize the memory
 ******************************************************************/
Animation::Animation(){
	int itor;
	for(itor = 0; itor < MAXANIM; itor++){
		anim[itor] = NULL;
		delay[itor] = 5;
		timeLine[itor] = 99999;
	}
		// set the first anim values
	anim[0] = new Poze;
	delay[0] = 5;
	timeLine[0] = 0;
	lastIndex = 0;
	SetTimeLine();
	isDone = false;
	maxAge = 10;
}

/******************************************************************
 * I am the destructor
 ******************************************************************/
Animation::~Animation(){
	int itor;
	for(itor = 0; itor < MAXANIM; itor++){
		if( anim[itor] != NULL)
			delete(anim[itor]);
	}

}

/******************************************************************
 * I am the time line setting funciton. when I am done the values
 * in timeline and endPoze will be current with the state of the
 * anim and delay values. I must be run every time a new delay is set
 * or a the anim array is altered
 ******************************************************************/
void Animation::SetTimeLine(){
	int itor;
	int curtime = 0;
	Poze * lst = anim[0];

	for(itor = 0; itor < MAXANIM-1; itor++){
			// store old values
		lst = anim[itor];
        timeLine[itor] = curtime;	
			// incriment curtime
		curtime += delay[itor];
			// check for compleation
		if(anim[itor+1] == NULL) {
			timeLine[itor+1] = 99999;	// time corritlating to a null anim value
			endPoze = lst;
			lastIndex = itor;
			maxAge = curtime;
			return;
		}
	}
	return;
}

/******************************************************************
 * I am the time index retrieval function. I take in a time and return
 * the index of the anim/delay it belongs in. I do this by finding 
 * the spot in the time line where arg1 is less then ret+1 but greater
 * than ret.
 ******************************************************************/
int Animation::GetTimeIndex(int time){
	int itor;
		// check most popular instance where the return value will be the
		// same as the last return value
	if(time >= timeLine[lastIndex]  && time < timeLine[lastIndex+1]  ){
		return lastIndex;
	}
		// check seccond most popular instance where return valeu will be
		// one more than last return value
	if(time >= timeLine[lastIndex+1]  && time < timeLine[lastIndex+2]  ){
		lastIndex +=1;
		return lastIndex;
	}
		// in all other cases itorate through entire list untill
		// proper value is found
	for(itor =0; itor < MAXANIM-1; itor++){
		if(time >= timeLine[itor]  && time < timeLine[itor+1]  ){
			lastIndex = itor;
			return itor;
		}
	}	
		// if node done by here return default 0
	return 0;
}


/******************************************************************
 * I am the poze setter funciton. I set the tgt poze according to 
 * the what it should look like at the time provided in arg 2
 ******************************************************************/
void Animation::SetToTime(Poze * tgt, int time){
	int index = GetTimeIndex(time);
	int next = index+1;
	int a,b,c;
	double ratio = (double)(time - timeLine[index])  / (double)(delay[index]);
		
		// safty check on next
	if(anim[next] == NULL){
		tgt->Copy(endPoze);
		isDone = true;
		return;
	}
	tgt->Interpol(anim[index],anim[next], ratio);
	isDone = false;
		// tgt should be in te correct poze now;
	return;
}
	

/******************************************************************
 * I am the file writer function. I write the entire animation out 
 * to file. begining from the start and ending at end unless null is
 * encountered
 ******************************************************************/
void Animation::Write(FILE * file, int start, int end, int maxpart){
	int itor1, itor2;
	int a,b,c;
		// write out howmany lines between poses
	fprintf(file, "%d\n",maxpart);
	for (itor1 = start; itor1 < end && anim[itor1] != NULL; itor1++){
			// write out delay and xy coordinates
		a = (int)delay[itor1]; 
		b = (int)anim[itor1]->center->x; 
		c = (int)anim[itor1]->center->y;
		if(this->anim[itor1]->isHflip){
			fprintf(file, "%d %d %d f \n",  a,b,c);
		} else {
			fprintf(file, "%d %d %d n \n",  a,b,c);
		}

			// write out angle layer and index data
		for(itor2 = 0; itor2 < maxpart; itor2++){
			a = (int)anim[itor1]->ang[itor2];
			b = (int)anim[itor1]->layer[itor2];
			c = (int)anim[itor1]->index[itor2];
			fprintf(file, "%d %d %d\n", a,b,c);
		}
	}
	return;
}


/******************************************************************
 * I am the file writer function. I write the entire animation out 
 * to file. begining from the start and ending at end unless null is
 * encountered
 ******************************************************************/
void Animation::Read(FILE * file, int start){
	int itor1, itor2;
	int maxpart;
	int count = 4;
	int a,b,c;
	char d;
		// read in how many lines between poses
	fscanf(file, " %d ",&maxpart);
	for (itor1 = start; itor1 < MAXANIM && count == 4; itor1++){
			// ensure anim[itor1] exists

			// read in delay and xy coordinates
		count = fscanf(file, " %d %d %d %c ", &a, &b, &c, &d);
		if(count == 4 ){
			if(anim[itor1] == NULL) anim[itor1] = new Poze;
			delay[itor1] = a;
			anim[itor1]->center->x = b;
			anim[itor1]->center->y = c;
			anim[itor1]->isHflip = ( d == 'f');
		}
			// read in angle layer and index data
		if(count == 4){	
			for(itor2 = 0; itor2 < maxpart; itor2++){
				fscanf(file, " %d %d %d ", &a, &b, &c);
				anim[itor1]->ang[itor2] = a;
				anim[itor1]->layer[itor2] = b;
				anim[itor1]->index[itor2] = c;
			}
		}
	}
		// clean out rest of anim
	for (itor1 = itor1; itor1 < MAXANIM; itor1++){
		if(anim[itor1] != NULL) delete(anim[itor1]);
		anim[itor1] = NULL;
	}

	SetTimeLine();

}
