/****************************Project*******************************
 * This Project is called "Sprite Pozer." It will opperate similar
 * to the 3d model Pozer programs only with 2d sprite based models.
 * This program is intended to be used as a tool for game development.
 * It will write files that can be read into this program or another 
 * program with the same class files
 *
 * This Project was Started
 * 05/07/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the body class. I contain all the body parts and the 
 * texture they refrance. I do a bunch of calculations that result 
 * in a Pose being taken in and a temporary texture comming out.
 * 
 * This File Was Written:
 * 05/09/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include <stdio.h>
#include <allegro.h>
#include "bodypart.h"
#include "pozePoint.h"
#include "poze.h"

#ifndef __BODY_H__
#define __BODY_H__ 

#define NUMVIEWS 10

class Body {
public:
	Body();
	~Body();
	void SetToPoze(Poze * tgt);
	void SetPartToPoze(int part, Poze *tgt, int depth);

	void Read(FILE * in);
	void Write(FILE * out);

public:
	BodyPart * bodyParts[PARTCOUNT][NUMVIEWS];
	int boundToPart[PARTCOUNT];
	int boundAtAnchor[PARTCOUNT];

	BITMAP * Skin;
	BITMAP * Render;	// output
	BITMAP * PartTemp;

	int inLayer[9][PARTCOUNT];
	int inLayerTop[9];

		// these sould be generated by poze
	PozePoint * RootLoc[PARTCOUNT];
	double RootAng[PARTCOUNT];
	bool RootValid[PARTCOUNT];	
		// temp for pozer program
	PozePoint * AnchLoc[PARTCOUNT];
	

};

#endif
