/****************************Project*******************************
 * I am the speed hack 2006 project of Wilson Saunders. I will be 
 * a fighting game consisting of non humanoid warriors trying to
 * leap into each others brains. I will use code from the sprite pozer
 * as well as the sprite pozer program to animate these warriors.
 *
 * This Project was Started
 * 08/04/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the World class. I contain all objects in the in game screen
 * as well as the funcitons used to manipulate them. My funcitons Update
 * Draw should be called by the main.cpp file and my buffer should be 
 * blitted to vidio memory for rendering.
 * 
 * This File Was Written:
 * 08/04/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include <math.h>
#include "world.h"



/******************************************************************
 * I am the constructor I initilize all intenral memory
 ******************************************************************/
World::World(){
	int itor;
	
	BITMAP * Jack = load_bmp("skins\\Jack.bmp", palette);
	BITMAP * Poke = load_bmp("skins\\Poke.bmp", palette);

	alarm = load_wav("sounds\\elephant.wav");

	DrawBuffer = create_bitmap( SCREEN_W, SCREEN_H);
	oldP1Sel = oldP2Sel = oldLeft =oldRight = false;
	CamX = 0;

		// map editor controlls
	lBox = rBox = 0;
	listop =  ristop = false;

		// Fighter data
	Player1Ind = Player2Ind = 0;
	GameState = 1;	// chosoe

	P1Choice[INDJACK] = new FtrJack;
	P1Choice[INDJACKAI] = new FtrJack;
	P1Choice[INDJACK]->myBody->Skin =  Jack ;//load_bmp("skins\\Jack.bmp", palette);;
	P1Choice[INDJACKAI]->myBody->Skin  = Jack ;//load_bmp("skins\\Jack.bmp", palette);;
	P1Choice[INDPOKE] = new FtrPoke;
	P1Choice[INDPOKEAI] =new FtrPoke;
	P1Choice[INDPOKE]->myBody->Skin =  Poke ;//load_bmp("skins\\Poke.bmp", palette);
	P1Choice[INDPOKEAI]->myBody->Skin =  Poke ;//load_bmp("skins\\Poke.bmp", palette);
		
	P2Choice[INDJACK] = new FtrJack;
	P2Choice[INDJACKAI] = new FtrJack;
	P2Choice[INDJACK]->myBody->Skin =  Jack ;//load_bmp("skins\\Jack.bmp", palette);;
	P2Choice[INDJACKAI]->myBody->Skin =  Jack ;//load_bmp("skins\\Jack.bmp", palette);;
	P2Choice[INDPOKE] = new FtrPoke;
	P2Choice[INDPOKEAI] = new FtrPoke;
	P2Choice[INDPOKE]->myBody->Skin =  Poke ;//load_bmp("skins\\Poke.bmp", palette);
	P2Choice[INDPOKEAI]->myBody->Skin =  Poke ;//load_bmp("skins\\Poke.bmp", palette);

		// set AI
	P2Choice[INDJACKAI]->isAI = P2Choice[INDPOKEAI]->isAI = true;
	P1Choice[INDJACKAI]->isAI = P1Choice[INDPOKEAI]->isAI = true;

	myBananas = new BananaCtrl;
	myBananas->Image = load_bmp("skins\\banana.bmp", palette);
		

	for(itor = 0; itor < NUMBLOCKS/2; itor++){
		myBlocks[itor] = new CrashBox;

		myBlocks[itor]->Xleft = (itor*(2*ARENASIZE/NUMBLOCKS));
		myBlocks[itor]->Xright = ((itor+1)*(2*ARENASIZE/NUMBLOCKS));
		myBlocks[itor]->hiYleft = myBlocks[itor]->hiYright = SCREEN_H-35;
		myBlocks[itor]->loYleft = myBlocks[itor]->loYright = SCREEN_H+125;
	}
	for(itor = NUMBLOCKS/2; itor < NUMBLOCKS; itor++){
		myBlocks[itor] = new CrashBox;
		myBlocks[itor]->Xleft = ((-NUMBLOCKS/2)+itor)*(2*ARENASIZE/NUMBLOCKS);
		myBlocks[itor]->Xright =((-NUMBLOCKS/2)+itor+1)*(2*ARENASIZE/NUMBLOCKS);
		myBlocks[itor]->hiYleft = myBlocks[itor]->hiYright = SCREEN_H-15;
		myBlocks[itor]->loYleft = myBlocks[itor]->loYright = SCREEN_H-05;
	}

	myBananas->exBlocks = myBlocks;

		// laod external values into the


	for (itor = 0; itor < INDTOTAL; itor++){
		P2Choice[itor]->exBananas = P1Choice[itor]->exBananas = myBananas;
		P2Choice[itor]->exBlocks = P1Choice[itor]->exBlocks = myBlocks;
		P2Choice[itor]->LoadLocal(); 
		P1Choice[itor]->LoadLocal();
	}

	StartMatch();

	level= create_bitmap(P2Choice[0]->level->w , P2Choice[0]->level->h); 
	clear_to_color(level, makecol(255, 0, 255));
	hline(level, 0, level->h -5, level->w, makecol(155, 155, 155));
	
	for (itor = 0; itor < level->w ; itor+=36){
			vline(level, itor, level->h -4, level->h, makecol(195, 195, 195));
	}

	screentemp = create_bitmap(SCREEN_W*P2Choice[0]->level->w/ARENASIZE, 
		SCREEN_H*P2Choice[0]->level->w/ARENASIZE);
//	LevelDinge(); 

	LoadTextures();
}

/******************************************************************
 * I am the destructor I free all intenral memory
 ******************************************************************/
World::~World(){
	

}

/******************************************************************
 * I am the Match start function
 ******************************************************************/
void World::StartMatch(){
	int itor;
	FILE * file;
	Player1 = P1Choice[Player1Ind%INDTOTAL];
	Player2 = P2Choice[Player2Ind%INDTOTAL];

		// set start locaitons
	Player2->center->x = ARENASIZE/2+150;
	Player2->center->y = 350;

	Player1->center->x = ARENASIZE/2-150;
	Player1->center->y = 350;
		// link players
	Player1->exEnemy = Player2;
	Player2->exEnemy = Player1;

		// sweep through all choices and find the dead one
		// to set the next level values
	for(itor = 0; itor < INDTOTAL; itor++){
		if(P1Choice[itor]->isDead){
			level= P1Choice[itor]->level; 
			if(itor % 2 == 0 ){
				file = fopen("levels\\Jack.txt","r");
			} else {
				file = fopen("levels\\Poke.txt","r");
			}
			LoadLevel(file);
			fclose(file);
		}
		if(P2Choice[itor]->isDead){
			level= P2Choice[itor]->level; 
			if(itor % 2 == 0 ){
				file = fopen("levels\\Jack.txt","r");
			} else {
				file = fopen("levels\\Poke.txt","r");
			}
			LoadLevel(file);
			fclose(file);
		}

		P1Choice[itor]->isDead = false;
		P1Choice[itor]->animTime = 0; 
		P1Choice[itor]->curAnim = P1Choice[itor]->aStand; 
		P1Choice[itor]->curAnim->SetToTime(P1Choice[itor]->curPoze ,0);
		P1Choice[itor]->BananaCount = 0;

		P2Choice[itor]->isDead = false;
		P2Choice[itor]->animTime = 0; 
		P2Choice[itor]->curAnim = P2Choice[itor]->aStand; 
		P2Choice[itor]->curAnim->SetToTime(P2Choice[itor]->curPoze ,0);
		P2Choice[itor]->BananaCount = 0;


	}
		// clean up bananas
	for( itor = 0; itor < NUM_BANANA; itor++){
		myBananas->active[itor] = false;
	}
	myBananas->timeTillDrop = 200;

}


/******************************************************************
 * I am the texture initilizer I load all textures into the game.
 * I get quite repetitive so my code is kept outside of the main 
 * intilization.
 ******************************************************************/
void World::LoadTextures(){

	return;
}


/******************************************************************
 * I am the Update function I am called on a regular basis to update
 * physics and animaiton data
 ******************************************************************/
void World::Update(){
	int itor;
	HandelInput();
		//swap game states
	if(GameState == 1){
		StartMatch();

		if(key[KEY_S] && ! oldP1Sel ){
			Player1Ind += 1;
		}
		oldP1Sel = key[KEY_S];
		
		if(key[KEY_DOWN] && ! oldP2Sel ){
			Player2Ind += 1;
		}
		oldP2Sel = key[KEY_DOWN];
		

		if(key[KEY_SPACE]) GameState = 0;
		return;
	}
	if(GameState == 0){
		if(Player1->isDead == true ||
			Player2->isDead == true) 
			
		GameState = 1;
	}

	Player1->Update();
	Player2->Update();

	myBananas->timeTillDrop -= 0.5 ;
	for (itor = 0; itor < NUM_BANANA; itor++){
		myBananas->UpdateUnit(itor);
		if(myBananas->timeTillDrop < 0 ) myBananas->Spawn(CamX+SCREEN_W/2, -30);
	}
	if(myBananas->timeTillDrop < 0){
		myBananas->timeTillDrop = 256;
		play_sample(alarm  , 255, 128, 1000, false);
	}	

	return;
}


/******************************************************************
 * I am the Input handeler funciton I am called on update and I check
 * the keyboard and mouse values for user input. I then pass that input 
 * to the internal classes that need it.
 ******************************************************************/
void World::HandelInput(){
	int tcam;
		// uncomment to make editing program
//	HiMapmaker();
//	return;

	tcam = (Player1->center->x+Player2->center->x)/2 -SCREEN_W/2;
	if(tcam < 0)tcam = 0;
	if(tcam > ARENASIZE - SCREEN_W) tcam = ARENASIZE - SCREEN_W;

		// pass keyboard input to players
	Player1->Input[PK_UP] = key[KEY_W];
	Player1->Input[PK_DOWN] = key[KEY_S];
	Player1->Input[PK_LEFT] = key[KEY_A];
	Player1->Input[PK_RIGHT] = key[KEY_D];
	Player1->Input[PK_WEAK] = key[KEY_G];
	Player1->Input[PK_STRONG] = key[ KEY_H];


	Player2->Input[PK_UP] = key[KEY_UP];
	Player2->Input[PK_DOWN] = key[KEY_DOWN];
	Player2->Input[PK_LEFT] = key[KEY_LEFT];
	Player2->Input[PK_RIGHT] = key[KEY_RIGHT];
	Player2->Input[PK_WEAK] = key[KEY_COMMA];
	Player2->Input[PK_STRONG] = key[KEY_STOP];



	CamX = tcam;
}


/******************************************************************
 * I am the Input handeler mapmaker function. I handle the user
 * input with reguard to map making
 ******************************************************************/
void World::HiMapmaker(){
	int itor;
	double mindist = SCREEN_W;
	double dist;
	double dx, dy;
	FILE* file;

		// shift screen
	if(key[KEY_LEFT] && CamX > 0 ) CamX -= 5;
	if(key[KEY_RIGHT] && CamX < ARENASIZE - SCREEN_W ) CamX += 5;

		// load or save file
	if(key[KEY_O]){
		file = fopen("levels\\temp.txt","w");
		SaveLevel(file);
		fclose(file);
	}
	if(key[KEY_L]){
		file = fopen("levels\\temp.txt","r");
		LoadLevel(file);
		fclose(file);
	}
	if(key[KEY_P]){
		file = fopen("levels\\Jack.txt","r");
		LoadLevel(file);
		fclose(file);
	}

		// check left mouse for click
	if(mouse_b & 1 && oldLeft == false){
//		for(itor=0; itor < NUMBLOCKS; itor++){
		for(itor = ((mouse_x+CamX-25)*NUMBLOCKS) /(2*ARENASIZE) ;
				itor < NUMBLOCKS; itor+= NUMBLOCKS/2)
		{
				// calc dist to all top right nodes
			dx = mouse_x + (double)(CamX) - myBlocks[itor]->Xright;
			dy = mouse_y - myBlocks[itor]->hiYright;
			dist = sqrt((dx*dx)+(dy*dy));
				// set new min distif neccisary
			if(dist < mindist){
				rBox = itor;
				ristop = true;
				mindist = dist;
			}
				// calc dist to bottom right side nodes
			dy = mouse_y - myBlocks[itor]->loYright;
			dist = sqrt((dx*dx)+(dy*dy));
				// set new min distif neccisary
			if(dist < mindist){
				rBox = itor;
				ristop = false;
				mindist = dist;
			}
		}
	}	// end left mouse click handeler


		// check right mouse for click
	if(mouse_b & 2 && oldRight == false){
//		for(itor=0; itor < NUMBLOCKS; itor++){
		for(itor = ((mouse_x+CamX+25)*NUMBLOCKS) /(2*ARENASIZE) ;
				itor < NUMBLOCKS; itor+= NUMBLOCKS/2)
		{
					// calc dist to all top right nodes
			dx = mouse_x + (double)(CamX) - myBlocks[itor]->Xleft;
			dy = mouse_y - myBlocks[itor]->hiYleft;
			dist = sqrt((dx*dx)+(dy*dy));
				// set new min distif neccisary
			if(dist < mindist){
				lBox = itor;
				listop = true;
				mindist = dist;
			}
				// calc dist to bottom right side nodes
			dy = mouse_y - myBlocks[itor]->loYleft;
			dist = sqrt((dx*dx)+(dy*dy));
				// set new min distif neccisary
			if(dist < mindist){
				lBox = itor;
				listop = false;
				mindist = dist;
			}
		}
	}	// end left mouse click handeler

		// handle left mouse drag
	if(mouse_b & 1){
		if(ristop){
			myBlocks[rBox]->hiYright = mouse_y;
		}else {
			myBlocks[rBox]->loYright = mouse_y;
		}
	}

		// handle right mouse drag
	if(mouse_b & 2){
		if(listop){
			myBlocks[lBox]->hiYleft = mouse_y;
		}else {
			myBlocks[lBox]->loYleft = mouse_y;
		}
	}


	oldLeft = mouse_b & 1; 
	oldRight = mouse_b & 2;
}


/******************************************************************
 * I am the save Grid funciton I write the grid out to text file
 * so it can be loaded back via the load grid funciton.
 ******************************************************************/
void World::SaveLevel(FILE * file){
	int itor;
	int x1,x2, y1h, y1l, y2h, y2l;

	for(itor=0; itor < NUMBLOCKS; itor++){
//		x1 = SCREEN_H - myBlocks[itor]->Xleft;
//		x2 = SCREEN_H - myBlocks[itor]->Xright;
		y1h = SCREEN_H - myBlocks[itor]->hiYleft;
		y1l = SCREEN_H - myBlocks[itor]->loYleft;
		y2h = SCREEN_H - myBlocks[itor]->hiYright;
		y2l = SCREEN_H - myBlocks[itor]->loYright;
			// print to file
		fprintf(file,"%d %d %d %d \n", y1h, y1l, y2h, y2l); 
	}

	
	return;
}

/******************************************************************
 * I am the load Grid funciton. I load the text file save wrote to
 ******************************************************************/
void World::LoadLevel(FILE * file){
	int itor;
	int x1,x2, y1h, y1l, y2h, y2l;

	for(itor=0; itor < NUMBLOCKS; itor++){
		fscanf(file,"%d %d %d %d ", &y1h, &y1l, &y2h, &y2l); 
//		myBlocks[itor]->Xleft = SCREEN_H - x1;
//		myBlocks[itor]->Xright = SCREEN_H - x2;
		myBlocks[itor]->hiYleft = SCREEN_H - y1h;
		myBlocks[itor]->loYleft = SCREEN_H - y1l;
		myBlocks[itor]->hiYright = SCREEN_H - y2h;
		myBlocks[itor]->loYright = SCREEN_H - y2l;

		if(myBlocks[itor]->hiYleft > SCREEN_H -36) myBlocks[itor]->hiYleft = SCREEN_H +120;
		if(myBlocks[itor]->hiYright > SCREEN_H -36) myBlocks[itor]->hiYright = SCREEN_H +120;
		if(myBlocks[itor]->loYleft > SCREEN_H -36) myBlocks[itor]->loYleft = SCREEN_H +150;
		if(myBlocks[itor]->loYright > SCREEN_H -36) myBlocks[itor]->loYright = SCREEN_H +150;
		
	}
	return;
}


/******************************************************************
 * I am the Level dinger I make the level look dingey by averageing
 * the colors to 100
 ******************************************************************/
void World::LevelDinge(){
	int Xitor,Yitor;
	int color;
	int r,g,b;

	for(Yitor = 0; Yitor < level->h; Yitor++){
		for(Xitor = 0; Xitor < level->w; Xitor++){	
			color = getpixel(level, Xitor, Yitor);
			if( getr(color) == 255 && 
				getg(color) == 0 &&
				getb(color) == 255)
			{	
			}else{
				r= (2*getr(color)+100)/3;
				g= (2*getg(color)+100)/3;
				b= (2*getb(color)+100)/3;
				putpixel(level, Xitor, Yitor, makecol(r,g,b));
			}
		}
	}
	return;
}


/******************************************************************
 * I am the Draw function. I set the internal screen buffer to
 * render the appropriate sceen. This should be done prior to Blitting
 ******************************************************************/
void World::Draw(){
	int itor;
	int picshift =  level->w *CamX / ARENASIZE;
	int bgY = level->h*level->w/ARENASIZE;
	clear_to_color(DrawBuffer, makecol(255, 255, 255));

		// draw background
	myBananas->DrawBack(DrawBuffer, Player1->BananaCount , Player2->BananaCount);

		// compute bitmap
	blit(level, screentemp , picshift, level->h-screentemp->h, 0, 0, screentemp->w, screentemp->h); 
//	blit(level, DrawBuffer , picshift, level->h-screentemp->h, 0, 0, screentemp->w, screentemp->h); 
	stretch_sprite(DrawBuffer, screentemp, 0, 0,  SCREEN_W, SCREEN_H); 


//	line(DrawBuffer, mouse_x-4, mouse_y-4, mouse_x+4, mouse_y+4, makecol(0, 255, 0)); 
//	line(DrawBuffer, mouse_x-4, mouse_y+4, mouse_x+4, mouse_y-4, makecol(0, 255, 0));

	for(itor = 0; itor < NUMBLOCKS; itor++){
//		myBlocks[itor]->Draw(DrawBuffer, CamX ,0, 
//			myBlocks[itor]->IsInside(mouse_x+CamX, mouse_y));
	}

	Player1->Draw(DrawBuffer, CamX);
	Player2->Draw(DrawBuffer, CamX);

		// draw bannanas
	for( itor = 0; itor < NUM_BANANA; itor++){
		myBananas->DrawUnit(DrawBuffer,itor, CamX);
	}

		// draw game state text
	if( GameState == 1){
		textout_centre_ex(DrawBuffer, font, "press SPACE to start", SCREEN_W/2, SCREEN_H/2,
			 makecol(0, 0, 0), -1);


		textout_centre_ex(DrawBuffer, font, "press (S) to chainge", 
			Player1->center->x-CamX , Player1->center->y + 20,
			 makecol(0, 0, 0), -1);

		switch( Player1Ind % INDTOTAL){
			case 0:
				textout_centre_ex(DrawBuffer, font, "Jack", 
					Player1->center->x-CamX , Player1->center->y + 10,
					 makecol(0, 0, 0), -1);
			break;
			case 1:
				textout_centre_ex(DrawBuffer, font, "Poke", 
					Player1->center->x-CamX , Player1->center->y + 10,
					 makecol(0, 0, 0), -1);
			break;
			case 2:
				textout_centre_ex(DrawBuffer, font, "Jack AI", 
					Player1->center->x-CamX , Player1->center->y + 10,
					 makecol(0, 0, 0), -1);
			break;
			case 3:
				textout_centre_ex(DrawBuffer, font, "Poke AI", 
					Player1->center->x-CamX , Player1->center->y + 10,
					 makecol(0, 0, 0), -1);
			break;
		}
		textout_centre_ex(DrawBuffer, font, "press (S) to chainge", 
			Player1->center->x-CamX , Player1->center->y + 20,
			 makecol(0, 0, 0), -1);

		textout_centre_ex(DrawBuffer, font, "press (arrow down) to chainge", 
			Player2->center->x-CamX , Player2->center->y + 20,
			 makecol(0, 0, 0), -1);
		switch( Player2Ind % INDTOTAL){
			case 0:
				textout_centre_ex(DrawBuffer, font, "Jack", 
					Player2->center->x-CamX , Player2->center->y + 10,
					 makecol(0, 0, 0), -1);
			break;
			case 1:
				textout_centre_ex(DrawBuffer, font, "Poke", 
					Player2->center->x-CamX , Player2->center->y + 10,
					 makecol(0, 0, 0), -1);
			break;
			case 2:
				textout_centre_ex(DrawBuffer, font, "Jack AI", 
					Player2->center->x-CamX , Player2->center->y + 10,
					 makecol(0, 0, 0), -1);
			break;
			case 3:
				textout_centre_ex(DrawBuffer, font, "Poke AI", 
					Player2->center->x-CamX , Player2->center->y + 10,
					 makecol(0, 0, 0), -1);
			break;
		}

	}


}

