/****************************Project*******************************
 * This Project is called "Sprite Pozer." It will opperate similar
 * to the 3d model Pozer programs only with 2d sprite based models.
 * This program is intended to be used as a tool for game development.
 * It will write files that can be read into this program or another 
 * program with the same class files
 *
 * This Project was Started
 * 05/07/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the Pozer Point Class. I contain functions that translate, 
 * rotate, copy, find angels, and distances between two points
 * 
 * This File Was Written:
 * 05/08/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include <math.h>
#include "pozePoint.h"



/*****************************************************************
 * I am the constructor, I initilize the internal values
 ******************************************************************/
PozePoint::PozePoint(){
	x = y = 0;
}

/*****************************************************************
 * I am the destructor, I exist for good form
 ******************************************************************/
PozePoint::~PozePoint(){}


/*****************************************************************
 * I am the allocator function I set this PozePoint to the value in
 * the tgt Poze point
 ******************************************************************/
void PozePoint::Copy(PozePoint * tgt){
	x = tgt->x;
	y = tgt->y;
}


/*****************************************************************
 * I am the distance finder
 ******************************************************************/
double PozePoint::DistTo(PozePoint * tgt){
	double dx = x - tgt->x ;
	double dy = y - tgt->y;
	return sqrt(dx*dx + dy*dy);
}

/*****************************************************************
 * I am the angel finder I return the angel in degrees 
 ******************************************************************/
double PozePoint::AngTo(PozePoint * tgt){
	double dx = x - tgt->x ;
	double dy = y - tgt->y;
	double hyp = sqrt(dx*dx + dy*dy);
		// return 0 if points are on top of each other
	if(hyp == 0)	return 0;

	if(dx > 0){
		return acos(dy/hyp)*57.29579;
	} 
	
	return acos(dy/hyp)*-57.29579;

}


/*****************************************************************
 * I am the angel finder I return the angel in degrees 
 ******************************************************************/
void PozePoint::RotateBy(double degree)
{
	double DtoR = 0.0174532925;
	double si = sin(degree*DtoR);
	double co = cos(degree*DtoR);
	double oldX = x;
	double oldY = y;

		// X remains unchainged
	x = co*oldX + si*oldY;
	y = co*oldY - si*oldX;

	return;
}


/*****************************************************************
 * I am the angel finder I return the angel in degrees 
 ******************************************************************/
void PozePoint::Translate(double dx, double dy){
	x += dx;
	y += dy;
}

