/****************************Project*******************************
 * This Project is called "Zombie Robot War" it is an Open Source
 * demo for the Sprite pozer program. This program will demonstrate how
 * to load and use the files generated by the Sprite Pozer. Feel free
 * to use any of the source code provided. This is not GNU licenced and
 * you are under no obligation to release your project's source. I ask you
 * mention me Wilson Saunders in the credits and provide a link to my webpage
 * http://www.freewebs.com/hamstermk4/
 * but you are under no obligation to do so.
 *
 * This Project was Started
 * 06/25/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the main function file. I hold the main funtion which creates 
 * the world and passes important data to it. I also am responsible
 * for the screen rendering, World update calling and maintaining 
 * the semaphores that prevent them from clobbering each other.
 * 
 * This File Was Written:
 * 06/25/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include <allegro.h>
//#include "screenCtrl.h"
#include "world.h"
//#include "Menue.h"

// Globals
World * myWorld;

/******************************************************************
 * I am timer call back function
 *****************************************************************/
void UpdateFunc(){
	myWorld->Update();
	return;
}

/******************************************************************
 * I am the program starting point and guardian of the game loop
 *****************************************************************/
int main(int argc, char *argv[])
{
	bool notDone = true;

		////////////////////////////////////////////
		//			Initilization Section
		////////////////////////////////////////////
	allegro_init();
	install_keyboard(); 
	install_mouse();

	set_color_depth(16);

		// initilize window
	//GFX_AUTODETECT_FULLSCREEN
	//GFX_AUTODETECT_WINDOWED
	if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 1024, 768, 0, 0) != 0) {
//	if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0) != 0) {
			// if you are here graphic initilization failed
		set_gfx_mode(GFX_TEXT, 0,0,0,0);
		allegro_message("Graphics Initilization Failed");
		return 1;
	}
		// initilize world

	myWorld = new World;

	rest(100);	// wait for world to finish initilization
				// before starting timer


		// initilize timer
	if ( install_int(UpdateFunc, 30) != 0){
			// if you are here timer initilization failed
		set_gfx_mode(GFX_TEXT, 0,0,0,0);
		allegro_message("Timer Initilization Failed");
		return 1;
	}
		// intilize Mouse
	if ( install_mouse() == -1){
			// if you are here timer initilization failed
		set_gfx_mode(GFX_TEXT, 0,0,0,0);
		allegro_message("Mouse Initilization Failed");
		return 1;
	}
		// initilize sound
	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) {
      allegro_message("Sound Initilization Failed");
      return 1;
    }
	

		////////////////////////////////////////////
		//			Game Loop Sections
		////////////////////////////////////////////
	while ( notDone )
	{
			// check keyboard for interface
		if (key[KEY_ESC]) notDone = false;	// we are now done


		myWorld->Draw();
		
		vsync();

		blit( myWorld->DrawBuffer , screen, 0,0, 0,0, SCREEN_W, SCREEN_H);

	}	
		////////////////////////////////////////////
		//			Clean Up Time
		////////////////////////////////////////////
	allegro_exit(); 
//	delete(myWorld);

	return 0;
}
END_OF_MAIN();

