/****************************Project*******************************
 * I am the speed hack 2006 project of Wilson Saunders. I will be 
 * a fighting game consisting of non humanoid warriors trying to
 * leap into each others brains. I will use code from the sprite pozer
 * as well as the sprite pozer program to animate these warriors.
 *
 * This Project was Started
 * 08/04/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the crash box class. I contain the data of a 4 cornered 
 * box that can detect when an object has entered it. the Crash box
 * will determine where the object should be placed if it enters
 * its territory. This should be used for bounding stationary objects
 * in the world
 * 
 * This File Was Written:
 * 08/04/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include "CrashBox.h"


/******************************************************************
 * I am the initilizer I set default values
 ******************************************************************/
CrashBox::CrashBox(){
	barLeft = barRight = false;

	Xleft = 0;
	Xright = 1;

	hiYleft = hiYright= 1;
	loYleft = loYright = 0;
}

/******************************************************************
 * I am the destructor 
 ******************************************************************/
CrashBox::~CrashBox(){

}


/******************************************************************
 * I am the height calculator for the high line 
 ******************************************************************/
double CrashBox::GetHiVal(double X){
	double  ratio;
		// take care of bounds violation
	if(X < Xleft ) return hiYleft;
	if(X > Xright ) return hiYright;

	ratio =  (X - Xleft)/(Xright - Xleft);

	return hiYright*ratio + hiYleft*(1-ratio);
}

/******************************************************************
 * I am the height calculator for the lo line 
 ******************************************************************/
double CrashBox::GetLoVal(double X){
	double  ratio;
		// take care of bounds violation
	if(X < Xleft ) return loYleft;
	if(X > Xright ) return loYright;

	ratio =  (X - Xleft)/(Xright - Xleft);

	return loYright*ratio + loYleft*(1-ratio);
}

/******************************************************************
 * I am the check funciton I return true if the point is inside me 
 ******************************************************************/
bool CrashBox::IsInside(double tgtX,  double tgtY){
	// handle left and right bounds
	if(tgtX < Xleft  || tgtX > Xright) return false;
		// handle high bounds
	if(tgtY < GetHiVal(tgtX)) return false;
		// handle low bounds
	if(tgtY > GetLoVal(tgtX)) return false;
		// if you get heer you are inside
	return true;
}
	

/******************************************************************
 * I am the repeller functions I return the repulsion that should
 * be done to keep an object at the location X,Y out of my area.
 ******************************************************************/
double CrashBox::RepellN(double tgtX, double tgtY){
	if(IsInside(tgtX, tgtY) == false) return 0;
	return GetHiVal(tgtX) - tgtY;
}
double CrashBox::RepellS(double tgtX, double tgtY){
	if(IsInside(tgtX, tgtY) == false) return 0;
	return GetLoVal(tgtX) - tgtY;
}
double CrashBox::RepellE(double tgtX, double tgtY){
	if(IsInside(tgtX, tgtY) == false) return 0;
	return Xright - tgtX;
}
double CrashBox::RepellW(double tgtX, double tgtY){
	if(IsInside(tgtX, tgtY) == false) return 0;
	return Xleft  - tgtX;
}



/******************************************************************
 * I am the draw funciton I am here for debugging only
 ******************************************************************/
void CrashBox::Draw(BITMAP * DrawBuffer, double dx,  double dy, bool hit){
	
	if(hit){
		line(DrawBuffer, Xleft-dx , hiYleft-dy ,Xright-dx ,hiYright-dy , makecol(255, 0 , 0)); 
		line(DrawBuffer, Xleft-dx , loYleft-dy ,Xright-dx ,loYright-dy , makecol(255, 100 , 100));
	} else {
		line(DrawBuffer, Xleft-dx , hiYleft-dy ,Xright-dx ,hiYright-dy , makecol(0, 0 , 255)); 
		line(DrawBuffer, Xleft-dx , loYleft-dy ,Xright-dx ,loYright-dy , makecol(100, 100 , 255));
	}

	line(DrawBuffer, Xleft-dx , loYleft-dy , Xleft-dx , hiYleft-dy , makecol(100, 100 , 100)); 
	line(DrawBuffer, Xright-dx ,loYright-dy ,Xright-dx ,hiYright-dy , makecol(100, 100 , 100));



}
