/****************************Project*******************************
 * This Project is called "Sprite Pozer." It will opperate similar
 * to the 3d model Pozer programs only with 2d sprite based models.
 * This program is intended to be used as a tool for game development.
 * It will write files that can be read into this program or another 
 * program with the same class files
 *
 * This Project was Started
 * 05/07/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the poze class. I contain layers, angels, and indexes that  
 * corrilate to bodyParts in the body. I also have a point that 
 * indicates where in the output texture the body should be centered 
 * in. I have functions that can copy other pozes and interpolate 
 * between two pozes.
 * 
 * This File Was Written:
 * 05/09/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include "pozePoint.h"

#ifndef __POZE_H__
#define __POZE_H__

#define PARTCOUNT 20

class Poze {
public:
	Poze();
	~Poze();

	void Copy(Poze * tgt);
	void Interpol(Poze * start, Poze * end, double frac);

	double SetAvg(double start, double end, double frac);

public:
	PozePoint * center;
	bool isHflip;

	double ang[PARTCOUNT];
	int layer[PARTCOUNT];
	int index[PARTCOUNT];
};


#endif

