/****************************Project*******************************
 * I am the speed hack 2006 project of Wilson Saunders. I will be 
 * a fighting game consisting of non humanoid warriors trying to
 * leap into each others brains. I will use code from the sprite pozer
 * as well as the sprite pozer program to animate these warriors.
 *
 * This Project was Started
 * 08/04/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the fighter class. I am the template class for all fighters
 * I contain a body which takes care of my rendering but I must calculate
 * what poze it should be in based on the animaiton data.
 * 
 * This File Was Written:
 * 08/05/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include <allegro.h>
#include "CrashBox.h"
#include "screenDef.h"
#include "Body.h"
#include "animation.h"
#include "bananaCtrl.h"

#ifndef __FIGHTER_H__
#define __FIGHTER_H__

#define PK_UP		0
#define PK_DOWN		1
#define PK_LEFT		2
#define PK_RIGHT	3
#define PK_WEAK		4
#define PK_STRONG	5
#define PK_BLOCK	6
#define PK_TOTAL	7


class Fighter{
public:
	Fighter();
	~Fighter();

	virtual void LoadLocal();
	void LevelDinge();

	void Update();
	void DoMovement();
	virtual void SetRepulsors();
	void PozeHub();

	virtual void setmyHurt(); 
	void getHurt();

	void DoAI();

	int GetBlockHi( double xval);
	int GetBlockLo( double xval);

	void Draw(BITMAP * buffer, int dx);

public:
	PozePoint * center;
	PozePoint * hurtPt;
	int hurtval;
	double dx, dy;
	double velox, veloy;

	bool isDead;
	bool isAI;
		// simple button masher AI
	int AIdelay;
	int AIaction;

	bool Input[PK_TOTAL];
	bool OldInp[PK_TOTAL];

	
		// externals
	CrashBox ** exBlocks;
	Fighter * exEnemy;
	BananaCtrl * exBananas;

		// repulsor points
	PozePoint * repFoot;
	PozePoint * repHead;
	PozePoint * repLefthi;
	PozePoint * repLeftlo;
	PozePoint * repRighthi;
	PozePoint * repRightlo;

		// render objects
	Body * myBody;
	Poze * curPoze;
	Poze * lastPoze;

	int animTime;
	int animMode;
	Animation * curAnim;

	int BananaCount;

	int Nova;

	SAMPLE  * Sounds[6];

	BITMAP * level;

	Animation * aStand;
	Animation * aWalkB;
	Animation * aWalkF;
	Animation * aJump;
	Animation * aReel;
	Animation * aFall;
	Animation * aRecover;
	Animation * aWattack;
	Animation * aSattack;
	Animation * aCrouchAtk;
	Animation * aWfly;
	Animation * aSfly;
	Animation * aDive;
	Animation * aDead;
};

#endif

