/****************************Project*******************************
 * This Project is called "Sprite Pozer." It will opperate similar
 * to the 3d model Pozer programs only with 2d sprite based models.
 * This program is intended to be used as a tool for game development.
 * It will write files that can be read into this program or another 
 * program with the same class files
 *
 * This Project was Started
 * 05/07/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the Animation class. I contain a list of poses and delay values
 * I can set an external pose to a point anywhere in my time line. 
 * To facilitate faster processing I also have internal time markers.
 * 
 * This File Was Written:
 * 05/28/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include "pozePoint.h"
#include "body.h"
#include "poze.h"
#include <stdio.h>

#ifndef __ANIMATION_H__
#define __ANIMATION_H__

#define MAXANIM 50

class Animation {
public:
	Animation();
	~Animation();

	void SetToTime(Poze * tgt, int time);
		// I set the time line values
	void SetTimeLine();
	int GetTimeIndex(int time);

	void Read(FILE * file, int start);
	void Write(FILE * file, int start, int end, int maxpart);

public:
	Poze * anim[MAXANIM];
	int delay[MAXANIM];
	int timeLine[MAXANIM];

	Poze * endPoze;	// pointer to the last valid pose in anim

	int lastIndex;
	int maxAge;
	bool isDone;

};

#endif

