//The Sandman's Dream main file.
// Copyright(c) by Davis Goodin 2006

//Standard headers
#include <iostream>
#include <allegro.h>
#include <math.h>
//My headers
#include "particlegrid.h"



BITMAP* interface;

int size; //Size of brush in pixels. (One doesn't work though.)

const int WALL = 1;
const int SAND = 2;
const int WATER = 3;

int currentelement; //The element you draw with.

void display_interface(); //Changes the interface bitmap. (It is then blitted to screen with next command.
void handle_interface_click(int x, int y);

int main()
{

     allegro_init();
     install_keyboard();
     install_mouse();

    currentelement = WALL; //Default


     size = 5;
     set_color_depth(8);
     set_gfx_mode( GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0);

     install_timer();

     show_mouse(screen);



     particles parts;

     set_window_title("Sandman's Dream");
     parts.sand = create_bitmap(600,600);
     parts.init_particle_grids();


     interface = create_bitmap(200,600);
     clear_to_color(interface, makecol(200,200,200));

     display_interface();

     while(!key[KEY_ESC])
     {
            // Draws particles if it should be able to.
            if(mouse_b & 1 && mouse_x < 600)
          {
               parts.draw_particle(currentelement, mouse_x,mouse_y, size);
          }

          parts.previous_xmouse = mouse_x;
          parts.previous_ymouse = mouse_y;


          //Optional way of selecting elements. Interface is preferred.
          if(key[KEY_0_PAD])
          {
               currentelement = 0;
               display_interface();
          }
          if(key[KEY_1_PAD])
          {
               currentelement = WALL;
               display_interface();
          }
          if(key[KEY_2_PAD])
          {
               currentelement = SAND;
               display_interface();
          }
          if(key[KEY_3_PAD])
          {
               currentelement = WATER;
               display_interface();
          }

          //Sizes
          if(key[KEY_1])
          {
               size = 1;
               display_interface();
          }
          if(key[KEY_2])
          {
               size = 2;
               display_interface();
          }
          if(key[KEY_3])
          {
               size = 5;
               display_interface();
          }
          if(key[KEY_4])
          {
               size = 10;display_interface();
          }
          if(key[KEY_5])
          {
               size = 15;display_interface();
          }
          if(key[KEY_6])
          {
               size = 25;display_interface();
          }
          if(key[KEY_7])
          {
               size = 50;display_interface();
          }

          //Updates the interface
          if(mouse_x > 600)
          {
                display_interface();

          }

          //Handles the clicking on the interface.
          if(mouse_b & 1 && mouse_x > 600)
          {
               handle_interface_click(mouse_x,mouse_y);
          }

          //Does all the particle stuff if the mouse is on the play area.
          if(mouse_x < 600)
          {
            parts.calculate_particles();
            parts.draw_parts();
            parts.refresh_grid();
          }


          blit(parts.sand,screen,0,0,0,0,600,600);//Blits the sand to the screen.
          blit(interface, screen, 0,0,600,0,200,600); //Blits the interface to the screen.


          rest(20);
     }
}
END_OF_MAIN()



void display_interface()
{
    clear_to_color(interface, makecol(200,200,200));
    textout_ex(interface, font, "Empty", 20,5, makecol(255,255,255), makecol(0,0,0));
    textout_ex(interface, font, "Wall", 20,15, makecol(255,255,255), makecol(0,0,0));
    textout_ex(interface, font, "Sand", 20,25, makecol(255,255,255), makecol(0,0,0));
    textout_ex(interface, font, "Water", 20,35, makecol(255,255,255), makecol(0,0,0));
    textout_ex(interface, font, "Fire", 20,45, makecol(255,255,255), makecol(0,0,0));

    switch(currentelement)
    {
        case 0:
            textout_ex(interface, font, "Empty", 20,5, makecol(1,1,1), makecol(255,255,255));
            break;
        case 1:
            textout_ex(interface, font, "Wall", 20,15, makecol(1,1,1), makecol(255,255,255));
            break;
        case 2:
            textout_ex(interface, font, "Sand", 20,25, makecol(1,1,1), makecol(255,255,255));
            break;
        case 3:
            textout_ex(interface, font, "Water", 20,35, makecol(1,1,1), makecol(255,255,255));
            break;
        case 4:
            textout_ex(interface, font, "Fire", 20,45, makecol(1,1,1), makecol(255,255,255));
            break;


    }
    triangle(interface, 1, 22 + size*10, 15, 15+ size*10, 15, 30+ size*10, makecol(255,255,0));
    line(interface, 1, 40, 15, 40, makecol(255,255,255));
    line(interface, 1, 21+500, 15, 21+500, makecol(255,255,255));
    
    rectfill(interface,100,500,200,600,makecol(200,200,200));
}

void handle_interface_click(int x, int y)
{
    if(x > 620)
    {
        if( y > 5 && y < 15) currentelement = 0;
        if( y >15 && y < 25) currentelement = 1;
        if( y >25 && y < 35) currentelement = 2;
        if( y >35 && y < 45) currentelement = 3;
        if( y >45 && y < 55) currentelement = 4;
    }
    else
    {
        position_mouse(610,mouse_y);
        size = (y - 21) / 10;
        if(size <= 1) size = 2;
        if(size >= 50) size = 50;
    }
}









