////////////////////////////////////////////////////////////////////////////
// Project:			ProjectZ Game
// Author:			Andrew Deren
// Date Started:	7/01/98
//
// File:			main.cpp - main game file
////////////////////////////////////////////////////////////////////////////

#include "defs.h"

#ifdef COMP_GAME
#include "game.h"
#else
#include "editor.h"
#endif

DATAFILE *datMain;
DATAFILE *datTiles;
DATAFILE *datShip;
DATAFILE *datGameTiles;
DATAFILE *datWeapons;
DATAFILE *datObjects;
DATAFILE *datEdObj;

char textBuffer[256];	// buffer used for misc. stuff
int game = 0;

//////////////////////////////////////////////////////////
// Timer stuff
//////////////////////////////////////////////////////////
int timer = 0;

void incrementTimer(...)
{
	timer++;
}
END_OF_FUNCTION(incrementTimer);
//////////////////////////////////////////////////////////


// print some text on the center of the x, y coordinates
inline void cprintf_centre(int x, int y, char *string)
{
	gotoxy(x - strlen(string)/2, y);
	cputs(string);
}

// print text at x, y location
inline void cprintf_xy(int x, int y, char *string)
{
	gotoxy(x, y);
	cputs(string);
}


void init(void)
{
	int result;			// result of the initalization
	int current = 2;	// current line on screen printed

	// print the title at the top
	clrscr();
	textbackground(BLUE);
	textcolor(WHITE);
	clreol();
	gotoxy(1, 25);
	clreol();
#ifdef COMP_GAME
	cprintf_centre(40, 1, "Starting ProjectZ v0.1");
#else
	cprintf_centre(40, 1, "Starting ProjectZ Editor v0.1 ");
#endif

	cprintf_centre(40, 25, "(C) Ader Software 1998 - Alpha Version 1");

	textbackground(BLACK);

	//initialize allegro
	cprintf_xy(2, current, "initializing allegro............\n");
	result = allegro_init ();				  

	if (result == 0) 
		// successful
		cprintf_xy(34, current, "Ok");
	else {
		// failed for some reason
		cprintf_xy(34, current, "failed");
		exit(-1);
	}
	current++;

	//install keyboard handler
	cprintf_xy (2, current, "installing keyboard handler.....\n");
	result = install_keyboard ();			  
	if (result == 0)
		// success
		cprintf_xy(34, current, "Ok");
	else {
		// failed
		cprintf_xy(34, current, "failed");
		exit(-1);
	}
	current++;

	//install timer
	cprintf_xy(2, current, "installing timer.................\n");
	result = install_timer ();				  
	if (result == 0) 
		// ok
		cprintf_xy(34, current, "Ok");
	else {
		// failed
		cprintf_xy(34, current, "failed");
		exit(-1);
	}
	current++;

	//install mouse handler
	cprintf_xy (2, current, "installing mouse handler........\n");
	result = install_mouse ();	

	if (result != -1) 
		// ok
		cprintf_xy(34, current, "Ok");
	else {
		// failed
		cprintf_xy(34, current, "failed");
		exit(-1);
	}
	current++;

#ifdef COMP_GAME
	// initialize sound and music
	// if it cannot be initialized then there will be no sound and music
	cprintf_xy(2, current, "installing sound drivers........\n");
	result = install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
	if (result == 0) { 
		// ok
		cprintf_xy(34, current++, "Ok");
		gotoxy(5, current++);
		cprintf("%s %s", digi_driver->name, digi_driver->desc);
		gotoxy(5, current);
		cprintf("%s %s", midi_driver->name, midi_driver->desc);
	}
	else {
		// failed
		cprintf_xy(34, current++, "failed");
		exit(-1);
	}
	current++;
#endif

	//load data files
	cprintf_xy(2, current, "loading data files..............\n");
	datMain = load_datafile("datmain.dat");
	datTiles = load_datafile("dattiles.dat");
	datShip = load_datafile("datship.dat");
	datGameTiles = load_datafile("datgamet.dat");
	datWeapons = load_datafile("weapons.dat");
	datObjects = load_datafile("objects.dat");
	datEdObj = load_datafile("edobj.dat");

	if (!datMain) {
		cprintf_xy(34, current, "Failed. (missing datmain.dat)");
		exit(-1);
	}
	if (!datTiles) {
		cprintf_xy(34, current, "Failed. (missing dattiles.dat)");
		exit(-1);
	}
	if (!datShip) {
		cprintf_xy(34, current, "Failed. (missing datship.dat)");
		exit(-1);
	}
	if (!datGameTiles) {
		cprintf_xy(34, current, "Failed. (missing datgamet.dat)");
		exit(-1);
	}
	if (!datObjects) {
		cprintf_xy(34, current, "Failed. (missing objects.dat)");
		exit(-1);
	}
	if (!datEdObj) {
		cprintf_xy(34, current, "Failed. (missing edobj.dat)");
		exit(-1);
	}

	current++;
   


	gotoxy(2, current);
	cprintf("setting graphics mode %dx%dx%d\n", X_RES, Y_RES, COLOR_DEPTH);

	cprintf_xy(2, current+1, "press a key to continue");
	while (!keypressed()) {}

	set_color_depth(COLOR_DEPTH);
	result = set_gfx_mode (GFX_AUTODETECT, X_RES, Y_RES, 0, 0);	

	if (result != 0) {
		// failed to set the graphics mode
		cprintf_xy(36, current++, "failed");
		exit(-1);		
	}
	current++;

	set_palette((PALLETE)datMain[MAIN_PALLETE].dat);

	// lock variables and function 
	LOCK_FUNCTION(incrementTimer);
	LOCK_VARIABLE(timer);

	// timer is incremented every 10 miliseconds
	install_int(incrementTimer, 10);

	// initialize random seed
	srandom((int)time(NULL));

#ifndef COMP_GAME
 	set_default_object_colors (0, 235, 236, 237, 238, 239, 240, 241);
	
	gui_fg_color = makecol8 (0, 0, 0);
	gui_mg_color = makecol8 (192, 192, 192);
	gui_bg_color = makecol8 (255, 255, 255);

	degui_select_color = makecol8(0, 0, 255);
#endif

	set_mouse_sprite((BITMAP*)datMain[BMP_POINTER].dat);

}

int main(int argc, char** argv)
{
	init();

#ifdef COMP_GAME
	startGame();
#else
	startEditor();
#endif

	return 0;
}