////////////////////////////////////////////////////////////////////////////
// Project:			ProjectZ Game
// Author:			Andrew Deren
// Date Started:	7/01/98
//
// File:			defs.h
////////////////////////////////////////////////////////////////////////////

#ifndef __DEFS_H

// comment this line if compiling for the editor
#define COMP_GAME 

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <conio.h>
#include <allegro.h>


#ifndef COMP_GAME
#include <degui.h>
#include "internal.h"
#endif

#include "dattiles.h"
#include "datmain.h"
#include "datship.h"
#include "weapons.h"
#include "objects.h"
#include "edobj.h"

#define X_TILES 18			// number of horizontal tiles
#define Y_TILES 14			// number of vertical tiles
#define MAP_HEIGHT 448		// height of the map
#define MAP_WIDTH 576		// width of the map

#ifdef COMP_GAME
#define X_RES 640			// x resolution
#define Y_RES 480			// y resolution
#else
#define X_RES 800			// x resolution
#define Y_RES 600			// y resolution
#endif

#define COLOR_DEPTH 8		// color depth
#define TILE_SIZE 32		// size of each tile


typedef unsigned char Byte;	// typedef Byte to be unsigned char

extern DATAFILE *datTiles;	// data with tiles for editor 
extern DATAFILE *datGameTiles;	// data with tiles for the game COMPILED sprites
extern DATAFILE *datMain;	// main datafile
extern DATAFILE *datShip;	// ship data
extern DATAFILE *datWeapons;	// weapons graphics and sounds
extern DATAFILE *datObjects;	// objects for the map
extern DATAFILE *datEdObj;		// thumbnail objects for the editor
extern int timer;			// timer for the game

extern char textBuffer[256];	// buffer used for misc. stuff

#define Random(x) (random() % (x))

#endif // __DEFS_H