////////////////////////////////////////////////////////////////////////////
// Project:			ProjectZ Game
// Author:			Andrew Deren
// Date Started:	7/01/98
//
// File:			game.cpp - game objects
////////////////////////////////////////////////////////////////////////////

#include "game.h"

int fps = 0;
int lastFrame = 0;
int frames = 0;

////////////////////////////////////////////////////////////////////////////
// Weapon class
////////////////////////////////////////////////////////////////////////////
const int Weapon1::aroundShipX[AROUND_SHIP_COUNT] = {
	0, 10, 20, 30,
	40, 50, 60,70,
	80, 82, 84,86,
	88, 86, 84, 82,
	80, 70, 60, 50,
	40, 30, 20, 10,
	0, -2, -4, -6,
	-8, -6, -4, -2};

const int Weapon1::aroundShipY[AROUND_SHIP_COUNT] = {
	-8, -10, -12, -14,
	-16, -14, -12, -10,
	-8, -2, 4, 10,
	16, 22, 28, 34,
	40, 42, 44, 46,
	48, 46, 44, 42,
	40, 34, 28, 22,
	16, 10, 4, -2};


// set the values depending on which type of weapon it is
Weapon::Weapon(int maxBulls)
{
	int i;

	change = 0;
	level = 0;
	numBullets = 0;
	maxBullets = maxBulls;

	counter = timer;

	maxSpeed = 1;

	if (maxBullets > 0)
		loc = new Bullet[maxBullets];
	else loc = NULL;

	width = 0;
	height = 0;
}


Weapon::~Weapon()
{
	if (loc)
		delete [] loc;
}


void Weapon::changeLevel(int newLevel) 
{
	if (newLevel < 0 || newLevel > 3) 
		return;
	level = newLevel;
	width = sprite[level]->w;
	height = sprite[level]->h;

}


/////////////////////////////////////////////////////
//////////////////// Weapon1 class //////////////////
/////////////////////////////////////////////////////
Weapon1::Weapon1()
:Weapon(100), counter2(0), numShieldBullets(0)	
{
	sprite[0] = (BITMAP*)datWeapons[WEAPON11_BMP].dat;
	sprite[1] = (BITMAP*)datWeapons[WEAPON11_BMP].dat;
	sprite[2] = (BITMAP*)datWeapons[WEAPON11_BMP].dat;
	sprite[3] = (BITMAP*)datWeapons[WEAPON11_BMP].dat;
	width = sprite[0]->w;
	height = sprite[0]->h;

	maxSpeed = 2;
}

Weapon1::~Weapon1()
{

}

void Weapon1::changeLevel(int newLevel)
{
	Weapon::changeLevel(newLevel);

	// if changing level shield bullets disapear
	numShieldBullets = 0;
}

void Weapon1::draw(BITMAP *bmp, GameMap *game)
{
	int i;
	int xTile;
	int yTile;

	
	// if there are currently no bullets generate one
	if (numBullets == 0) {
		loc[0] = Bullet(game->shipX + game->width, game->shipY + game->height / 2, width, height, 0);
		numBullets = 1;
		
	}
	
	// and also generate shield bullet if level is 3 or up
	if (level >= 2 && numShieldBullets == 0) {
		sLoc[0] = Bullet(game->shipX + aroundShipX[0],
			game->shipY + aroundShipY[0],
			width, height, 0);
		numShieldBullets = 1;
	}
	
	
	// if game requested change of weapon reset all bullets and accept change
	if (change == 1 && numBullets == 1) {
		numBullets = 0;
		numShieldBullets = 0;
		change = 2;
	}
	
	if (timer - counter >= maxSpeed) { // move bullets
		for (i=0; i<numBullets; i++) 
			loc[i].x += 4;
		
		// move shield bullets
		for (i=0; i<numShieldBullets; i++) {
			sLoc[i].l += 1;
			if (sLoc[i].l == AROUND_SHIP_COUNT)
				sLoc[i].l = 0;
			sLoc[i].x = aroundShipX[sLoc[i].l] + game->shipX;
			sLoc[i].y = aroundShipY[sLoc[i].l] + game->shipY;
		}

		// release second shield bullet if level is 4 and first bullet made half the
		// circle around the ship
		if (numShieldBullets == 1 && level == 3 && sLoc[0].l == AROUND_SHIP_COUNT / 2) {
			sLoc[1] = Bullet(game->shipX + aroundShipX[0],
				game->shipY + aroundShipY[0],
				width, height, 0);
			numShieldBullets = 2;
		}

		counter = timer;
		
		// increment counter2
		counter2++;
		
		// release new bullet if it's time for it
		if (counter2 > 20 - level * 5 && change != 1) {
			counter2 = 0;
			
			// release bullets if possible
			if (numBullets < 99) {
				loc[numBullets] = Bullet(game->shipX + game->width, game->shipY + game->height / 2, width, height, 0);
				numBullets++;
			}
		}
	}
	
	// check each bullet for collision with tiles or going out of map
	for (i=0; i<numBullets; i++) {
		if (loc[i].x >= X_TILES * TILE_SIZE + game->tilePart) { 
			// if bullet went out of map move last bullet to its position
			if (i != numBullets-1)
				loc[i] = loc[numBullets-1];
			numBullets--;
		}
		
		// check if did not go onto the tile
		xTile = (loc[i].x + game->tilePart + loc[i].w) / TILE_SIZE + game->currentX;
		yTile = (loc[i].y) / TILE_SIZE;
		
		if (game->line[xTile].tile[yTile] != 0) {
			if (i != numBullets - 1)
				loc[i] = loc[numBullets - 1];
			numBullets--;
		}
	}
	
	if (bmp) {
		// now draw the bullets
		for (i=0; i<numBullets; i++)
			draw_sprite(bmp, sprite[0], loc[i].x+game->tilePart, loc[i].y); 
		
		// draw shield bullets
		for (i=0; i<numShieldBullets;i++)
			draw_sprite(bmp, sprite[0], sLoc[i].x+game->tilePart, sLoc[i].y); 
	}
	
}
/////////////////////////////////////////////////////
//////////////////// Weapon2 class //////////////////
/////////////////////////////////////////////////////
Weapon2::Weapon2()
:Weapon(8)		// 1 bullet in each direction
{
	sprite[0] = (BITMAP*)datWeapons[WEAPON21_BMP].dat;
	sprite[1] = (BITMAP*)datWeapons[WEAPON21_BMP].dat;
	sprite[2] = (BITMAP*)datWeapons[WEAPON21_BMP].dat;
	sprite[3] = (BITMAP*)datWeapons[WEAPON21_BMP].dat;

	width = sprite[0]->w;
	height = sprite[0]->h;

	maxSpeed = 1;

}

Weapon2::~Weapon2()
{

}

void Weapon2::draw(BITMAP *bmp, GameMap *game)
{
	int i, j;
	int xTile;
	int yTile;

	// generate bullets if there are 0
	if (numBullets == 0) {
		// always generate right and left
		loc[D_RIGHT] = Bullet(game->shipX + game->width, game->shipY + game->height / 2, width, height, level);
		loc[D_LEFT] = Bullet(game->shipX, game->shipY + game->height / 2, width, height, level);

		numBullets = 2;

		if (level >= 1) {
			loc[D_UP] = Bullet(game->shipX + game->width/2, game->shipY, width, height, level);
			loc[D_DOWN] = Bullet(game->shipX + game->width/2, game->shipY + game->height, width, height, level);
			numBullets += 2;
		}
		if (level >= 2) {
			loc[D_UP_RIGHT] = Bullet(game->shipX + game->width/2 + 10, game->shipY, width, height, level);
			loc[D_DOWN_RIGHT] = Bullet(game->shipX + game->width/2+ 10, game->shipY + game->height, width, height, level);
			numBullets += 2;
		}
		if (level >= 3) {
			loc[D_UP_LEFT] = Bullet(game->shipX + game->width/2 - 10, game->shipY, width, height, level);
			loc[D_DOWN_LEFT] = Bullet(game->shipX + game->width/2 - 10, game->shipY + game->height, width, height, level);
			numBullets += 2;
		}

		if (change == 1)
			change = 2;
	}

	if (timer - counter >= maxSpeed) { // move bullets
		// always move right and left
		if (loc[D_RIGHT].l != -1)
			loc[D_RIGHT].x += 4;
		if (loc[D_LEFT].l != -1)
			loc[D_LEFT].x -= 4;

		if (level >= 1) {
			if (loc[D_UP].l != -1)
				loc[D_UP].y -= 4;
			if (loc[D_DOWN].l != -1)
				loc[D_DOWN].y += 4;
		}

		if (level >= 2) {
			if (loc[D_UP_RIGHT].l != -1) {
				loc[D_UP_RIGHT].x += 4;
				loc[D_UP_RIGHT].y -= 4;
			}
			if (loc[D_DOWN_RIGHT].l != -1) {
				loc[D_DOWN_RIGHT].x += 4;
				loc[D_DOWN_RIGHT].y += 4;
			}
		}

		if (level >= 3) {
			if (loc[D_UP_LEFT].l != -1) {
				loc[D_UP_LEFT].x -= 4;
				loc[D_UP_LEFT].y -= 4;
			}
			if (loc[D_DOWN_LEFT].l != -1) {
				loc[D_DOWN_LEFT].x -= 4;
				loc[D_DOWN_LEFT].y += 4;
			}
		}
		
		counter = timer;		
	}
	
	// now check if bullets did not go out of map, or if did not collision 
	// with tiles did not occur
	for (i=0; i<8; i++) {
		if (loc[i].l == -1)
			continue;
		if (loc[i].x >= X_TILES * TILE_SIZE + game->tilePart ||	loc[i].x < game->tilePart ||
			loc[i].y < 0 ||	loc[i].y >= Y_TILES * TILE_SIZE) { 
			// if bullet went out of map move last bullet to its position
			loc[i].l = -1;
			numBullets--;
		}
		
		// check if did not go onto the tile
		xTile = (loc[i].x + game->tilePart + loc[i].w) / TILE_SIZE + game->currentX;
		yTile = (loc[i].y) / TILE_SIZE;
		
		if (game->line[xTile].tile[yTile] != 0) {
			loc[i].l = -1;
			numBullets--;
		}
	}

	// now draw the bullets
	if (bmp) 
		for (i=0, numBullets = 0; i<8; i++) 
			if (loc[i].l != -1) {
				numBullets++;
				draw_sprite(bmp, sprite[0], loc[i].x+game->tilePart, loc[i].y); 
			}
}

/////////////////////////////////////////////////////
//////////////////// Weapon3 class //////////////////
/////////////////////////////////////////////////////
Weapon3::Weapon3()
:Weapon(2)
{
	sprite[0] = (BITMAP*)datWeapons[WEAPON31_BMP].dat;
	sprite[1] = (BITMAP*)datWeapons[WEAPON32_BMP].dat;
	sprite[2] = (BITMAP*)datWeapons[WEAPON33_BMP].dat;
	sprite[3] = (BITMAP*)datWeapons[WEAPON34_BMP].dat;	

	width = sprite[0]->w;
	height = sprite[0]->h;
}

Weapon3::~Weapon3()
{

}

void Weapon3::draw(BITMAP *bmp, GameMap *game)
{
	int i;
	int xTile;
	int yTile;

	if (numBullets == 0) {	// if there is no bullet yet, generate one
		loc[0] = Bullet(game->shipX + game->width, game->shipY + game->height / 2, width, height, level);
		numBullets = 1;
	}
	
	
	if (timer - counter >= maxSpeed) { // if it's time to move the bullet move it
		loc[0].x += 4;					// this weapon only moves in the x direction
		counter = timer;
	}
	
	if (loc[0].x >= X_TILES * TILE_SIZE + game->tilePart) { // if bullet went out of map generate new one
		loc[0] = Bullet(game->shipX + game->width, game->shipY + game->height / 2, width, height, level);
		if (change == 1) {
			change = 2;	// if bullet died user can change the weapon
			numBullets = 0;
		}
	}
	
	
	if (bmp)
		// now draw the weapon
		draw_sprite(bmp, sprite[loc[0].l], loc[0].x+game->tilePart, loc[0].y); 
	
}

/////////////////////////////////////////////////////
//////////////////// Weapon4 class //////////////////
/////////////////////////////////////////////////////
Weapon4::Weapon4()
:Weapon(6)	// 6 bullets when using level 4
{
	sprite[0] = (BITMAP*)datWeapons[WEAPON11_BMP].dat;
	sprite[1] = (BITMAP*)datWeapons[WEAPON11_BMP].dat;
	sprite[2] = (BITMAP*)datWeapons[WEAPON11_BMP].dat;
	sprite[3] = (BITMAP*)datWeapons[WEAPON11_BMP].dat;	

	width = sprite[0]->w;
	height = sprite[0]->h;
}

Weapon4::~Weapon4()
{

}


void Weapon4::draw(BITMAP *bmp, GameMap *game)
{
	int i;
	int xTile;
	int yTile;
	int active;

	if (numBullets == 0) {	// if there are no bullets yet, generate ones
		numBullets = level+3;
		if (change == 1) {
			change = 2;
			numBullets = 0;
		}

		for (i=0; i<numBullets; i++) 
			loc[i] = Bullet(game->shipX + game->width, game->shipY + game->height/2 - ((numBullets*(height+3))/2)+(i*(height+3)), width, height, level);
	}
	
	
	if (timer - counter >= maxSpeed) { // if it's time to move the bullet move it
		for (i=0; i<numBullets; i++) 
			loc[i].x += 4;					// this weapon only moves in the x direction
		counter = timer;
	}
	
	// if bullet went out of map, make that bullet inactive by makeing it's .l -1
	for (i=0; i<numBullets; i++) {
		if (loc[i].l == -1)
			continue;

		if (loc[i].x >= X_TILES * TILE_SIZE + game->tilePart) 
				loc[i].l =  -1;
	}

	
	// check if bullets did not go onto the tile
	for (i=0, active=0; i<numBullets; i++) {
		if (loc[i].l == -1)
			continue;
		xTile = (loc[i].x + game->tilePart + loc[i].w) / TILE_SIZE + game->currentX;
		yTile = (loc[i].y) / TILE_SIZE;
	
		if (game->line[xTile].tile[yTile] != 0) 
			loc[i].l = -1;
		else
			active++;
	}
	
	// if all bullets disapeared
	if (active == 0) {
		numBullets = level+3;
		// if game requested end of weapon, grant the request
		if (change == 1) {
			change = 2;
			numBullets = 0;
		}
		else {
			for (i=0; i<numBullets; i++) {
				loc[i] = Bullet(game->shipX + game->width, game->shipY + game->height/2 - ((numBullets*(height+3))/2)+(i*(height+3)), width, height, level);
			}
		}
	}


	// now draw the bullets
	if (bmp) 
		for (i=0; i<numBullets; i++) 
			if (loc[i].l != -1)
				draw_sprite(bmp, sprite[loc[i].l], loc[i].x+game->tilePart, loc[i].y); 
	
}
/////////////////////////////////////////////////////
/////////////////// GameMap class ///////////////////
/////////////////////////////////////////////////////
GameMap::GameMap()
:shipX(0), shipY(0), speedX(0), speedY(0), power(0),
Map(), stars1(80), stars2(50), stars3(20),
weapon1(), weapon2(), weapon3(), weapon4(), 
currentWeapon(&weapon1), change(0), blitCounter(0),
currentObject(0)
{
	bmp = create_bitmap(TILE_SIZE*(X_TILES+1), TILE_SIZE*Y_TILES);

	width = 80;
	height = 32;

	stars1.speed = 3;
	stars2.speed = 6;
	stars3.speed = 9;

	stars1.color = makecol(255, 255, 255);
	stars2.color = makecol(180, 180, 180);
	stars3.color = makecol(100, 100, 100);
}

GameMap::~GameMap()
{
	if (bmp)
		destroy_bitmap(bmp);
}


void GameMap::draw(void)
{
	if (change > 0) { // user want to change the weapon
		if (currentWeapon->change == 2) { // current weapon is finished
			currentWeapon->change = 0;
			switch (change) {
			case 1: currentWeapon = &weapon1;break;
			case 2: currentWeapon = &weapon2;break;
			case 3: currentWeapon = &weapon3;break;
			case 4: currentWeapon = &weapon4;break;
			}
			change = 0;
		}
	}


	//if (timer - blitCounter > 2) { // keep constant 40 frames per second 
		clear_to_color(bmp, 1);

		// draw the starfields
		stars3.draw(bmp, tilePart);
		stars2.draw(bmp, tilePart);
		stars1.draw(bmp, tilePart);

		int i, j;
		int tile;
		for (i=0; i<X_TILES+1; i++) 
			for (j=0; j<Y_TILES; j++) {
			//textprintf(bmp, font, i*TILE_SIZE, j*TILE_SIZE, 15, "%d", line[currentX+i].tile[j]);
				tile = line[currentX+i].tile[j];
				if (tile)
					draw_compiled_sprite(bmp, (COMPILED_SPRITE*)datGameTiles[tile].dat, i*TILE_SIZE, j*TILE_SIZE);
			}

		draw_sprite(bmp, (BITMAP*)datShip[SHIP1].dat, shipX+tilePart, shipY);

		// draw the bullets
		currentWeapon->draw(bmp, this);

		// now blit it to screen
		//vsync();
		blit(bmp, screen, tilePart, 0, 0, 0, X_TILES*TILE_SIZE, Y_TILES*TILE_SIZE);

		blitCounter = timer;
		frames++;
	/*}
	else {
		// if it's not time to draw just process the bullets
		currentWeapon->draw(NULL, this);
	}*/

	textprintf(screen, font, 580, 0, 15, "%2d", fps);
	textprintf(screen, font, 580, 10, 15, "%03d", currentX);
	textprintf(screen, font, 580, 20, 15, "%03d", sizeX);
	textprintf(screen, font, 580, 30, 15, "%03d", tilePart);
	textprintf(screen, font, 580, 40, 15, "%d", currentWeapon->level);

	textprintf(screen, font, 10, 452, 15, "(C) 1998 Ader Software - Project Z Alpha Version.");
	textprintf(screen, font, 10, 465, 15, "F1 - F4: Change weapon.    1 - 4: Change weapon level.");
}

// check top of the ship if it did not go on tiles
void GameMap::checkTop(void)
{
	// check for collison at 3 different points of the ship
	int xtile, ytile;

	// top left corner
	xtile = (shipX + tilePart) / TILE_SIZE + currentX;
	ytile = shipY / TILE_SIZE;

	if (line[xtile].tile[ytile] != 0)
		shipY = (ytile+1)*TILE_SIZE;

	// middle top
	xtile = (shipX + tilePart + 16) / TILE_SIZE + currentX;
	ytile = shipY / TILE_SIZE;

	if (line[xtile].tile[ytile] != 0)
		shipY = (ytile+1)*TILE_SIZE;

	// and top right
	xtile = (shipX + tilePart + width - 1) / TILE_SIZE + currentX;
	ytile = (shipY + 16) / TILE_SIZE;

	if (line[xtile].tile[ytile] != 0)
		shipY = (ytile+1)*TILE_SIZE - 16;

}

void GameMap::checkBottom(void)
{
	// check at 4 different points
	// x, x+32, x+64 and x+80
	int xtile, ytile;
	xtile = (shipX + tilePart) / TILE_SIZE + currentX;
	ytile = (shipY + height) / TILE_SIZE;
	if (line[xtile].tile[ytile] != 0)
		shipY = (ytile)*TILE_SIZE-height;

	xtile = (shipX + tilePart + 32) / TILE_SIZE + currentX;
	ytile = (shipY + height) / TILE_SIZE;
	if (line[xtile].tile[ytile] != 0)
		shipY = (ytile)*TILE_SIZE-height;

	xtile = (shipX + tilePart + 64) / TILE_SIZE + currentX;
	ytile = (shipY + height) / TILE_SIZE;
	if (line[xtile].tile[ytile] != 0)
		shipY = (ytile)*TILE_SIZE-height;

	xtile = (shipX + tilePart + width - 1) / TILE_SIZE + currentX;
	ytile = (shipY + height) / TILE_SIZE;
	if (line[xtile].tile[ytile] != 0)
		shipY = (ytile)*TILE_SIZE-height;

}

void GameMap::checkFront(void)
{
	// check at 3 different points

	int xtile, ytile;
	xtile = (shipX + 16 + tilePart) / TILE_SIZE + currentX;
	ytile = shipY / TILE_SIZE;
	if (line[xtile].tile[ytile] != 0)
		shipX = ((xtile-currentX)*TILE_SIZE) - tilePart - 16;

	xtile = (shipX + width + tilePart) / TILE_SIZE + currentX;
	ytile = (shipY + 16) / TILE_SIZE;
	if (line[xtile].tile[ytile] != 0)
		shipX = ((xtile-currentX)*TILE_SIZE) - tilePart - width;

	xtile = (shipX + width + tilePart) / TILE_SIZE + currentX;
	ytile = (shipY + height - 1) / TILE_SIZE;
	if (line[xtile].tile[ytile] != 0)
		shipX = ((xtile-currentX)*TILE_SIZE) - tilePart - width;

}


void GameMap::checkBack(void)
{
	// check at 2 different points

	int xtile, ytile;
	xtile = (shipX + tilePart) / TILE_SIZE + currentX;
	ytile = shipY / TILE_SIZE;
	if (line[xtile].tile[ytile] != 0)
		shipX = ((xtile-currentX+1)*TILE_SIZE) - tilePart;

	xtile = (shipX + tilePart) / TILE_SIZE + currentX;
	ytile = (shipY + height - 1) / TILE_SIZE;
	if (line[xtile].tile[ytile] != 0)
		shipX = ((xtile-currentX+1)*TILE_SIZE-tilePart);

}

void GameMap::moveShip(int xdir, int ydir)
{
	shipX += xdir;
	shipY += ydir;

	if (shipX < 0)
		shipX = 0;
	else if (shipX + width > X_TILES*TILE_SIZE)
		shipX = X_TILES * TILE_SIZE - width;
	
	if (shipY < 0)
		shipY = 0;
	else if (shipY + height > Y_TILES * TILE_SIZE)
		shipY = Y_TILES * TILE_SIZE - height;

	if (xdir > 0)
		checkFront();
	else if (xdir < 0)
		checkBack();
	if (ydir > 0)
		checkBottom();
	else if (ydir < 0)
		checkTop();
}

//////////////////////////////////////////////////////

///////////////////// Game class ////////////////////
Game::Game()
:lastScroll(0), lastMove(0)
{

}

void Game::playGame()
{
	if (!map.loadMap("gmap1.map")) {
		allegro_exit();
		printf("Error loading map: %s", textBuffer);
		exit(-1);
	}

	clear(screen);

	while (1) {
		if (timer - lastScroll > SCROLL_SPEED) {
			map.scroll();
			lastScroll = timer;
		}
		if (timer - lastFrame > 100) {
			fps = frames;
			frames = 0;
			lastFrame = timer;
		}
		if (keypressed()) {
			if (key[KEY_F1]) // change the weapons
				map.changeWeapon(1);
			else if (key[KEY_F2])
				map.changeWeapon(2);
			else if (key[KEY_F3])
				map.changeWeapon(3);
			else if (key[KEY_F4])
				map.changeWeapon(4);
			else if (key[KEY_1])
				map.currentWeapon->changeLevel(0);
			else if (key[KEY_2])
				map.currentWeapon->changeLevel(1);
			else if (key[KEY_3])
				map.currentWeapon->changeLevel(2);
			else if (key[KEY_4])
				map.currentWeapon->changeLevel(3);

			if (timer - lastMove > 3) {
				if (key[KEY_ESC])
					return;
				if (key[KEY_UP]) {
					map.moveShip(0, -4);
				}
				if (key[KEY_DOWN]) {
					map.moveShip(0, 4);
				}
				if (key[KEY_RIGHT]) {
					map.moveShip(4, 0);
				}
				if (key[KEY_LEFT]) {
					map.moveShip(-4, 0);
				}	
				lastMove = timer;
			}
		}
		map.draw();
	}
}


// display a title screen
void doTitleScreen(void)
{
	fade_out(64);
	blit((BITMAP*)datMain[BMP_TITLE].dat, screen, 0, 0, 0, 0, 640, 480);
	fade_in((RGB*)datMain[PAL_TITLE].dat, 1);
	clear_keybuf();
	while (1) {
		if (keypressed()) 
			break;
		if (mouse_b & 1)
			break;
	}
	fade_out(2);
	set_palette((PALLETE)datMain[MAIN_PALLETE].dat);
}

void startGame()
{
	doTitleScreen();

	Game game;
	game.playGame();
	exit(0);
}