////////////////////////////////////////////////////////////////////////////
// Project:			ProjectZ Game
// Author:			Andrew Deren
// Date Started:	7/01/98
//
// File:			agui.cpp - gui objects 
////////////////////////////////////////////////////////////////////////////

#include "agui.h"

//////////////////////////////////////////////////////////////////////////
// class h_select_bitmap_object
//		helper class for select_bitmap_object
//		used as a dialog object when poping up the 
//		list of graphics
//////////////////////////////////////////////////////////////////////////
void h_select_bitmap_object::msg_draw(void)
{
	panel_raised_object::msg_draw();

	if (!_selectObject)
		return;

	int i, cx, cy;
	cy = y()+1;
	cx = x()+1;

	DATAFILE *data = _selectObject->getDatafile();
	if (!data) return;

	for (i = 0; i < _selectObject->getNumGraphics(); i++) {
		draw_sprite(screen, (BITMAP*)data[i+_selectObject->getStart()].dat, cx, cy);
		rect(screen, cx, cy, cx+TILE_SIZE-1, cy+TILE_SIZE-1, newColors.fore());

		if (i == _current)
			rect(screen, cx, cy, cx+TILE_SIZE-1, cy+TILE_SIZE-1, newColors.select());

		cx += TILE_SIZE;
		if (cx >= x2()-2) {
			cx = x() + 1;
			cy += TILE_SIZE;
		}

	} 

	// get the pointer to the BMP that the mouse is currently selecting
	if (_current >= 0 && _current < _selectObject->getNumGraphics()) {
		BITMAP *cBMP = (BITMAP*)data[_current+_selectObject->getStart()].dat;

		textprintf(screen, font, x()+1, y2()-12, newColors.select(), "Image: %d (%dx%d)", _current, cBMP->w, cBMP->h);
	}

	_redraw = false;
}


void h_select_bitmap_object::msg_click(void)
{
	if (!_selectObject)
		return;

	int tx, ty;

	while (mouse_b) {
		// check which tile is selected
		if (!hasMouse())
			continue;
		
		tx = (mouse_x - x()) / TILE_SIZE;
		ty = (mouse_y - y()) / TILE_SIZE;

		_oldCurrent = ty * _selectObject->getNumColumns() + tx;

		if (_oldCurrent != _current) {
			if (_oldCurrent >= 0 && _oldCurrent < _selectObject->getNumGraphics()) {
				_current = _oldCurrent;
				redraw();
			 }
		}

		parent()->dialog_message(MSG_IDLE, 0);
	}
	

	parent()->close();
}

// on start set the dimensions to match the values
// from _selectObject
void h_select_bitmap_object::msg_start(void)
{
	if (!_selectObject)
		return;

	set_w(TILE_SIZE * _selectObject->getNumColumns() + 2);

	// offset is the height of the object, if the columns are filled up
	// add 1 so that it's drawn too.
	int offset = _selectObject->getNumGraphics() % _selectObject->getNumColumns();
	if (offset == 0)
		offset++;

	// 12 is added for the status bar at the bottom
	set_h(TILE_SIZE * offset + 2 + 12);

	_current = _selectObject->getCurrent() - _selectObject->getStart();

	if (x2() > SCREEN_W)
		set_x(SCREEN_W - w() - 2);
	if (y2() > SCREEN_H)
		set_y(SCREEN_H - h() - 2);
}


//////////////////////////////////////////////////////////////////////////
// class select_bitmap_object
//		When clicked on executes a callback and
//		when clicked in the corner or right clicked
//		a dialog with bitmaps to select from popups
//		and puts selected bitmap as the main one
//////////////////////////////////////////////////////////////////////////
FONT* select_bitmap_object::_font = font;

// constructor takes a pointer to datafile
// start is the first bitmap to display and numGraphics is
// number of images used from datafile
select_bitmap_object::select_bitmap_object(const char* name, DATAFILE *data, int start, int numGraphics)
:cbClicked(NULL), cbChanged(NULL), _datafile(data), _start(start), 
 _numGraphics(numGraphics), _current(start), _numCols(14)
{
	strcpy(_name, name);
}

select_bitmap_object::select_bitmap_object(void)
:cbClicked(NULL), cbChanged(NULL), _datafile(NULL), _start(0), 
 _numGraphics(0), _current(0), _numCols(5)
{
	_name[0] = '\0';
}

void select_bitmap_object::msg_draw(void)
{
	if (selected()) {
		draw_3d_frame(screen, x(), y(), x2(), y2(), degui_back_color,
			degui_dark_shad_color, degui_light_shad_color);
		if (_datafile)
			stretch_sprite(screen, (BITMAP*)_datafile[_current].dat, x()+1, y2()-w()+1, w()-1, w()-1);
		text_mode(-1);
		textout(screen, _font, _name, x()+1, y()+1, degui_fore_color);

	}
	else {
		if (hasMouse()) {
			draw_3d_frame(screen, x(), y(), x2(), y2(), degui_light_shad_color,
				degui_back_color, degui_dark_shad_color);
			if (_datafile)
				stretch_sprite(screen, (BITMAP*)_datafile[_current].dat, x()+1, y2()-w()+1, w()-1, w()-1);
			text_mode(-1);
			rectfill(screen, x()+1, y()+1, x2()-1, y2()-w()-1, degui_select_color);
			textout(screen, _font, _name, x()+1, y()+1, degui_back_color);
		}
		else {
			rectfill(screen, x(), y(), x2(), y2(), degui_back_color);
			if (_datafile)
				stretch_sprite(screen, (BITMAP*)_datafile[_current].dat, x(), y2()-w()+1, w(), w());
			text_mode(-1);
			textout(screen, _font, _name, x()+1, y()+1, degui_fore_color);
		}
	}
}

void select_bitmap_object::msg_click(void)
{
	if (!_datafile) return;

	if (mouse_b & 1) {

		if (selected())
			return;

		while (mouse_b) {}

		parent()->dialog_message(MSG_RADIO, _group);
		select();
		redraw();
	}
	else {
		while (mouse_b) {}

		dialog tDialog;
		close_dialog_object obj;
		h_select_bitmap_object sel(this);

		
		tDialog.add(obj, 0, 0, SCREEN_W, SCREEN_H);
		tDialog.add(sel, x2(), y(), 0, 0);

		tDialog.popup();

		setCurrent(sel.getCurrent() + getStart());

		parent()->dialog_message(MSG_RADIO, _group);
		select();
		redraw();	
	}

	redraw();
}

void select_bitmap_object::msg_gotmouse(void)
{
	redraw();
}


void select_bitmap_object::msg_lostmouse(void)
{
	redraw();
}

void select_bitmap_object::msg_radio(int g)
{
	if (g == _group)
		deselect();
	redraw();
}



// degui_colors_object
void degui_colors_object::msg_draw(void)
{
	text_mode(-1);
	textout(screen, font, "Fore :", x(), y(), degui_fore_color);
	textout(screen, font, "Mid  :", x(), y()+10, degui_fore_color);
	textout(screen, font, "Back :", x(), y()+20, degui_fore_color);
	textout(screen, font, "Light:", x(), y()+30, degui_fore_color);
	textout(screen, font, "Dark :", x(), y()+40, degui_fore_color);
	textout(screen, font, "Sel  :", x(), y()+50, degui_fore_color);
	textout(screen, font, "Desel:", x(), y()+60, degui_fore_color);
	textout(screen, font, "Disab:", x(), y()+70, degui_fore_color);

	int off = text_length(font, "wwwww");
	rectfill(screen, x()+off, y(), x()+off+10, y()+10, degui_fore_color);
	rectfill(screen, x()+off, y()+10, x()+off+10, y()+20, degui_mid_color);
	rectfill(screen, x()+off, y()+20, x()+off+10, y()+30, degui_back_color);
	rectfill(screen, x()+off, y()+30, x()+off+10, y()+40, degui_light_shad_color);
	rectfill(screen, x()+off, y()+40, x()+off+10, y()+50, degui_dark_shad_color);
	rectfill(screen, x()+off, y()+50, x()+off+10, y()+60, degui_select_color);
	rectfill(screen, x()+off, y()+60, x()+off+10, y()+70, degui_deselect_color);
	rectfill(screen, x()+off, y()+70, x()+off+10, y()+80, degui_disable_color);
}
