////////////////////////////////////////////////////////////////////////////
// Project:			ProjectZ Game
// Author:			Andrew Deren
// Date Started:	7/01/98
//
// File:			map.h
////////////////////////////////////////////////////////////////////////////

#ifndef __MAP_H
#define __MAP_H

#include "defs.h"

#ifndef COMP_GAME
#include "agui.h"
#endif

// trigger class for handling triggers for enemy
// when the ship passes by, it activates a trigger
// which activates enemy
class Trigger;

// enemy is a sequance of enemy ships
class Enemy;

extern Byte unknown;	// returned by operator() when invalid range is picked

//////////////////////////////////////////////////////////////////////
// simple object on the map
//////////////////////////////////////////////////////////////////////
class MapObject {
public:
	MapObject() : x(0), y(0), size(0), level(0), type(0){}
	MapObject(int theX, int theY, int theSize, int theLevel, int theType) 
		:x(theX), y(theY), size(theSize), level(theLevel), type(theType) {}

	int x, y;	// location of the object
	int size;	// size of the object (1 to 4)
	int level;	// level of the object (1 to 3, which starfield)
	int type;	// type of object
};

//////////////////////////////////////////////////////////////////////
// struct MapLine is one vertical line on the map
//////////////////////////////////////////////////////////////////////
class MapLine {
public:
	MapLine() : trigger(NULL), enemy(NULL) {
		for (int i=0; i<Y_TILES; i++)
			tile[i] = 0;
	}
	inline MapLine(MapLine& copy) { operator=(copy);}

	Byte tile[Y_TILES];
	
	Trigger *trigger;
	Enemy *enemy;

	inline void operator=(MapLine& copy) {
		memcpy(tile, copy.tile, sizeof(Byte)*Y_TILES);
		trigger = NULL;
		enemy = NULL;
	}
	inline Byte& operator[](int which) { 
		if (which >= 0 && which < Y_TILES)
			return tile[which];
		else return unknown;
	}
};

//////////////////////////////////////////////////////////////////////
// class Map is the map that is drawn
//////////////////////////////////////////////////////////////////////
#define MAX_OBJECTS 250		// initial number of objects

class Map  
{
public:
	inline Map() :currentX(0), sizeX(0), line(NULL), numObjects(0),
		maxObjects(MAX_OBJECTS) {
		objects = new MapObject[maxObjects];
	}
	virtual ~Map() { 
		if (line) delete [] line;
		if (objects) delete [] objects;
	}

	// set sizeX to size and allocate space for it
	inline bool setSize(int width) {
		// map width has to be atleast width of the screen
		if (width < X_TILES)
			return false;
		
		sizeX = width;
		if (line)
			delete [] line;

		line = new MapLine[sizeX];

		return true;
	}

	inline Byte& operator()(int x, int y) { 
		if (x < 0 || x >= sizeX)
			return unknown;
		if (y < 0 || y >= Y_TILES)
			return unknown;
		return line[x].tile[y];
	}

	inline int getSize(void) const { return sizeX;}
	inline int getCurrentX(void) const { return currentX;}
	inline void setCurrentX(int current) { currentX = current;}

	virtual bool loadMap(char* fileName);

protected:
	MapLine* line;	// the actual map values, a dynamic array of MapLine's

	int currentX;	// current line visible at the left
	int sizeX;		// number of lines in a map

	const static char FILE_ID[5];	// id of the map saved to file
	const static int FILE_VERSION;	// version of the map

	int numObjects;			// number of objects
	int maxObjects;			// space allocated for the objects array
	MapObject* objects;		// a dynamic array of objects
};

#endif // __MAP_H
