////////////////////////////////////////////////////////////////////////////
// Project:			ProjectZ Game
// Author:			Andrew Deren
// Date Started:	7/01/98
//
// File:			map.cpp - map objects
////////////////////////////////////////////////////////////////////////////


#include "Map.h"

Byte unknown = 1;	// returned by operator() when invalid range is picked

const char Map::FILE_ID[5] = "ZMAP";	// id of the map saved to file
const int Map::FILE_VERSION = 10;		// version of the map

////////// load a map ///////////////////////////////
bool Map::loadMap(char* fileName)
{
	FILE *file = fopen(fileName, "rb");
	if (!file) {
#ifndef COMP_GAME
		debug.write("Error opening file: %s", fileName);
#else
		sprintf(textBuffer, "Error opening file: %s", fileName);
#endif
		return false;
	}

	int checkVersion;	// used to read the verion
	char checkID[5];	// used to check the file id
	int width;			// size of map

	// write id and version of the map
	fread(checkID, sizeof(char), 5, file);
	fread(&checkVersion, sizeof(int), 1, file);

	if (strcmp(checkID, FILE_ID) != 0 || checkVersion != FILE_VERSION) {
#ifndef COMP_GAME
		debug.write("Invalid map id or version.");
#else
		sprintf(textBuffer, "Invalid map id or version.");
#endif
		return false;
	}
	
	// now write map data
	fread(&width, sizeof(int), 1, file);	// number of lines

	if (!setSize(width)) {
#ifndef COMP_GAME
		debug.write("Invalid map size.");
#else
		sprintf(textBuffer, "Invalid map size.");
#endif
		return false;
	}

	// write line by line
	int x, y;
	for (x = 0; x < sizeX; x++) 
		fread(line[x].tile, sizeof(char), Y_TILES, file);


	// save objects (planets)
	fread(&numObjects, sizeof(int), 1, file);
	if (numObjects >= maxObjects) {
		delete [] objects;
		maxObjects = numObjects;
		objects = new MapObject[maxObjects];
	}
	fread(objects, sizeof(MapObject), numObjects, file);
	fclose(file);

	file = fopen("temp.map", "wt");
	fprintf(file, "width: %d, height: %d\n", sizeX, Y_TILES);
	for (x = 0; x < sizeX; x++) {
		for (y = 0; y < Y_TILES; y++)
			fprintf(file, "%3d ", line[x].tile[y]);
		fprintf(file, "\n");
	}
	fclose(file);


	return true;
}
