//----------------------------------------------------------------------------
//
// DEGUI - C++ Objects for Allegro's gui 1.23 beta
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#ifndef DEGUI_INTERNAL
#define DEGUI_INTERNAL

//----------------------------------------------------------------------------
#include "allegro.h"

//----------------------------------------------------------------------------
// These file have C linkage so that I can use modified C objects
#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------------------
// Helper function for drawing listbox. This is global so that I can easily change
// Allegro file select dialogs etc to draw the new style objects by directing MSG_DRAW to this routine...
void _draw_list_object (char*(*list_grabber_proc)(int,int*),
                        int *listsize,
                        const int offset,
                        const int x, const int y, const int w, const int h,
                        const int index,
                        const int disabled, const int has_focus,
                        const int fore,
                        const int select, const int deselect,
                        const int disable,
                        const int light_shad, const int dark_shad);

//----------------------------------------------------------------------------
// Helper function for drawing listbox. This is global so that I can easily change
// Allegro file select dialogs etc to draw the new style objects by directing MSG_DRAW to this routine...
void _draw_button_object (const char* text,
                          const int selected,
                          const int x, const int y, const int w, const int h,
                          const int disabled, const int has_focus,
                          const int fore,
                          const int select, const int deselect,
                          const int disable,
                          const int light_shad, const int dark_shad);

//----------------------------------------------------------------------------
// Draw the checkbox in a degui style
void _draw_checkbox_object (const char *text,
                            const int selected,
                            const int x, const int y, const int h,
                            const int disabled, const int has_focus,
                            const int fore, const int back,
                            const int select, const int deselect,
                            const int disable,
                            const int light_shad, const int dark_shad);

//----------------------------------------------------------------------------
// Draw the radio button in a degui style
void _draw_radio_button_object (const char *text,
                                const int square,
                                const int x, const int y, const int h,
                                const int selected,
                                const int disabled, const int has_focus,
                                const int fore, const int back,
                                const int select, const int deselect,
                                const int disable,
                                const int light_shad, const int dark_shad);
//----------------------------------------------------------------------------
// Helper function for drawing edittextbox. This is global so that I can easily change
// Allegro file select dialogs etc to draw the new style objects by directing MSG_DRAW to this routine...
int _draw_edittext_object (const char *text,
                           const int cursorpos,
                           const int offsetpos,
                           const int x, const int y, const int w, const int h,
                           const int disabled, const int has_focus,
                           const int fore,
                           const int deselect,
                           const int disable,
                           const int light_shad, const int dark_shad);
//----------------------------------------------------------------------------
// Helper function for drawing scrollbars
void _draw_scrollbar (const int x, const int y, const int w, const int h,
                      const int listsize,
                      const int offset,
                      const int height,
                      const int has_focus,
                      const int fore,
                      const int mid, const int back,
                      const int deselect,
                      const int light_shad, const int dark_shad);
//----------------------------------------------------------------------------
// Helper function for drawing progress bars
void _draw_progressbar (const int x, const int y, const int w, const int h,
                        const int drawtext,
                        const float progress,
                        const float scale,
                        const int disabled,
                        const int fore,
                        const int select,
                        const int deselect,
                        const int disable,
                        const int light_shad, const int dark_shad);
//----------------------------------------------------------------------------
// Helper function for drawing hidden lists
void _draw_hidden_list_marker (const int x, const int y, const int w, const int h,
                               const int disabled,
                               const int has_focus,
                               const int fore,
                               const int mid,
                               const int deselect,
                               const int disable,
                               const int light_shad, const int dark_shad);
//----------------------------------------------------------------------------
// A support structure for the menu object
//----------------------------------------------------------------------------
typedef struct MENU_INFO      /* information about a popup menu */
   {
   MENU *menu;                /* the menu itself */
   struct MENU_INFO *parent;  /* the parent menu, or NULL for root */
   int bar;                   /* set if it is a top level menu bar */
   int size;                  /* number of items in the menu */
   int sel;                   /* selected item */
   int x, y, w, h;            /* screen position of the menu */
   int (*proc)();             /* callback function */
   BITMAP *saved;             /* saved what was underneath it */
   } MENU_INFO;

//----------------------------------------------------------------------------
// Helper functions for drawing menu objects in a DEGUI style
void _draw_menu (MENU_INFO *m);
void _fill_menu_info(MENU_INFO *m, MENU *menu, MENU_INFO *parent, int bar, int x, int y);
int _menu_alt_key(int k, MENU *m);
int _do_degui_menu(MENU *menu, MENU_INFO *parent, int bar, int x, int y, int repos, int *dret);

//----------------------------------------------------------------------------
// Some global graphics functions - Some are by Matthias Baas and some from Allegro
//----------------------------------------------------------------------------

/*--------------------------draw_3d_frame-------------------------
  Draws a filled frame in a 3D look.

  Input: bmp   - Allegro Bitmap where to draw the frame
         x1/y1 - Left top position
         x2/y2 - Right bottom position
         c1    - Inside color (<0 = transparent)
         c2    - Left top frame color
         c3    - Right bottom frame color
----------------------------------------------------------------*/
void draw_3d_frame(BITMAP *bmp,int x1,int y1,int x2,int y2,int c1,int c2,int c3);

void draw_3d_circle(BITMAP *bmp,int x1,int y1,int x2,int c1,int c2,int c3);
int degui_textout(BITMAP *bmp, unsigned char *s, int x, int y, int color, int centre);
int degui_strlen(unsigned char *s);
void draw_dotted_rect(BITMAP *bmp,int x1,int y1,int x2,int y2,int c);

//----------------------------------------------------------------------------
// Some helper functions
//----------------------------------------------------------------------------
int inside_rect(int x, int y,int x1,int y1,int x2,int y2);

//----------------------------------------------------------------------------
// Some global error handling procedures
//----------------------------------------------------------------------------
// General error handling procedure
void degui_error (const char *message);

// Simplified error handling
void degui_no_memory (void);

//----------------------------------------------------------------------------
#ifdef __cplusplus
}
#endif
//----------------------------------------------------------------------------
#endif

