// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "scene.h"
#include <allegro.h>
#include "renderingengine.h"
using namespace Renderer;
using namespace Application::Scenery;

namespace Application
{
	namespace Sessions
	{
		class Session
		{
			protected:
				void SetupMouse();
				bool _midiPlayer;
			public:
				virtual Scene* getScene() const;
				virtual void HandleUserInput() = 0;
				virtual void HandleMovement();
				virtual void PopulateRenderingBuffer() = 0;
				virtual void Destruct() = 0;
		};
	}
}