// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "scoreboard.h"

namespace GameEngine
{
	namespace Actors
	{
		ScoreBoard* ScoreBoard::_scoreBoard = 0;
		
		ScoreBoard* ScoreBoard::getInstance()
		{
			return ( _scoreBoard == 0 ) ? _scoreBoard = new ScoreBoard() : _scoreBoard;
		}

		ScoreBoard::ScoreBoard():
		_score(0),
		_drawBitmap( create_bitmap(SCOREBOARD_W, SCOREBOARD_H) )
		{
			changeScore(Nothing);
		}

		ScoreBoard::~ScoreBoard()
		{
			destroy_bitmap( _drawBitmap );
		}

		void ScoreBoard::changeScore( ChangeScoreTypes changeScoreType )
		{
			_score += (int)changeScoreType;
			DrawScore();
		}

		BITMAP* ScoreBoard::getBitmap() const
		{	
			return _drawBitmap;
		}

		void ScoreBoard::DrawScore()
		{
			clear_to_color( _drawBitmap, makecol(255, 0, 255) );

			unsigned int toShow = _score;
			int index  = 0;
			int x = SCOREBOARD_W - NEXT_NUMBER;

			if ( toShow == 0 )
			{
				blit( ScreenDataFile::getInstance()->getScreen( Num0 ), _drawBitmap, 0, 0, x, 0, NUM_W, NUM_H ); 
			}
			else
			{
				while( toShow > 0 )
				{
					index = toShow % 10 ;
					toShow = toShow / 10;
					blit( ScreenDataFile::getInstance()->getScreen( (ScreenTypes)(index + NUMBERS_LOCATION) ), _drawBitmap, 0, 0, x, 0, NUM_W, NUM_H ); 
					x = x - NEXT_NUMBER;
				}
			}
		}

		unsigned int ScoreBoard::getCurrentScore()
		{
			return _score;
		}
	}
}