// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "point.h"

namespace DataStructures
{
	class Rectangle
	{
		private:
			Point* _location;
			Point* _rightPoint;
			int _width;
			int _height;
		public:
			Rectangle( Point*, int, int );
			~Rectangle();
			int getWidth() const;
			int getHeight() const;
			Point* getLeft() const;
			Point* getLowerRight();
			Point* getLowerLeft();
			void setWidth( int );
			void setHeight( int );
			void setLeft( Point* );
			bool Contains( Point* );
			bool IntersectsWith( Rectangle* );
	};
}