// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "rectangle.h"

namespace DataStructures
{
	Rectangle::Rectangle( Point* Location, int Height, int Width ):
	_location(Location), _height( Height ), _width( Width ), _rightPoint( 0 )
	{
	}

	Rectangle::~Rectangle()
	{
		if ( _rightPoint != 0 )
		{
			delete _rightPoint;
			_rightPoint = 0;
		}
	}

	void Rectangle::setHeight( int Height )
	{
		_height = Height;
	}

	void Rectangle::setWidth( int Width )
	{
		_width = Width;
	}

	void Rectangle::setLeft( Point* Location )
	{
		_location = Location;
	}

	int Rectangle::getHeight() const
	{
		return _height;
	}

	int Rectangle::getWidth() const
	{
		return _width;
	}

	Point* Rectangle::getLeft() const
	{
		return _location;
	}

	Point* Rectangle::getLowerRight()
	{
		if ( _rightPoint != 0 ) delete _rightPoint;
		return _rightPoint = new Point( _location->x + _height, _location->y + _width );
	}

	bool Rectangle::Contains( Point* Point )
	{
		return ( Point->x > _location->x && Point->x < _location->x + _width && Point->y > _location->y && Point->y < _location->y + _height );
	}

	bool Rectangle::IntersectsWith( Rectangle* Rectangle )
	{
		Point* RectangleRight = Rectangle->getLowerRight();
		Point* Right = getLowerRight();
		bool result = true;
		if ( RectangleRight != 0 && Right != 0 )
			result = ( _location->y > RectangleRight->y || _location->x > RectangleRight->x || Right->x < Rectangle->_location->x || Right->y < Rectangle->_location->y );
		return !result;
	}
}