// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "playerpanel.h"

namespace GameEngine
{
	namespace Actors
	{
		PlayerPanel::PlayerPanel():
		_playerLives( GameSettings::getInstance()->getPlayerLives() ), _scoreBoard( new ScoreBoard() ), _drawBitmap( create_bitmap(SCREEN_W, PANEL_H) )
		{
			_location = new Point( POSITION_X, POSITION_Y );
		}

		PlayerPanel::~PlayerPanel()
		{
			destroy_bitmap( _drawBitmap );
		}

		void PlayerPanel::DecreasePlayerLives()
		{
			_playerLives--;
		}

		int PlayerPanel::getPlayerLives() const
		{
			return _playerLives;
		}

		ScoreBoard* PlayerPanel::getScoreBoard() const
		{
			return _scoreBoard;
		}

		BITMAP* PlayerPanel::getBitmap() const
		{
			int x = 0;
			unsigned int i;

			clear_to_color( _drawBitmap, makecol(255, 0, 255) );

			for(i = 0; i < _playerLives ; i++)
			{
				blit( ScreenDataFile::getInstance()->getScreen( PlayerLives ), _drawBitmap, 0, 0, x, 0, SCREEN_W, PANEL_H ); 
				x = x + NEXT_LIVE;
			}

			blit( _scoreBoard->getBitmap(), _drawBitmap, 0, 0, SCREEN_W - SCOREBOARD_W, 0, SCREEN_W, PANEL_H );

			return _drawBitmap;
		}
	}
}