// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "AnimationFacade.h"
#include "playerdatafile.h"
using namespace GameContent;
#include "gamesettings.h"
#include "alienbullet.h"
#include "statesfacade.h"
#include "sounddatafile.h"

namespace GameEngine
{
	namespace Actors
	{
		enum PlayerStates { PlayerAlive, PlayerExploding, PlayerDead };
		
		class Player : public Actor, public AnimationFacade, public StatesFacade<PlayerStates>
		{
			private:
				PlayerTypes _playerType;
				void setCurrentFrame();
				void stateChanged();
			public:
				Player( PlayerTypes );
				void Move( MoveDirection );
				Point* getBulletStartLocation();
				bool CheckForCollision( AlienBullet* );
				BITMAP* getBitmap() const;
				void Move();
		};
	}
}