// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "platformpart.h"
#include "gamesession.h"
using namespace Application::Sessions;

namespace GameEngine
{
	namespace Actors
	{
		PlatformPart::PlatformPart( Point* Location, PlatformTiles Tile )
		{
			_tile = Tile;
			_location = Location;
		}

		void PlatformPart::setCurrentFrame()
		{
			if ( _currentFrame > 5 )
				RemoveFromContainer();
		}

		BITMAP* PlatformPart::getBitmap() const
		{
			return PlatformDataFile::getInstance()->getPlatformFrame( _tile, _currentFrame );
		}

		bool PlatformPart::CheckForCollision( Actor* Actor )
		{
			bool collision = Actor->getRectangle()->IntersectsWith( getRectangle() );
			if ( collision )
			{
				_currentFrame += ((GameSession*)SessionManager::getInstance()->getCurrentSession())->getLevel()->getPlatformDestructionLevel();
				setCurrentFrame();
			}
			return collision;
		}
	}
}