// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "PlatformDataFile.h"

namespace GameContent
{
	PlatformDataFile* PlatformDataFile::_platformDataFile = NULL;
	
	PlatformDataFile::PlatformDataFile()
	{
		setFileName( PLATFORM_FILE_NAME );
	}

	BITMAP* PlatformDataFile::getPlatformFrame( PlatformTiles tile, int Frame )
	{
		switch( tile )
		{
			case solid:
				return getBitmap( Frame + 12 );
			case rightSlope:
				return getBitmap( Frame + 6 );
			case leftSlope:
				return getBitmap( Frame );
		}

		return NULL;
	}

	PlatformDataFile* PlatformDataFile::getInstance()
	{
		return ( _platformDataFile == NULL ) ? _platformDataFile = new PlatformDataFile() : _platformDataFile;
	}
}