// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "session.h"
#include "Rectangle.h"
using namespace DataStructures;
#include "highscoresession.h"
#include "sounddatafile.h"
using namespace GameContent;
#include "sessionmanager.h"
using namespace Application;
#include "gamesession.h"
#include "imageactor.h"
using namespace GameEngine;

#define PLAY_AREA_X		240
#define PLAY_AREA_Y		195
#define PLAY_AREA_H		30
#define PLAY_AREA_W		170
#define OPTIONS_AREA_X	255
#define OPTIONS_AREA_Y	235
#define OPTIONS_AREA_H	30
#define OPTIONS_AREA_W  140
#define SCORES_AREA_X	220
#define SCORES_AREA_Y	275
#define SCORES_AREA_H	30
#define SCORES_AREA_W	210
#define EXIT_AREA_X		282
#define EXIT_AREA_Y		315
#define EXIT_AREA_H		30
#define EXIT_AREA_W		85

namespace Application
{
	namespace Sessions
	{
		class MainMenuSession : public Session
		{
			private:
				Rectangle* _playArea;
				Rectangle* _optionsArea;
				Rectangle* _scoresArea;
				Rectangle* _exitArea;
				bool _firstScreen;
				ImageActor* _backgroundActor;
			public:
				MainMenuSession();
				MainMenuSession( bool );
				void Destruct();
				void HandleUserInput();
				void PopulateRenderingBuffer();
				Scene* getScene();
		};
	}
}
