// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "mainmenusession.h"

namespace Application
{
	namespace Sessions
	{
		MainMenuSession::MainMenuSession():
		_playArea( new Rectangle( new Point( PLAY_AREA_X, PLAY_AREA_Y ), PLAY_AREA_H, PLAY_AREA_W ) ),
		_optionsArea( new Rectangle( new Point( OPTIONS_AREA_X, OPTIONS_AREA_Y ), OPTIONS_AREA_H, OPTIONS_AREA_W ) ),
		_scoresArea( new Rectangle( new Point( SCORES_AREA_X, SCORES_AREA_Y ), SCORES_AREA_H, SCORES_AREA_W ) ),
		_exitArea( new Rectangle( new Point( EXIT_AREA_X, EXIT_AREA_Y ), EXIT_AREA_H, EXIT_AREA_W ) ), _firstScreen( false ), _backgroundActor ( new ImageActor( ScreenDataFile::getInstance()->getScreen( MainMenuScreen ) ) ) 
		{
			_midiPlayer = true;
		}

		MainMenuSession::MainMenuSession( bool status ):
		_playArea( new Rectangle( new Point( PLAY_AREA_X, PLAY_AREA_Y ), PLAY_AREA_H, PLAY_AREA_W ) ),
		_optionsArea( new Rectangle( new Point( OPTIONS_AREA_X, OPTIONS_AREA_Y ), OPTIONS_AREA_H, OPTIONS_AREA_W ) ),
		_scoresArea( new Rectangle( new Point( SCORES_AREA_X, SCORES_AREA_Y ), SCORES_AREA_H, SCORES_AREA_W ) ),
		_exitArea( new Rectangle( new Point( EXIT_AREA_X, EXIT_AREA_Y ), EXIT_AREA_H, EXIT_AREA_W ) ), _firstScreen( false ), _backgroundActor ( new ImageActor( ScreenDataFile::getInstance()->getScreen( MainMenuScreen ) ) ) 
		{
			_midiPlayer = status;
		}

		void MainMenuSession::Destruct()
		{
			delete _playArea;
			delete _optionsArea;
			delete _scoresArea;
			delete _exitArea;
		}

		void MainMenuSession::HandleUserInput()
		{
			Point* mousePoint = new Point( mouse_x, mouse_y );

			if ( (mouse_b & 1 && _playArea->Contains( mousePoint ) ) || key[KEY_P] )
			{
				play_midi( NULL, false );
				play_sample( SoundDataFile::getInstance()->getSampleSound( start ), 200, 125, 1000, 0 );
				show_mouse(NULL);
				SessionManager::getInstance()->setNextSession( new GameSession( Level1 ) );
			}

			if ( (mouse_b & 1 && _scoresArea->Contains( mousePoint ) ) || key[KEY_H] )
				SessionManager::getInstance()->setNextSession( new HighscoreSession( _midiPlayer ) );

			if ( (mouse_b & 1 && _exitArea->Contains( mousePoint ) ) || key[KEY_X] )
				SessionManager::getInstance()->Stop();

			if ( key[KEY_M] )
			{
				if ( _midiPlayer )
					midi_pause();
				else
					midi_resume();

				_midiPlayer = !_midiPlayer;
			}
			
			delete mousePoint;
		}

		void MainMenuSession::PopulateRenderingBuffer()
		{
			if ( !_firstScreen )
			{
				scare_mouse();
				_backgroundActor->Render( screen );
				unscare_mouse();
				show_mouse(screen);
				_firstScreen = true;
			}
		}

		Scene* MainMenuSession::getScene()
		{
			return NULL;
		}
	}
}