// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "levelloader.h"
#include "itemlist.cpp"

namespace GameContent
{
	LevelLoader* LevelLoader::_levelLoader = 0;

	LevelLoader::LevelLoader():
	_levels( new ItemList<Level*>() )
	{
		PopulateList();
	}

	LevelLoader::~LevelLoader()
	{
		delete _levels;
	}

	void LevelLoader::PopulateList()
	{
		_levels->Insert( SettingsReader::getLevel("level1.xml") );
		_levels->Insert( SettingsReader::getLevel("level2.xml") );
		_levels->Insert( SettingsReader::getLevel("level3.xml") );
		_levels->Insert( SettingsReader::getLevel("level4.xml") );
		_levels->Insert( SettingsReader::getLevel("level5.xml") );
		_levels->Insert( SettingsReader::getLevel("level6.xml") );
	}
	
	Level* LevelLoader::Load( Levels LevelType ) const
	{
		return _levels->operator []( LevelType );
	}

	LevelLoader* LevelLoader::getInstance()
	{
		return ( _levelLoader == 0 ) ? _levelLoader = new LevelLoader() : _levelLoader;
	}
}