// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#include "itemlist.h"

namespace DataStructures
{
	template <class T>
	ItemList<T>::ItemList():
	_innerList( new list<T>() )
	{
	}

	template <class T>
	ItemList<T>::~ItemList()
	{
		if ( _innerList != NULL )
		{
			Purge();
			delete _innerList;
		}
	}

	template <class T>
	void ItemList<T>::Insert( ListItem* item )
	{
		if ( item->getContainer() == NULL )
		{
			((ListItem*)item)->setContainer( this );
			_innerList->push_back((T)item);
		}
	}

	template <class T>
	void ItemList<T>::Delete( ListItem* item )
	{
		if ( item->getContainer() == this )
		{
			item->setContainer( NULL );
			_innerList->remove((T)item);
			delete (T)item;
		}
	}

	template <class T>
	void ItemList<T>::Purge()
	{
		for ( list<T>::reverse_iterator iterator = _innerList->rbegin(); iterator != _innerList->rend(); ++iterator )
			delete *iterator;
	}

	template <class T>
	const unsigned int ItemList<T>::getSize()
	{
		return _innerList->size();
	}

	template <class T>
	list<T>* ItemList<T>::getInnerList()
	{
		return _innerList;
	}

	template <class T>
	T ItemList<T>::operator[]( unsigned int pos )
	{
		if ( !_innerList->empty() )
		{
			unsigned int i=0;
			for ( list<T>::const_iterator iterator = _innerList->begin(); iterator != _innerList->end() && i <= pos;  ++iterator, i++ )
					if ( i == pos ) return *iterator;
		}

		return NULL;
	}
}