// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "imageactor.h"

namespace GameEngine
{
	namespace Actors
	{
		ImageActor::ImageActor( BITMAP* Image ):
		_image( create_bitmap( SCREEN_W, SCREEN_H ) )
		{
			_location = new Point(0,0);
			setImage( Image );
		}

		void ImageActor::StretchImage( BITMAP* Image )
		{
			_image = create_bitmap( SCREEN_W, SCREEN_H );
			stretch_blit(Image, _image, 0, 0, Image->w, Image->h, 0, 0, SCREEN_W, SCREEN_H );
		}

		void ImageActor::setImage( BITMAP* Image )
		{
			StretchImage( Image );
		}

		BITMAP* ImageActor::getBitmap() const
		{
			return _image;
		}
		
		void ImageActor::Render( BITMAP* buffer )
		{
			Actor::Blit( buffer, _image );
		}

		ImageActor::~ImageActor()
		{
			destroy_bitmap( _image );
		}
	}
}