// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "highscoresession.h"

namespace Application
{
	namespace Sessions
	{
		HighscoreSession::HighscoreSession( bool status ):
		_firstScreen( false ), _backgroundActor ( new ImageActor( ScreenDataFile::getInstance()->getScreen( HighScoreScreen ) ) )
		{
			_midiPlayer = status;

			list<ScoreElement>* scoreList = HighscoreManager::getInstance()->getScoreList();

			for(int i = 0; i < LINES; i++)
				output[i] = "";
			char tmp[20];
			scoreList->sort();
			scoreList->reverse();
			i = 0;
			for ( list<ScoreElement>::iterator iterator = scoreList->begin(); iterator != scoreList->end(); ++iterator )
			{
				output[i] = output[i] + iterator->getName();
				itoa( iterator->getScore(), tmp, 10 );
				output[i] = output[i] + " ";
				output[i] = output[i] + tmp;
				i++;
			}
		}

		void HighscoreSession::Destruct()
		{
			delete _backgroundActor;
		}

		void HighscoreSession::HandleUserInput()
		{
			if ( key[KEY_M] )
			{
				if ( _midiPlayer )
					midi_pause();
				else
					midi_resume();

				_midiPlayer = !_midiPlayer;
			}
			
			if ( key[KEY_ESC] )
				SessionManager::getInstance()->setNextSession( new MainMenuSession( _midiPlayer ) );
		}

		void HighscoreSession::PopulateRenderingBuffer()
		{
			if ( !_firstScreen )
			{
				list<ScoreElement>* scoreList = HighscoreManager::getInstance()->getScoreList();

				text_mode(-1);	
				scare_mouse();
				_backgroundActor->Render( screen );
				for(int i = 0; i < scoreList->size(); i++)
					textout( screen, font, output[i].c_str(), 200, 200+i*20,  makecol(0, 0, 0));
				unscare_mouse();
				_firstScreen = true;
			}
		}	
	}
}