// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "HighscoreManager.h"

namespace GameEngine
{
	namespace Managers
	{
		HighscoreManager* HighscoreManager::_highscoreManager = 0;
		
		HighscoreManager* HighscoreManager::getInstance()
		{
			return ( _highscoreManager == 0 ) ? _highscoreManager = new HighscoreManager() : _highscoreManager;
		}

		HighscoreManager::HighscoreManager():
		_scoreList( new list<ScoreElement>() )
		{
			Load();
		}

		HighscoreManager::~HighscoreManager()
		{
			Save();
			delete _scoreList;
		}

		void HighscoreManager::Load()
		{
			ifstream infile( SCORE_FILE, ios::in );
		
			if ( infile )
			{
				int count = 0;
				do
				{
					ScoreElement scoreElement;
					infile.read( (char*)&scoreElement, sizeof(scoreElement) );
					_scoreList->push_back( scoreElement );
				}
				while ( ++count != LAST_ELEMENT );
			}
			else
				Define();
		
			infile.close();
		}

		void HighscoreManager::Save()
		{
			ofstream outfile( SCORE_FILE, ios_base::binary );
			int count = 0;
			for ( list<ScoreElement>::iterator iterator = _scoreList->begin(); iterator != _scoreList->end() && count != LAST_ELEMENT; ++iterator, ++count )
			{
				ScoreElement element = *iterator;
				outfile.write( (char*)&element, sizeof(element) );
			}
			
			outfile.close();
		}

		list<ScoreElement>* HighscoreManager::getScoreList() const
		{
			return _scoreList;
		}

		void HighscoreManager::Define()
		{
			_scoreList->push_back( ScoreElement( "ABC", 100 ) );
			_scoreList->push_back( ScoreElement( "DEF", 500 ) );
			_scoreList->push_back( ScoreElement( "SSE", 150 ) );
			_scoreList->push_back( ScoreElement( "MMX", 150 ) );
		}
	}
}