// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "gamescene.h"
#include "scene.cpp"

namespace Application
{
	namespace Scenery
	{
		GameScene::GameScene( AlienTypes AlienType ):
		_aliens( new ItemList<Alien*>() ), _bonusShip( new BonusShip() ), _player( new Player( BigPlayer ) ), _playerBullets( new ItemList<PlayerBullet*>() ), _alienBullets( new ItemList<AlienBullet*>() ), _platformParts( new ItemList<PlatformPart*>() )
		{	
			setBackgroundActor();
			PopulateAlienList( AlienType );
			PopulatePlatformList();
		}

		void GameScene::setBackgroundActor()
		{
			DataFile* dataFile = new DataFile( BACKGROUNDS_FILE_NAME );
			_backgroundActor = new ImageActor( dataFile->getBitmap(Random::GetNumber(0,17)) );
			delete dataFile;
		}

		void GameScene::PopulateAlienList( AlienTypes AlienType )
		{
			for ( int i=0; i<ALIENS_PER_LINE; i++ )
				for ( int j=0; j<ALIEN_LINES; j++ )
				{
					Alien* alien = new Alien( AlienType );
					alien->setLocation( new Point( i * ( alien->getWidth() + SEPERATION_WIDTH ) + 10, j * ( alien->getHeight() + SEPERATION_HEIGHT ) + 100 ) );
					_aliens->Insert( alien );
				}
		}

		void GameScene::PopulatePlatformList()
		{
			int a=35;
			int space = SCREEN_W/4;
			for ( int i=0; i<PLATFORMS_NUM; i++, a+=space )
				PopulatePlatformPartList( new Point(a, SCREEN_H - 130) );
		}

		void GameScene::PopulatePlatformPartList( Point* point )
		{
			_platformParts->Insert( new PlatformPart( point, leftSlope ) );
			int width = _platformParts->operator[](0)->getWidth();
			int height = _platformParts->operator[](0)->getHeight();
			_platformParts->Insert( new PlatformPart( new Point(point->x+width,point->y), solid ) );
			_platformParts->Insert( new PlatformPart( new Point(point->x+width*2,point->y), rightSlope ) );
			_platformParts->Insert( new PlatformPart( new Point(point->x,point->y+height), solid ) );
			_platformParts->Insert( new PlatformPart( new Point(point->x+width*2,point->y+height), solid ) );
		}
		
		GameScene::~GameScene()
		{
			delete _aliens;
			delete _playerBullets;
			delete _alienBullets;
			delete _player;
			delete _backgroundActor;
			delete _platformParts;
			delete _bonusShip;
		}

		ItemList<AlienBullet*>* GameScene::getAlienBullets() const
		{
			return _alienBullets;
		}

		ItemList<PlayerBullet*>* GameScene::getPlayerBullets() const
		{
			return _playerBullets;
		}

		ItemList<PlatformPart*>* GameScene::getPlatformParts() const
		{
			return _platformParts;
		}

		Player* GameScene::getPlayer() const
		{
			return _player;
		}

		ImageActor* GameScene::getBackgroundActor() const
		{
			return _backgroundActor;
		}

		void GameScene::PopulateRenderingBuffer( BITMAP* Buffer )
		{
			_backgroundActor->Render( Buffer );

			list<Alien*>* alienList = _aliens->getInnerList();
			for ( list<Alien*>::const_iterator alienIterator = alienList->begin(); alienIterator != alienList->end(); ++alienIterator )
				(*alienIterator)->Render( Buffer );

			list<PlayerBullet*>* playerList = _playerBullets->getInnerList();
			for ( list<PlayerBullet*>::const_iterator playerIterator = playerList->begin(); playerIterator != playerList->end(); ++playerIterator )
				(*playerIterator)->Render( Buffer );

			list<AlienBullet*>* alienBulletList = _alienBullets->getInnerList();
			for ( list<AlienBullet*>::const_iterator alienBulletIterator = alienBulletList->begin(); alienBulletIterator != alienBulletList->end(); ++alienBulletIterator )
				(*alienBulletIterator)->Render( Buffer );

			list<PlatformPart*>* platformPartsList = _platformParts->getInnerList();
			for ( list<PlatformPart*>::const_iterator platformIterator = platformPartsList->begin(); platformIterator != platformPartsList->end(); ++platformIterator )
				(*platformIterator)->Render( Buffer );

			_bonusShip->Render( Buffer );
			_player->Render( Buffer );
		}

		ItemList<Alien*>* GameScene::getAliens() const
		{
			return _aliens;
		}

		BonusShip* GameScene::getBonusShip() const
		{
			return _bonusShip;
		}
	}
}