// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "datafile.h"

namespace GameContent
{
	DataFile::DataFile():
	_dataFile(NULL)
	{
	}

	DataFile::DataFile( char* FileName ):
	_fileName(FileName), _dataFile(NULL)
	{
		LoadContents();
	}

	DataFile::~DataFile()
	{
		ClearDataFile();
	}

	char* DataFile::getFileName() const
	{
		return _fileName;
	}

	void DataFile::setFileName( char* FileName )
	{
		_fileName = FileName;
		LoadContents();
	}

	BITMAP* DataFile::getBitmap( int Position ) const
	{
		return ( _dataFile != NULL ) ? (BITMAP*)_dataFile[Position].dat : NULL;
	}

	SAMPLE* DataFile::getSample( int Position ) const
	{
		return ( _dataFile != NULL ) ? (SAMPLE*)_dataFile[Position].dat : NULL;
	}

	MIDI* DataFile::getMidi( int Position ) const
	{
		return ( _dataFile != NULL ) ? (MIDI*)_dataFile[Position].dat : NULL;
	}

	void DataFile::LoadContents()
	{
		ClearDataFile();
		_dataFile = load_datafile( _fileName );
		if ( _dataFile == NULL )
			allegro_message( _fileName );
	}

	void DataFile::ClearDataFile()
	{
		if ( _dataFile != NULL )
			unload_datafile(_dataFile);
	}
}